/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.extensions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.spencerwi.either.Either;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Spliterators;
import java.util.Vector;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.intocps.maestro.interpreter.api.IValueLifecycleHandler;
import org.intocps.maestro.interpreter.extensions.BaseLifecycleHandler;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.csv.CsvDataWriter;
import org.intocps.maestro.interpreter.values.datawriter.DataWriterValue;
import org.intocps.maestro.interpreter.values.datawriter.IDataListener;
import org.intocps.maestro.interpreter.values.datawriter.IntervalDataWriter;
import org.intocps.maestro.interpreter.values.datawriter.WebSocketDataWriter;

@IValueLifecycleHandler.ValueLifecycle(name="DataWriter")
public class DataWriterLifecycleHandler
extends BaseLifecycleHandler {
    static final String DEFAULT_CSV_FILENAME = "outputs.csv";
    final String DATA_WRITER_TYPE_NAME = this.getClass().getAnnotation(IValueLifecycleHandler.ValueLifecycle.class).name();
    final List<Supplier<IDataListener>> writers = new Vector<Supplier<IDataListener>>();

    private boolean isTextEqual(JsonNode node, String text) {
        return node.isTextual() && node.asText().equals(text);
    }

    private String getMemberText(JsonNode node, String memberName) {
        if (node.hasNonNull(memberName) && node.get(memberName).isTextual()) {
            return node.get(memberName).asText();
        }
        return null;
    }

    public DataWriterLifecycleHandler(File workingDirectory, InputStream config) throws IOException {
        JsonNode configTree;
        if (config != null && (configTree = new ObjectMapper().readTree(config)).has(this.DATA_WRITER_TYPE_NAME)) {
            JsonNode dwConfig = configTree.get(this.DATA_WRITER_TYPE_NAME);
            for (JsonNode val : dwConfig) {
                String dataWriterFileName;
                if (!val.hasNonNull("type")) continue;
                JsonNode typeNode = val.get("type");
                if (this.isTextEqual(typeNode, "CSV")) {
                    String filename = this.getMemberText(dwConfig, "filename");
                    dataWriterFileName = filename == null ? DEFAULT_CSV_FILENAME : filename;
                    List<String> filter = DataWriterLifecycleHandler.getFilter(val);
                    this.writers.add(() -> new CsvDataWriter(workingDirectory == null ? new File(dataWriterFileName) : new File(workingDirectory, dataWriterFileName), filter));
                    continue;
                }
                if (this.isTextEqual(typeNode, "CSV_LiveStream")) {
                    String filename = this.getMemberText(dwConfig, "filename");
                    dataWriterFileName = filename == null ? "livestream.csv" : filename;
                    List<String> filter = DataWriterLifecycleHandler.getFilter(val);
                    double interval = 0.1;
                    if (val.hasNonNull("interval") && val.get("interval").isNumber()) {
                        interval = val.get("interval").asDouble();
                    }
                    double finalInterval = interval;
                    this.writers.add(() -> new IntervalDataWriter(finalInterval, new CsvDataWriter(workingDirectory == null ? new File(dataWriterFileName) : new File(workingDirectory, dataWriterFileName), filter)));
                    continue;
                }
                if (!this.isTextEqual(typeNode, "WebSocket")) continue;
                int port = val.get("port").asInt(8082);
                List<String> filter = DataWriterLifecycleHandler.getFilter(val);
                double interval = 0.1;
                if (val.hasNonNull("interval") && val.get("interval").isNumber()) {
                    interval = val.get("interval").asDouble();
                }
                double finalInterval = interval;
                this.writers.add(() -> new IntervalDataWriter(finalInterval, new WebSocketDataWriter(port, filter)));
            }
        }
    }

    private static List<String> getFilter(JsonNode val) {
        if (val.hasNonNull("filter")) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(val.get("filter").iterator(), 16), false).map(JsonNode::asText).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Either<Exception, Value> instantiate(List<Value> args) {
        return Either.right((Object)new DataWriterValue(this.writers.stream().map(Supplier::get).collect(Collectors.toList())));
    }
}

