/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.extensions;

import com.spencerwi.either.Either;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.interpreter.Fmi2Interpreter;
import org.intocps.maestro.interpreter.api.IValueLifecycleHandler;
import org.intocps.maestro.interpreter.extensions.BaseLifecycleHandler;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.fmi.FmuValue;

@IValueLifecycleHandler.ValueLifecycle(name="JFMI2")
public class JFmi2LifecycleHandler
extends BaseLifecycleHandler {
    private final File workingDirectory;

    public JFmi2LifecycleHandler(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    @Override
    public void destroy(Value value) {
        if (value instanceof FmuValue) {
            FmuValue fmuVal = (FmuValue)value;
            FunctionValue unloadFunction = (FunctionValue)fmuVal.lookup("unload");
            unloadFunction.evaluate(Collections.emptyList());
        }
    }

    @Override
    public Either<Exception, Value> instantiate(List<Value> args) {
        String className = ((StringValue)args.get(0)).getValue();
        try {
            Class<?> clz = this.getClass().getClassLoader().loadClass(className);
            return Either.right((Object)new Fmi2Interpreter(this.workingDirectory).createFmiValue(clz));
        }
        catch (ClassNotFoundException e) {
            return Either.left((Object)new AnalysisException("The path passed to load is not a URI", (Throwable)e));
        }
    }
}

