/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.external;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.node.AArrayType;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.AByteNumericPrimitiveType;
import org.intocps.maestro.ast.node.AFloatNumericPrimitiveType;
import org.intocps.maestro.ast.node.AFormalParameter;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.ALongNumericPrimitiveType;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.AReferenceType;
import org.intocps.maestro.ast.node.AShortNumericPrimitiveType;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.AUIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.AVoidType;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.interpreter.Fmi2Interpreter;
import org.intocps.maestro.interpreter.external.IArgMapping;
import org.intocps.maestro.interpreter.external.TP;
import org.intocps.maestro.interpreter.values.ArrayValue;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.ByteValue;
import org.intocps.maestro.interpreter.values.FloatValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.LongValue;
import org.intocps.maestro.interpreter.values.NumericValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.ShortValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.UpdatableValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;

public class ExternalReflectCallHelper
extends Vector<IArgMapping> {
    protected final String functionName;
    protected final Object object;
    protected IArgMapping returnArg = null;

    public ExternalReflectCallHelper(String functionName, Object object) {
        this.functionName = functionName;
        this.object = object;
    }

    public ExternalReflectCallHelper(AFunctionDeclaration functionDeclaration, Object object, Function<ArgMappingContext, IArgMapping> costumeArgMapper) {
        this(functionDeclaration.getName().getText(), object);
        this.autoBuild(functionDeclaration, costumeArgMapper);
    }

    public ExternalReflectCallHelper(AFunctionDeclaration functionDeclaration, Object object) {
        this(functionDeclaration, object, null);
    }

    public static Map.Entry<TP, Integer> getReverseType(PType t) throws ExceptionUnknownTypeMapping {
        if (t instanceof AArrayType) {
            AArrayType at = (AArrayType)t;
            return Map.entry(ExternalReflectCallHelper.getReverseType(at.getType()).getKey(), 2);
        }
        if (t instanceof AReferenceType) {
            return ExternalReflectCallHelper.getReverseType(((AReferenceType)t).getType());
        }
        HashMap<Class<? extends PType>, TP> mapping = new HashMap<Class<? extends PType>, TP>(){
            {
                this.put(ABooleanPrimitiveType.class, TP.Bool);
                this.put(AByteNumericPrimitiveType.class, TP.Byte);
                this.put(AShortNumericPrimitiveType.class, TP.Short);
                this.put(AIntNumericPrimitiveType.class, TP.Int);
                this.put(AUIntNumericPrimitiveType.class, TP.Long);
                this.put(AFloatNumericPrimitiveType.class, TP.Float);
                this.put(ARealNumericPrimitiveType.class, TP.Real);
                this.put(ALongNumericPrimitiveType.class, TP.Long);
                this.put(AStringPrimitiveType.class, TP.String);
            }
        };
        TP tp = (TP)((Object)mapping.get(t.getClass()));
        if (tp == null) {
            throw new ExceptionUnknownTypeMapping("Type mapping unknown for the type: " + String.valueOf(t));
        }
        return Map.entry(tp, 1);
    }

    public String getSignature(boolean body) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("public ");
        if (this.returnArg != null) {
            sb.append(this.returnArg.getType().getSimpleName());
        } else {
            sb.append("void");
        }
        sb.append(" ");
        sb.append(this.functionName);
        sb.append("(");
        for (i = 0; i < this.size(); ++i) {
            sb.append(((IArgMapping)this.get(i)).getType().getSimpleName());
            sb.append(" arg" + i);
            if (i + 1 >= this.size()) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (body) {
            sb.append("{");
            for (i = 0; i < this.size(); ++i) {
                IArgMapping argMapping = (IArgMapping)this.get(i);
                if (argMapping.getDirection() != ArgMapping.InOut.Output) continue;
                sb.append("arg" + i + "[0] = ");
                sb.append(this.returnArg.getDefaultTestValue());
                sb.append(";");
            }
            if (this.returnArg != null) {
                sb.append("return " + this.returnArg.getDefaultTestValue() + ";");
                sb.append("}");
            }
        } else {
            sb.append(";");
        }
        return sb.toString();
    }

    @Override
    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSignature(false) + "\n");
        sb.append(this.functionName);
        sb.append("\n");
        for (int i = 0; i < this.size(); ++i) {
            IArgMapping argMapping = (IArgMapping)this.get(i);
            sb.append(String.format("\t%2d: ", i));
            sb.append(String.format("%-6s", new Object[]{argMapping.getDirection()}));
            sb.append(" ");
            sb.append(String.format("%-8s", argMapping.getDescriptiveName() + IntStream.range(1, argMapping.getDimension()).mapToObj(n -> "[]").collect(Collectors.joining())));
            sb.append(" -- ");
            sb.append(argMapping.getType().getSimpleName());
            sb.append("\n");
        }
        if (this.returnArg != null) {
            sb.append("\t *: ");
            sb.append(String.format("%-6s", new Object[]{this.returnArg.getDirection()}));
            sb.append(" ");
            sb.append(String.format("%-8s", this.returnArg.getDescriptiveName() + IntStream.range(1, this.returnArg.getDimension()).mapToObj(n -> "[]").collect(Collectors.joining())));
            sb.append(" -- ");
            sb.append(this.returnArg.getType().getSimpleName());
            sb.append("\n");
        }
        return sb.toString();
    }

    private void autoBuild(AFunctionDeclaration functionDeclaration, Function<ArgMappingContext, IArgMapping> costumeArgMapper) {
        PType returnType = functionDeclaration.getReturnType();
        if (returnType != null && !(returnType instanceof AVoidType)) {
            try {
                IArgMapping ca;
                if (costumeArgMapper != null && (ca = costumeArgMapper.apply(new ArgMappingContext(this.functionName, null, returnType))) != null) {
                    this.addReturn(ca);
                } else {
                    this.addReturn(ExternalReflectCallHelper.getReverseType(returnType).getKey());
                }
            }
            catch (ExceptionUnknownTypeMapping e) {
                throw new RuntimeException(e);
            }
        }
        for (AFormalParameter formal : functionDeclaration.getFormals()) {
            try {
                Map.Entry<TP, Integer> tDim = ExternalReflectCallHelper.getReverseType(formal.getType());
                this.addArg(tDim.getKey(), tDim.getValue(), formal.getType() instanceof AReferenceType ? ArgMapping.InOut.Output : ArgMapping.InOut.Input);
            }
            catch (ExceptionUnknownTypeMapping e) {
                IArgMapping ca;
                if (costumeArgMapper != null && (ca = costumeArgMapper.apply(new ArgMappingContext(this.functionName, formal.getName().getText(), formal.getType()))) != null) {
                    this.add(ca);
                    continue;
                }
                throw new RuntimeException(e);
            }
        }
    }

    public ExternalReflectCallHelper addReturn(TP type) {
        return this.addReturn(new ArgMapping(type, 1, ArgMapping.InOut.Output, null));
    }

    public ExternalReflectCallHelper addReturn(IArgMapping returnArg) {
        this.returnArg = returnArg;
        return this;
    }

    public ExternalReflectCallHelper addArg(TP type) {
        this.add(new ArgMapping(type));
        return this;
    }

    public ExternalReflectCallHelper addArg(TP type, int dimiention) {
        this.add(new ArgMapping(type, dimiention, ArgMapping.InOut.Input, null));
        return this;
    }

    public ExternalReflectCallHelper addArg(TP type, int dimiention, ArgMapping.InOut direction) {
        this.add(new ArgMapping(type, dimiention, direction, null));
        return this;
    }

    public ExternalReflectCallHelper addArg(TP type, int dimiention, ArgMapping.InOut direction, long ... limits) {
        this.add(new ArgMapping(type, dimiention, direction, limits));
        return this;
    }

    public FunctionValue.ExternalFunctionValue build() throws NoSuchMethodException {
        List<IArgMapping> args = Collections.unmodifiableList(this);
        IArgMapping rArg = this.returnArg;
        Method method = this.object.getClass().getMethod(this.functionName, (Class[])args.stream().filter(arg -> arg.getDirection() != ArgMapping.InOut.OutputThroughReturn).map(IArgMapping::getType).toArray(Class[]::new));
        return new FunctionValue.ExternalFunctionValue(fcargs -> {
            Fmi2Interpreter.checkArgLength(fcargs, args.size());
            Iterator passedArgItr = fcargs.iterator();
            Iterator declaredArgItr = args.iterator();
            ArrayList<Object> argValues = new ArrayList<Object>(args.size());
            while (passedArgItr.hasNext() && declaredArgItr.hasNext()) {
                Value v = (Value)passedArgItr.next();
                IArgMapping mapper = (IArgMapping)declaredArgItr.next();
                if (mapper.getDirection() == ArgMapping.InOut.OutputThroughReturn) continue;
                argValues.add(mapper.map(v));
            }
            try {
                Object ret = method.invoke(this.object, argValues.toArray());
                passedArgItr = fcargs.iterator();
                Iterator passedValuesItr = argValues.iterator();
                declaredArgItr = args.iterator();
                HashMap<IArgMapping, Value> outputThroughReturn = new HashMap<IArgMapping, Value>();
                while (passedArgItr.hasNext() && declaredArgItr.hasNext()) {
                    IArgMapping mapper = (IArgMapping)declaredArgItr.next();
                    Value original = (Value)passedArgItr.next();
                    if (mapper.getDirection() == ArgMapping.InOut.OutputThroughReturn) {
                        outputThroughReturn.put(mapper, original);
                        continue;
                    }
                    if (!passedValuesItr.hasNext()) continue;
                    Object passedValue = passedValuesItr.next();
                    if (mapper.getDirection() != ArgMapping.InOut.Output) continue;
                    mapper.mapOut(original, passedValue);
                }
                if (rArg == null) {
                    return new VoidValue();
                }
                return rArg.mapOut(ret, outputThroughReturn);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static class ExceptionUnknownTypeMapping
    extends Exception {
        public ExceptionUnknownTypeMapping(String message) {
            super(message);
        }
    }

    public static class ArgMapping
    implements IArgMapping {
        final TP type;
        final int dimension;
        final long[] limits;
        InOut direction;

        public ArgMapping(TP type, int dimension, InOut direction, long[] limits) {
            this.type = type;
            this.dimension = dimension;
            this.direction = direction;
            this.limits = limits;
        }

        public ArgMapping(TP type) {
            this(type, 1, InOut.Input, null);
        }

        @Override
        public int getDimension() {
            return this.dimension;
        }

        @Override
        public long[] getLimits() {
            return this.limits;
        }

        @Override
        public InOut getDirection() {
            return this.direction;
        }

        @Override
        public void setDirection(InOut direction) {
            this.direction = direction;
        }

        @Override
        public Object map(Value v) {
            if (this.direction == InOut.Input) {
                v = v.deref();
            }
            if (this.dimension == 1) {
                switch (this.type) {
                    case Bool: {
                        return ((BooleanValue)v).getValue();
                    }
                    case Byte: {
                        NumericValue n = (NumericValue)v;
                        return Integer.valueOf(n.intValue()).byteValue();
                    }
                    case Float: {
                        NumericValue n = (NumericValue)v;
                        return Float.valueOf(n.floatValue());
                    }
                    case Int: {
                        NumericValue n = (NumericValue)v;
                        return n.intValue();
                    }
                    case Long: {
                        NumericValue n = (NumericValue)v;
                        return n.longValue();
                    }
                    case Real: {
                        NumericValue n = (NumericValue)v;
                        return n.doubleValue();
                    }
                    case Short: {
                        NumericValue n = (NumericValue)v;
                        return Integer.valueOf(n.intValue()).shortValue();
                    }
                    case String: {
                        return ((StringValue)v).getValue();
                    }
                }
            } else if (this.dimension == 2) {
                Optional<Long> limit = this.limits == null ? Optional.empty() : Optional.of(this.limits[0]);
                switch (this.type) {
                    case Bool: {
                        return ArrayUtils.toPrimitive((Boolean[])Fmi2Interpreter.getArrayValue(v, limit, BooleanValue.class).stream().map(BooleanValue::getValue).collect(Collectors.toList()).toArray(new Boolean[0]));
                    }
                    case Byte: {
                        return ArrayUtils.toPrimitive((Byte[])Fmi2Interpreter.getArrayValue(v, limit, NumericValue.class).stream().map(NumericValue::intValue).map((? super T vb) -> vb & 0xFF).map(Integer::byteValue).collect(Collectors.toList()).toArray(new Byte[0]));
                    }
                    case Float: {
                        return ArrayUtils.toPrimitive((Float[])Fmi2Interpreter.getArrayValue(v, limit, NumericValue.class).stream().map(NumericValue::floatValue).collect(Collectors.toList()).toArray(new Float[0]));
                    }
                    case Int: {
                        return ArrayUtils.toPrimitive((Integer[])Fmi2Interpreter.getArrayValue(v, limit, NumericValue.class).stream().map(NumericValue::intValue).collect(Collectors.toList()).toArray(new Integer[0]));
                    }
                    case Long: {
                        return ArrayUtils.toPrimitive((Long[])Fmi2Interpreter.getArrayValue(v, limit, NumericValue.class).stream().map(NumericValue::longValue).collect(Collectors.toList()).toArray(new Long[0]));
                    }
                    case Real: {
                        return Fmi2Interpreter.getArrayValue(v, limit, NumericValue.class).stream().mapToDouble(NumericValue::realValue).toArray();
                    }
                    case Short: {
                        return ArrayUtils.toPrimitive((Short[])Fmi2Interpreter.getArrayValue(v, limit, NumericValue.class).stream().map(NumericValue::intValue).map(Integer::shortValue).collect(Collectors.toList()).toArray(new Short[0]));
                    }
                    case String: {
                        return Fmi2Interpreter.getArrayValue(v, limit, StringValue.class).stream().map(StringValue::getValue).collect(Collectors.toList()).toArray(new String[0]);
                    }
                }
            }
            return null;
        }

        @Override
        public void mapOut(Value original, Object value) {
            UpdatableValue ref = (UpdatableValue)original;
            List values = null;
            if (this.dimension == 2) {
                long elementsToUse = this.limits == null ? Long.MAX_VALUE : this.limits[0];
                switch (this.type) {
                    case Bool: {
                        Object object;
                        if (value.getClass().isArray()) {
                            object = value;
                        } else {
                            boolean[] blArray = new boolean[1];
                            object = blArray;
                            blArray[0] = (Boolean)value;
                        }
                        values = Arrays.stream(ArrayUtils.toObject((boolean[])((boolean[])object))).limit(elementsToUse).map(BooleanValue::new).collect(Collectors.toList());
                        break;
                    }
                    case Byte: {
                        Object object;
                        if (value.getClass().isArray()) {
                            object = value;
                        } else {
                            byte[] byArray = new byte[1];
                            object = byArray;
                            byArray[0] = (Byte)value;
                        }
                        values = Arrays.stream(ArrayUtils.toObject((byte[])((byte[])object))).limit(elementsToUse).map(ByteValue::new).collect(Collectors.toList());
                        break;
                    }
                    case Float: {
                        Object object;
                        if (value.getClass().isArray()) {
                            object = value;
                        } else {
                            float[] fArray = new float[1];
                            object = fArray;
                            fArray[0] = ((Float)value).floatValue();
                        }
                        values = Arrays.stream(ArrayUtils.toObject((float[])((float[])object))).limit(elementsToUse).map(FloatValue::new).collect(Collectors.toList());
                        break;
                    }
                    case Int: {
                        Object object;
                        if (value.getClass().isArray()) {
                            object = value;
                        } else {
                            int[] nArray = new int[1];
                            object = nArray;
                            nArray[0] = (Integer)value;
                        }
                        values = Arrays.stream(ArrayUtils.toObject((int[])((int[])object))).limit(elementsToUse).map(IntegerValue::new).collect(Collectors.toList());
                        break;
                    }
                    case Long: {
                        Object object;
                        if (value.getClass().isArray()) {
                            object = value;
                        } else {
                            long[] lArray = new long[1];
                            object = lArray;
                            lArray[0] = (Long)value;
                        }
                        values = Arrays.stream(ArrayUtils.toObject((long[])((long[])object))).limit(elementsToUse).map(LongValue::new).collect(Collectors.toList());
                        break;
                    }
                    case Real: {
                        Object object;
                        if (value.getClass().isArray()) {
                            object = value;
                        } else {
                            double[] dArray = new double[1];
                            object = dArray;
                            dArray[0] = (Double)value;
                        }
                        values = Arrays.stream(ArrayUtils.toObject((double[])((double[])object))).limit(elementsToUse).map(RealValue::new).collect(Collectors.toList());
                        break;
                    }
                    case Short: {
                        Object object;
                        if (value.getClass().isArray()) {
                            object = value;
                        } else {
                            short[] sArray = new short[1];
                            object = sArray;
                            sArray[0] = (Short)value;
                        }
                        values = Arrays.stream(ArrayUtils.toObject((short[])((short[])object))).limit(elementsToUse).map(ShortValue::new).collect(Collectors.toList());
                        break;
                    }
                    case String: {
                        String[] stringArray;
                        if (value.getClass().isArray()) {
                            stringArray = value;
                        } else {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = (String)value;
                        }
                        values = Arrays.stream((String[])stringArray).limit(elementsToUse).map(StringValue::new).collect(Collectors.toList());
                    }
                }
                ref.setValue(new ArrayValue(values));
            } else if (this.dimension == 1) {
                Value mappedValue = null;
                switch (this.type) {
                    case Bool: {
                        mappedValue = new BooleanValue(value.getClass().isPrimitive() ? ((Boolean)value).booleanValue() : ((Boolean)value).booleanValue());
                        break;
                    }
                    case Byte: {
                        mappedValue = new ByteValue(value.getClass().isPrimitive() ? ((Byte)value).byteValue() : ((Byte)value).byteValue());
                        break;
                    }
                    case Float: {
                        mappedValue = new FloatValue(value.getClass().isPrimitive() ? ((Float)value).floatValue() : ((Float)value).floatValue());
                        break;
                    }
                    case Int: {
                        mappedValue = new IntegerValue(value.getClass().isPrimitive() ? ((Integer)value).intValue() : ((Integer)value).intValue());
                        break;
                    }
                    case Long: {
                        mappedValue = new LongValue(value.getClass().isPrimitive() ? ((Long)value).longValue() : ((Long)value).longValue());
                        break;
                    }
                    case Real: {
                        mappedValue = new RealValue(value.getClass().isPrimitive() ? ((Double)value).doubleValue() : ((Double)value).doubleValue());
                        break;
                    }
                    case Short: {
                        mappedValue = new ShortValue(value.getClass().isPrimitive() ? ((Short)value).shortValue() : ((Short)value).shortValue());
                        break;
                    }
                    case String: {
                        mappedValue = new StringValue((String)value);
                    }
                }
                ref.setValue(mappedValue);
            }
        }

        @Override
        public Value mapOut(Object value, Map<IArgMapping, Value> outputThroughReturn) {
            if (this.dimension == 2) {
                List values = null;
                long elementsToUse = this.limits == null ? Long.MAX_VALUE : this.limits[0];
                switch (this.type) {
                    case Bool: {
                        Object object;
                        if (value.getClass().isArray()) {
                            object = value;
                        } else {
                            boolean[] blArray = new boolean[1];
                            object = blArray;
                            blArray[0] = (Boolean)value;
                        }
                        values = Arrays.stream(ArrayUtils.toObject((boolean[])((boolean[])object))).limit(elementsToUse).map(BooleanValue::new).collect(Collectors.toList());
                        break;
                    }
                    case Byte: {
                        Object object;
                        if (value.getClass().isArray()) {
                            object = value;
                        } else {
                            byte[] byArray = new byte[1];
                            object = byArray;
                            byArray[0] = (Byte)value;
                        }
                        values = Arrays.stream(ArrayUtils.toObject((byte[])((byte[])object))).limit(elementsToUse).map(ByteValue::new).collect(Collectors.toList());
                        break;
                    }
                    case Float: {
                        Object object;
                        if (value.getClass().isArray()) {
                            object = value;
                        } else {
                            float[] fArray = new float[1];
                            object = fArray;
                            fArray[0] = ((Float)value).floatValue();
                        }
                        values = Arrays.stream(ArrayUtils.toObject((float[])((float[])object))).limit(elementsToUse).map(FloatValue::new).collect(Collectors.toList());
                        break;
                    }
                    case Int: {
                        Object object;
                        if (value.getClass().isArray()) {
                            object = value;
                        } else {
                            int[] nArray = new int[1];
                            object = nArray;
                            nArray[0] = (Integer)value;
                        }
                        values = Arrays.stream(ArrayUtils.toObject((int[])((int[])object))).limit(elementsToUse).map(IntegerValue::new).collect(Collectors.toList());
                        break;
                    }
                    case Long: {
                        Object object;
                        if (value.getClass().isArray()) {
                            object = value;
                        } else {
                            long[] lArray = new long[1];
                            object = lArray;
                            lArray[0] = (Long)value;
                        }
                        values = Arrays.stream(ArrayUtils.toObject((long[])((long[])object))).limit(elementsToUse).map(LongValue::new).collect(Collectors.toList());
                        break;
                    }
                    case Real: {
                        Object object;
                        if (value.getClass().isArray()) {
                            object = value;
                        } else {
                            double[] dArray = new double[1];
                            object = dArray;
                            dArray[0] = (Double)value;
                        }
                        values = Arrays.stream(ArrayUtils.toObject((double[])((double[])object))).limit(elementsToUse).map(RealValue::new).collect(Collectors.toList());
                        break;
                    }
                    case Short: {
                        Object object;
                        if (value.getClass().isArray()) {
                            object = value;
                        } else {
                            short[] sArray = new short[1];
                            object = sArray;
                            sArray[0] = (Short)value;
                        }
                        values = Arrays.stream(ArrayUtils.toObject((short[])((short[])object))).limit(elementsToUse).map(ShortValue::new).collect(Collectors.toList());
                        break;
                    }
                    case String: {
                        String[] stringArray;
                        if (value.getClass().isArray()) {
                            stringArray = value;
                        } else {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = (String)value;
                        }
                        values = Arrays.stream((String[])stringArray).limit(elementsToUse).map(StringValue::new).collect(Collectors.toList());
                    }
                }
                return new ArrayValue(values);
            }
            switch (this.type) {
                case Bool: {
                    return new BooleanValue((Boolean)value);
                }
                case Byte: {
                    return new ByteValue((Integer)value);
                }
                case Float: {
                    return new FloatValue(((Float)value).floatValue());
                }
                case Int: {
                    return new IntegerValue((Integer)value);
                }
                case Long: {
                    return new LongValue((Long)value);
                }
                case Real: {
                    return new RealValue((Double)value);
                }
                case Short: {
                    return new ShortValue((Short)value);
                }
                case String: {
                    return new StringValue((String)value);
                }
            }
            throw new IllegalArgumentException("No mapping for value:" + String.valueOf(value));
        }

        @Override
        public Class getType() {
            if (this.dimension == 1) {
                switch (this.type) {
                    case Bool: {
                        return Boolean.TYPE;
                    }
                    case Byte: {
                        return Byte.TYPE;
                    }
                    case Float: {
                        return Float.TYPE;
                    }
                    case Int: {
                        return Integer.TYPE;
                    }
                    case Long: {
                        return Long.TYPE;
                    }
                    case Real: {
                        return Double.TYPE;
                    }
                    case Short: {
                        return Short.TYPE;
                    }
                    case String: {
                        return String.class;
                    }
                }
            } else if (this.dimension == 2) {
                switch (this.type) {
                    case Bool: {
                        return boolean[].class;
                    }
                    case Byte: {
                        return byte[].class;
                    }
                    case Float: {
                        return float[].class;
                    }
                    case Int: {
                        return int[].class;
                    }
                    case Long: {
                        return long[].class;
                    }
                    case Real: {
                        return double[].class;
                    }
                    case Short: {
                        return short[].class;
                    }
                    case String: {
                        return String[].class;
                    }
                }
            }
            throw new IllegalArgumentException("dimension not supported: " + this.dimension + " for type " + String.valueOf((Object)this.type));
        }

        @Override
        public String getDescriptiveName() {
            return this.type.toString();
        }

        @Override
        public String getDefaultTestValue() {
            switch (this.type) {
                case Bool: {
                    return "true";
                }
                case Byte: 
                case Int: 
                case Long: 
                case Short: {
                    return "1";
                }
                case Float: 
                case Real: {
                    return "1.1";
                }
                case String: {
                    return "hi";
                }
            }
            return "";
        }

        public static enum InOut {
            Input,
            Output,
            OutputThroughReturn;

        }
    }

    public static class ArgMappingContext {
        final String functionName;
        final String argName;
        final PType argType;

        public String getFunctionName() {
            return this.functionName;
        }

        public String getArgName() {
            return this.argName;
        }

        public PType getArgType() {
            return this.argType;
        }

        public ArgMappingContext(String functionName, String argName, PType argType) {
            this.functionName = functionName;
            this.argName = argName;
            this.argType = argType;
        }
    }
}

