/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.interpreter.values.datawriter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.NumericValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.datawriter.DataListenerUtilities;
import org.intocps.maestro.interpreter.values.datawriter.IDataListener;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketDataWriter
implements IDataListener {
    static final Logger logger = LoggerFactory.getLogger(WebSocketDataWriter.class);
    final MinimalWebSocketServer server;
    final JsonLiveStreamValueConverter valueConverter = new JsonLiveStreamValueConverter();
    private final List<String> filter;
    static final String CSV_DATA_WRITER_PRECISION = "WEBSOCKET_DATA_WRITER_PRECISION";
    static final String floatFormatter = System.getProperty("WEBSOCKET_DATA_WRITER_PRECISION") != null ? "%." + System.getProperty("WEBSOCKET_DATA_WRITER_PRECISION") + "f" : null;

    public WebSocketDataWriter(int port, List<String> filter) {
        this.server = new MinimalWebSocketServer(this, new InetSocketAddress(port));
        this.filter = filter;
        Thread t = new Thread((Runnable)((Object)this.server));
        t.start();
        logger.info("WebSocket server started on port: {}", (Object)port);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeHeader(UUID uuid, List<String> headers) {
        Map<Integer, String> indexToHeader = DataListenerUtilities.indicesToHeaders(headers, this.filter == null || this.filter.isEmpty() ? null : this.filter);
        this.valueConverter.configure(indexToHeader);
    }

    @Override
    public void writeDataPoint(UUID uuid, double time, List<Value> dataPoint) {
        Vector<Object> values = new Vector<Object>();
        for (int i = 0; i < dataPoint.size(); ++i) {
            Value d = dataPoint.get(i).deref();
            Object value = null;
            if (d.isNumericDecimal()) {
                value = floatFormatter == null ? Double.valueOf(((NumericValue)d).doubleValue()) : String.format(Locale.US, floatFormatter, ((NumericValue)d).doubleValue());
            } else if (d.isNumeric()) {
                value = ((NumericValue)d).intValue();
            } else if (d instanceof BooleanValue) {
                value = ((BooleanValue)d).getValue();
            } else if (d instanceof StringValue) {
                value = ((StringValue)d).getValue();
            }
            values.add(value);
        }
        this.valueConverter.update(time, values);
        try {
            this.server.broadcastMessage(this.valueConverter.getJson());
        }
        catch (JsonProcessingException e) {
            logger.error("Couldn't serialize data", (Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            this.server.stop();
        }
        catch (InterruptedException e) {
            logger.error("Failed to stop websocket server", (Throwable)e);
        }
    }

    public static void dumpWebsocketUi(Path path, int port) {
        try (InputStream res = WebSocketDataWriter.class.getResourceAsStream("graph.html");){
            if (res != null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(res, StandardCharsets.UTF_8));
                byte[] bytes = IOUtils.toString((Reader)reader).replace("PORT", String.valueOf(port)).getBytes(StandardCharsets.UTF_8);
                Files.write(path, bytes, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class JsonLiveStreamValueConverter {
        private Map<Integer, String> indexToHeader;
        static final ObjectMapper mapper = new ObjectMapper();
        private static final Logger logger = LoggerFactory.getLogger(JsonLiveStreamValueConverter.class);
        LiveStreamRootObject data = new LiveStreamRootObject(this);

        public void configure(Map<Integer, String> indexToHeader) {
            this.indexToHeader = indexToHeader;
        }

        public void update(double time, List<Object> updates) {
            this.data.time = time;
            for (int i = 0; i < updates.size(); ++i) {
                if (!this.indexToHeader.containsKey(i)) continue;
                String[] name = this.indexToHeader.get(i).split("\\.");
                Map dataMap = this.data.data;
                for (int segement = 0; segement < name.length; ++segement) {
                    String s = name[segement];
                    if (segement == name.length - 1) {
                        dataMap.put((String)s, (Object)updates.get(i));
                        continue;
                    }
                    dataMap = (Map)dataMap.computeIfAbsent((String)s, k -> new HashMap());
                }
            }
        }

        public String getJson() throws JsonProcessingException {
            return mapper.writeValueAsString((Object)this.data);
        }

        private class LiveStreamRootObject {
            public double time;
            public Map<String, Object> data = new HashMap<String, Object>();

            private LiveStreamRootObject(JsonLiveStreamValueConverter jsonLiveStreamValueConverter) {
            }
        }
    }

    public class MinimalWebSocketServer
    extends WebSocketServer {
        private final Set<WebSocket> connections = Collections.newSetFromMap(new ConcurrentHashMap());

        public MinimalWebSocketServer(WebSocketDataWriter this$0, InetSocketAddress address) {
            super(address);
        }

        public void onOpen(WebSocket conn, ClientHandshake handshake) {
            this.connections.add(conn);
            logger.debug("New connection: {}", (Object)conn.getRemoteSocketAddress());
        }

        public void onClose(WebSocket conn, int code, String reason, boolean remote) {
            this.connections.remove(conn);
            logger.debug("Closed connection: {}", (Object)conn.getRemoteSocketAddress());
        }

        public void onMessage(WebSocket conn, String message) {
            logger.trace("Received: {}", (Object)message);
        }

        public void onError(WebSocket conn, Exception ex) {
            logger.error("Websocket error", (Throwable)ex);
        }

        public void onStart() {
            logger.info("Server started on: {}", (Object)this.getAddress());
        }

        public void broadcastMessage(String message) {
            for (WebSocket conn : this.connections) {
                if (!conn.isOpen()) continue;
                conn.send(message);
            }
        }
    }
}

