/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.controllers;

import java.io.IOException;
import java.util.UUID;
import org.intocps.maestro.webapi.controllers.SimulatorManagementController;
import org.intocps.maestro.webapi.controllers.SimulatorNotFoundException;
import org.intocps.maestro.webapi.services.SimulatorManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/esav1/orchestrator"})
public class SimulatorManagementController {
    private static final Logger logger = LoggerFactory.getLogger(SimulatorManagementController.class);
    final SimulatorManagementService simulatorManagementService;

    @Autowired
    public SimulatorManagementController(SimulatorManagementService simulatorManagementService) {
        this.simulatorManagementService = simulatorManagementService;
    }

    @RequestMapping(value={"/ping"})
    public String ping() {
        return "OK";
    }

    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public CreateResponse create() throws Exception {
        String simulatorId = UUID.randomUUID().toString();
        logger.debug("Creating simulator: {}", (Object)simulatorId);
        String url = this.simulatorManagementService.create(simulatorId);
        return new CreateResponse(this, simulatorId, url, this.simulatorManagementService.getSimulatorDirectory(simulatorId).getAbsolutePath());
    }

    @RequestMapping(value={"/{simulatorId}"}, method={RequestMethod.DELETE})
    public void delete(@PathVariable String simulatorId) throws IOException, SimulatorNotFoundException {
        logger.debug("Deleting simulator: {}", (Object)simulatorId);
        if (!this.simulatorManagementService.delete(simulatorId)) {
            throw new SimulatorNotFoundException("Unknown simulator id: " + simulatorId);
        }
    }

    @RequestMapping(value={"/terminate"}, method={RequestMethod.POST})
    public void terminate() throws Exception {
        logger.info("System terminating. NOW");
        this.simulatorManagementService.terminateApplication();
    }
}

