/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro2.interpreter;

import com.spencerwi.either.Either;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.interpreter.DefaultExternalValueFactory;
import org.intocps.maestro.interpreter.values.csv.CsvDataWriter;
import org.intocps.maestro.interpreter.values.datawriter.DataWriterValue;
import org.intocps.maestro.webapi.maestro2.interpreter.WebsocketDataWriter;
import org.springframework.web.socket.WebSocketSession;

public class WebApiInterpreterFactory
extends DefaultExternalValueFactory {
    public WebApiInterpreterFactory(File workingDirectory, WebSocketSession ws, double interval, List<String> webSocketFilter, File csvOutputFile, List<String> csvFilter) throws IOException {
        super(workingDirectory, null);
        Objects.requireNonNull(this);
        this.instantiators.put("DataWriter", args -> {
            if (ws == null) {
                return Either.left((Object)new AnalysisException("No websocket present"));
            }
            return Either.right((Object)new DataWriterValue(Arrays.asList(new CsvDataWriter(csvOutputFile, csvFilter), new WebsocketDataWriter(ws, webSocketFilter, interval))));
        });
    }

    public WebApiInterpreterFactory(File workingDirectory, File csvOutputFile, List<String> csvFilter) throws IOException {
        super(workingDirectory, null);
        Objects.requireNonNull(this);
        this.instantiators.put("DataWriter", args -> Either.right((Object)new DataWriterValue(Arrays.asList(new CsvDataWriter(csvOutputFile, csvFilter)))));
    }
}

