/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intocps.maestro.ErrorReporter;
import org.intocps.maestro.Mabl;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.core.api.FixedStepSizeAlgorithm;
import org.intocps.maestro.core.api.IStepAlgorithm;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.fmi2.ComponentInfo;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironmentConfiguration;
import org.intocps.maestro.interpreter.DefaultExternalValueFactory;
import org.intocps.maestro.interpreter.MableInterpreter;
import org.intocps.maestro.template.MaBLTemplateConfiguration;
import org.intocps.maestro.webapi.maestro2.Maestro2SimulationController;
import org.intocps.maestro.webapi.maestro2.interpreter.WebApiInterpreterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketSession;

public class Maestro2Broker {
    private static final Logger logger = LoggerFactory.getLogger(Maestro2Broker.class);
    final Mabl mabl;
    final File workingDirectory;
    final ErrorReporter reporter;

    public Maestro2Broker(File workingDirectory, ErrorReporter reporter) {
        this.workingDirectory = workingDirectory;
        this.mabl = new Mabl(workingDirectory, null);
        this.reporter = reporter;
        this.mabl.setReporter((IErrorReporter)this.reporter);
        this.mabl.getSettings().dumpIntermediateSpecs = false;
        this.mabl.getSettings().inlineFrameworkConfig = true;
    }

    public void buildAndRun(Maestro2SimulationController.InitializationData initializeRequest, Maestro2SimulationController.SimulateRequestBody body, WebSocketSession socket, File csvOutputFile) throws Exception {
        HashMap<String, Map> initialize = new HashMap<String, Map>();
        initialize.put("parameters", initializeRequest.parameters);
        Fmi2SimulationEnvironmentConfiguration simulationConfiguration = new Fmi2SimulationEnvironmentConfiguration();
        simulationConfiguration.fmus = initializeRequest.getFmus();
        simulationConfiguration.connections = initializeRequest.getConnections();
        simulationConfiguration.logVariables = initializeRequest.getLogVariables();
        simulationConfiguration.livestream = initializeRequest.livestream;
        Fmi2SimulationEnvironment simulationEnvironment = Fmi2SimulationEnvironment.of((Fmi2SimulationEnvironmentConfiguration)simulationConfiguration, (IErrorReporter)this.reporter);
        Map<String, List> removedFMUKeyFromLogLevels = body.logLevels.entrySet().stream().collect(Collectors.toMap(entry -> MaBLTemplateConfiguration.MaBLTemplateConfigurationBuilder.getFmuInstanceFromFmuKeyInstance((String)((String)entry.getKey())), Map.Entry::getValue));
        MaBLTemplateConfiguration.MaBLTemplateConfigurationBuilder builder = MaBLTemplateConfiguration.MaBLTemplateConfigurationBuilder.getBuilder().setFrameworkConfig(Framework.FMI2, simulationConfiguration).useInitializer(true, new ObjectMapper().writeValueAsString(initialize)).setFramework(Framework.FMI2).setLogLevels(removedFMUKeyFromLogLevels).setVisible(initializeRequest.visible).setLoggingOn(initializeRequest.loggingOn).setStepAlgorithm((IStepAlgorithm)new FixedStepSizeAlgorithm(body.endTime, ((Maestro2SimulationController.FixedStepAlgorithmConfig)initializeRequest.getAlgorithm()).getSize().doubleValue()));
        MaBLTemplateConfiguration configuration = builder.build();
        this.generateSpecification(configuration);
        Function<Map, List> flattenFmuIds = map -> map.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(v -> (String)entry.getKey() + "." + v)).collect(Collectors.toList());
        List connectedOutputs = simulationEnvironment.getConnectedOutputs().stream().map(x -> {
            ComponentInfo i = (ComponentInfo)simulationEnvironment.getUnitInfo(new LexIdentifier(x.instance.getText(), null), Framework.FMI2);
            return String.format("%s.%s.%s", i.fmuIdentifier, x.instance.getText(), x.scalarVariable.getName());
        }).collect(Collectors.toList());
        this.executeInterpreter(socket, Stream.concat(connectedOutputs.stream(), (initializeRequest.logVariables == null ? new Vector() : flattenFmuIds.apply(initializeRequest.logVariables)).stream()).collect(Collectors.toList()), initializeRequest.livestream == null ? new Vector() : flattenFmuIds.apply(initializeRequest.livestream), body.liveLogInterval.doubleValue(), csvOutputFile);
    }

    public void generateSpecification(MaBLTemplateConfiguration config) throws Exception {
        this.mabl.generateSpec(config);
        this.mabl.expand();
        this.mabl.dump(this.workingDirectory);
    }

    public void executeInterpreter(WebSocketSession webSocket, List<String> csvFilter, List<String> webSocketFilter, double interval, File csvOutputFile) throws IOException, AnalysisException {
        WebApiInterpreterFactory factory = webSocket != null ? new WebApiInterpreterFactory(this.workingDirectory, webSocket, interval, webSocketFilter, new File(this.workingDirectory, "outputs.csv"), csvFilter) : new WebApiInterpreterFactory(this.workingDirectory, csvOutputFile, csvFilter);
        new MableInterpreter((DefaultExternalValueFactory)factory).execute(this.mabl.getMainSimulationUnit());
    }

    public void setVerbose(boolean verbose) {
        this.mabl.setVerbose(verbose);
    }
}

