/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro2;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.intocps.maestro.ErrorReporter;
import org.intocps.maestro.Main;
import org.intocps.maestro.webapi.controllers.ProdSessionLogicFactory;
import org.intocps.maestro.webapi.controllers.SessionController;
import org.intocps.maestro.webapi.controllers.SessionLogic;
import org.intocps.maestro.webapi.controllers.SessionLogicFactory;
import org.intocps.maestro.webapi.maestro2.Maestro2Broker;
import org.intocps.maestro.webapi.maestro2.Maestro2SimulationController;
import org.intocps.orchestration.coe.cosim.BasicFixedStepSizeCalculator;
import org.intocps.orchestration.coe.httpserver.Algorithm;
import org.intocps.orchestration.coe.json.InitializationMsgJson;
import org.intocps.orchestration.coe.util.ZipDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Component
public class Maestro2SimulationController {
    public static final SessionController sessionController = new SessionController((SessionLogicFactory)new ProdSessionLogicFactory());
    static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(Maestro2SimulationController.class);

    public static InitializationMsgJson.Constraint convert(IVarStepConstraint constraint) {
        if (constraint instanceof InitializationData.FmuMaxStepSizeConstraint) {
            InitializationMsgJson.Constraint c = new InitializationMsgJson.Constraint();
            c.type = "fmumaxstepsize";
            return c;
        }
        if (constraint instanceof InitializationData.BoundedDifferenceConstraint) {
            InitializationData.BoundedDifferenceConstraint cIn = (InitializationData.BoundedDifferenceConstraint)constraint;
            InitializationMsgJson.Constraint c = new InitializationMsgJson.Constraint();
            c.type = "boundeddifference";
            c.abstol = cIn.abstol;
            c.ports = cIn.ports;
            c.reltol = cIn.reltol;
            c.safety = cIn.safety;
            c.skipDiscrete = cIn.skipDiscrete;
            return c;
        }
        if (constraint instanceof InitializationData.SamplingConstraint) {
            InitializationData.SamplingConstraint cIn = (InitializationData.SamplingConstraint)constraint;
            InitializationMsgJson.Constraint c = new InitializationMsgJson.Constraint();
            c.type = "samplingrate";
            c.base = cIn.base;
            c.rate = cIn.rate;
            c.startTime = cIn.startTime;
            return c;
        }
        if (constraint instanceof InitializationData.ZeroCrossingConstraint) {
            InitializationData.ZeroCrossingConstraint cIn = (InitializationData.ZeroCrossingConstraint)constraint;
            InitializationMsgJson.Constraint c = new InitializationMsgJson.Constraint();
            c.type = "zerocrossing";
            c.abstol = cIn.abstol;
            c.ports = cIn.ports;
            c.order = cIn.order;
            c.safety = cIn.safety;
            return c;
        }
        return null;
    }

    public void overrideRootLoggerLogLevel(Level level) {
        if (level == null) {
            return;
        }
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.setLevel(level);
        ctx.updateLoggers();
    }

    @RequestMapping(value={"/upload/{sessionId}"}, method={RequestMethod.POST})
    public void uploadFile(@PathVariable String sessionId, @ApiParam(value="File", required=true) @RequestParam(value="fieldFile") MultipartFile file) throws IOException {
        throw new NotImplementedException("/upload/{sessionId} has not been implemented.");
    }

    @RequestMapping(value={"/ping"}, method={RequestMethod.GET})
    public String ping() {
        return "OK";
    }

    @RequestMapping(value={"/status/{sessionId}"}, method={RequestMethod.GET})
    public List<StatusModel> getStatuses(@PathVariable String sessionId) {
        throw new NotImplementedException("/status/{sessionId} has not been implemented.");
    }

    StatusModel getStatus(String sessionId) {
        if (sessionController.containsSession(sessionId)) {
            return new StatusModel("Session exists", sessionId, 0L);
        }
        return new StatusModel("Session does not exist", sessionId, 0L);
    }

    @RequestMapping(value={"/createSession"}, method={RequestMethod.GET})
    public StatusModel createSession() {
        String session = sessionController.createNewSession();
        return this.getStatus(session);
    }

    @RequestMapping(value={"/initialize/{sessionId}"}, method={RequestMethod.POST})
    public InitializeStatusModel initializeSession(@PathVariable String sessionId, @RequestBody String body1) throws Exception {
        logger.debug("Got initial data: {}", (Object)body1);
        SessionLogic logic = sessionController.getSessionLogic(sessionId);
        mapper.writeValue(new File(logic.rootDirectory, "initialize.json"), (Object)body1);
        ObjectMapper mapper = new ObjectMapper();
        InitializationData body = (InitializationData)mapper.readValue(body1, InitializationData.class);
        if (logic == null) {
            throw new Exception("Session has not been created.");
        }
        if (body == null) {
            throw new Exception("Could not parse configuration: ");
        }
        if (body.overrideLogLevel != null) {
            this.overrideRootLoggerLogLevel(this.convertLogLevel(body.overrideLogLevel));
        }
        if (body.fmus == null) {
            throw new Exception("FMUs must not be null");
        }
        if (body.connections == null) {
            throw new Exception("Connections must not be null");
        }
        BasicFixedStepSizeCalculator stepSizeCalculator = null;
        Algorithm stepAlgorithm = Algorithm.NONE;
        if (body.algorithm == null) {
            stepAlgorithm = Algorithm.FIXED;
            stepSizeCalculator = new BasicFixedStepSizeCalculator(0.1);
            logger.info("No step size algorithm given. Defaulting to fixed-step with size 0.1");
        } else if (body.algorithm instanceof FixedStepAlgorithmConfig) {
            FixedStepAlgorithmConfig algorithm = (FixedStepAlgorithmConfig)body.algorithm;
            if (algorithm.size == null) {
                throw new Exception("fixed-step size must be an integer or double");
            }
            logger.info("Using Fixed-step size calculator with size = {}", (Object)algorithm.size);
            stepSizeCalculator = new BasicFixedStepSizeCalculator(algorithm.size.doubleValue());
            stepAlgorithm = Algorithm.FIXED;
        } else if (body.algorithm instanceof VariableStepAlgorithmConfig) {
            logger.info("Variable step algorithm not supported");
            throw new NotImplementedException("Variable step algorithms are not supported.");
        }
        Object logs = null;
        if (body.stabalizationEnabled) {
            throw new NotImplementedException("Stabilisation is not implemented");
        }
        if (body.parallelSimulation) {
            throw new NotImplementedException("ParallelSimulation is not implemented");
        }
        if (body.simulationProgramDelay) {
            throw new NotImplementedException("SimulationProgramDelay is not implemented");
        }
        if (body.hasExternalSignals) {
            throw new NotImplementedException("HasExternalSignals is not implemented");
        }
        logger.trace("Initialization completed");
        logic.setInitializationData(body);
        return new InitializeStatusModel("initialized", sessionId, null, 0L);
    }

    private Level convertLogLevel(InitializationData.InitializeLogLevel overrideLogLevel) {
        switch (1.$SwitchMap$org$intocps$maestro$webapi$maestro2$Maestro2SimulationController$InitializationData$InitializeLogLevel[overrideLogLevel.ordinal()]) {
            case 1: {
                return Level.OFF;
            }
            case 2: {
                return Level.FATAL;
            }
            case 3: {
                return Level.ERROR;
            }
            case 4: {
                return Level.WARN;
            }
            case 5: {
                return Level.INFO;
            }
            case 6: {
                return Level.DEBUG;
            }
            case 7: {
                return Level.TRACE;
            }
            case 8: {
                return Level.ALL;
            }
        }
        return null;
    }

    @ApiOperation(value="This request begins the co-simulation")
    @RequestMapping(value={"/simulate/{sessionId}"}, method={RequestMethod.POST}, consumes={"text/plain", "application/json"})
    public StatusModel simulate(@PathVariable String sessionId, @RequestBody SimulateRequestBody body) throws Exception {
        SessionLogic logic = sessionController.getSessionLogic(sessionId);
        mapper.writeValue(new File(logic.rootDirectory, "simulate.json"), (Object)body);
        ErrorReporter reporter = new ErrorReporter();
        Maestro2Broker mc = new Maestro2Broker(logic.rootDirectory, reporter);
        mc.buildAndRun(logic.getInitializationData(), body, logic.getSocket(), new File(logic.rootDirectory, "outputs.csv"));
        if (reporter.getErrorCount() > 0) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            reporter.printWarnings(writer);
            reporter.printErrors(writer);
            throw new Exception(out.toString());
        }
        return this.getStatus(sessionId);
    }

    @RequestMapping(value={"/stopsimulation/{sessionId}"}, method={RequestMethod.POST})
    public void stop(@PathVariable String sessionId) {
        throw new NotImplementedException("/stopsimulation/{sessionId} has not been implemented.");
    }

    @RequestMapping(value={"/result/{sessionId}/plain"}, method={RequestMethod.GET})
    public ResponseEntity<Resource> getResultPlain(@PathVariable String sessionId) throws Exception {
        SessionLogic sessionLogic = sessionController.getSessionLogic(sessionId);
        if (sessionLogic == null) {
            throw new IllegalArgumentException("The session with id: " + sessionId + " does not exist.");
        }
        ByteArrayResource resource = new ByteArrayResource(FileUtils.readFileToByteArray((File)new File(sessionLogic.rootDirectory, "outputs.csv")));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).header("Content-Disposition", new String[]{"attachment; filename=\"outputs.csv\""})).body((Object)resource);
    }

    @RequestMapping(value={"/result/{sessionId}/zip"}, method={RequestMethod.GET}, produces={"application/zip"})
    public void getResultZip(@PathVariable String sessionId, HttpServletResponse response) throws Exception {
        SessionLogic sessionLogic = sessionController.getSessionLogic(sessionId);
        if (sessionLogic == null) {
            throw new IllegalArgumentException("The session with id: " + sessionId + " does not exist.");
        }
        response.setStatus(200);
        response.addHeader("Content-Disposition", "attachment; filename=\"results.zip\"");
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
        ZipDirectory.addDir((File)sessionLogic.rootDirectory, (File)sessionLogic.rootDirectory, (ZipOutputStream)zipOutputStream);
        zipOutputStream.close();
    }

    @RequestMapping(value={"/destroy/{sessionId}"}, method={RequestMethod.GET})
    public void destroy(@PathVariable String sessionId) throws Exception {
        sessionController.deleteSession(sessionId);
    }

    @RequestMapping(value={"/version"}, method={RequestMethod.GET})
    public String version() {
        String message = "{\"version\":\"" + Main.getVersion() + "\"}";
        return message;
    }
}

