/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.services;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intocps.maestro.webapi.controllers.InitializationException;
import org.intocps.maestro.webapi.services.CoeService;
import org.intocps.maestro.webapi.services.EnvironmentFMU;
import org.intocps.maestro.webapi.services.EnvironmentFMUFactory;
import org.intocps.orchestration.coe.FmuFactory;
import org.intocps.orchestration.coe.config.InvalidVariableStringException;
import org.intocps.orchestration.coe.config.ModelConnection;
import org.intocps.orchestration.coe.config.ModelParameter;
import org.intocps.orchestration.coe.cosim.CoSimStepSizeCalculator;
import org.intocps.orchestration.coe.modeldefinition.ModelDescription;
import org.intocps.orchestration.coe.scala.Coe;
import org.intocps.orchestration.coe.scala.LogVariablesContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoeService {
    private static final Logger logger = LoggerFactory.getLogger(CoeService.class);
    private boolean simulating = false;
    private boolean initialized = false;
    private double startTime = 0.0;
    private double endTime = 0.0;
    private Map<String, List<ModelDescription.LogCategory>> availableDebugLoggingCategories;
    private Map<String, List<String>> requestedDebugLoggingCategories;
    private Coe coe;
    private Coe.CoeSimulationHandle simulationHandle = null;
    private EnvironmentFMU environmentFMU;
    private Map<ModelConnection.ModelInstance, Set<ModelDescription.ScalarVariable>> requestedOutputs;
    private List<String> acceptedInputs;
    private CachedInitializeArguments cachedInitializeArguments = null;

    public CoeService(Coe coe) {
        this.coe = coe;
    }

    public CoeService() {
        this.reset();
    }

    public void reset() {
        if (this.coe != null && this.simulating) {
            this.stop();
        }
        this.simulating = false;
        this.initialized = false;
        this.startTime = 0.0;
        this.endTime = 0.0;
        this.availableDebugLoggingCategories = null;
        this.requestedDebugLoggingCategories = null;
        this.coe = null;
        this.simulationHandle = null;
        this.environmentFMU = null;
        this.requestedOutputs = null;
        this.acceptedInputs = null;
    }

    public Coe get() {
        if (this.coe != null) {
            return this.coe;
        }
        String session = UUID.randomUUID().toString();
        File root = new File(session);
        if (!root.mkdirs()) {
            logger.error("Could not create session directory for COE: {}", (Object)root.getAbsolutePath());
        }
        this.coe = new Coe(root);
        return this.coe;
    }

    public void reinitialize() throws Exception {
        if (this.cachedInitializeArguments != null) {
            CachedInitializeArguments c = this.cachedInitializeArguments;
            this.initialize(c.fmus, c.stepSizeCalculator, c.endTime, c.parameters, c.connections, c.requestedDebugLoggingCategories, c.inputs, c.outputs);
        }
    }

    public void initialize(Map<String, URI> fmus, CoSimStepSizeCalculator stepSizeCalculator, Double endTime, List<ModelParameter> parameters, List<ModelConnection> connections, Map<String, List<String>> requestedDebugLoggingCategories, List<ModelParameter> inputs, Map<ModelConnection.ModelInstance, Set<ModelDescription.ScalarVariable>> outputs) throws Exception {
        this.initialized = false;
        if (fmus.size() == 1 || inputs != null && inputs.size() > 0 || outputs != null && outputs.size() > 0) {
            if (connections == null) {
                connections = new ArrayList<ModelConnection>();
            }
            this.requestedOutputs = outputs;
            Map<String, List> modelDescriptions = fmus.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, map -> {
                Optional<Object> res;
                try {
                    res = Optional.of(new ModelDescription(FmuFactory.create((File)this.get().getResultRoot(), (URI)((URI)map.getValue())).getModelDescription()).getScalarVariables());
                }
                catch (Exception e) {
                    res = Optional.empty();
                }
                return res;
            })).entrySet().stream().filter(map -> ((Optional)map.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, map -> (List)((Optional)map.getValue()).get()));
            modelDescriptions.forEach((fmu, md) -> logger.trace("{}: {}", fmu, (Object)md.stream().map(sv -> sv.name).collect(Collectors.joining(",\n\t", "[\n\t", "]"))));
            this.environmentFMU = EnvironmentFMU.CreateEnvironmentFMU((String)"~env~", (String)"global");
            fmus.put(this.environmentFMU.environmentFmuModelInstance.key, new URI("environment" + "://".concat(this.environmentFMU.fmuName)));
            if (inputs != null && inputs.size() > 0) {
                Set connectedInputs = connections.stream().map(con -> con.to).collect(Collectors.toSet());
                if (inputs.stream().map(in -> in.variable).anyMatch(connectedInputs::contains)) {
                    connectedInputs.removeAll(inputs.stream().map(in -> in.variable).collect(Collectors.toSet()));
                    throw new InitializationException("Invalid input. The following inputs are already connected: " + connectedInputs.stream().map(ModelConnection.Variable::toString).collect(Collectors.joining(",")));
                }
                Map<ModelConnection.ModelInstance, List<ModelParameter>> inputsGroupedByInstance = inputs.stream().collect(Collectors.groupingBy(x -> x.variable.instance));
                Map inputsValidation = inputs.stream().collect(Collectors.toMap(Function.identity(), p -> {
                    List md = (List)modelDescriptions.get(p.variable.instance.key);
                    return md.stream().anyMatch(sv -> sv.causality == ModelDescription.Causality.Input && sv.name.equals(p.variable.variable));
                }));
                List invalidInputs = inputsValidation.entrySet().stream().filter(map -> (Boolean)map.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
                if (!invalidInputs.isEmpty()) {
                    throw new IllegalArgumentException("The following inputs are not present as input in the respective FMUs: " + invalidInputs.stream().map(p -> p.variable.toString()).collect(Collectors.joining(",")));
                }
                Map<ModelConnection.ModelInstance, List> envOutputs = inputsGroupedByInstance.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, map -> {
                    List correspondingScalars = (List)modelDescriptions.get(((ModelConnection.ModelInstance)map.getKey()).key);
                    return ((List)map.getValue()).stream().map(inputVar -> correspondingScalars.stream().filter(svMd -> svMd.name.equals(inputVar.variable.variable)).findFirst()).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                }));
                this.environmentFMU.calculateOutputs(envOutputs);
                this.acceptedInputs = inputsValidation.entrySet().stream().filter(Map.Entry::getValue).map(p -> ((ModelParameter)p.getKey()).variable.toString()).collect(Collectors.toList());
                for (ModelParameter input : inputs) {
                    for (Map.Entry entry2 : this.environmentFMU.getSourceToEnvironmentVariableOutputs().entrySet()) {
                        if (!((String)entry2.getKey()).equals(input.variable.toString())) continue;
                        ((ModelDescription.ScalarVariable)entry2.getValue()).type.start = input.value;
                        ((ModelDescription.ScalarVariable)entry2.getValue()).initial = ModelDescription.Initial.Exact;
                    }
                }
            }
            if (outputs != null && outputs.size() > 0) {
                HashMap envInputs = new HashMap();
                for (Map.Entry<ModelConnection.ModelInstance, Set<ModelDescription.ScalarVariable>> outputEntry : outputs.entrySet()) {
                    List correlatedOutputs = outputEntry.getValue().stream().map(sv -> {
                        Optional<ModelDescription.ScalarVariable> correlatedScalars = ((List)modelDescriptions.get(((ModelConnection.ModelInstance)outputEntry.getKey()).key)).stream().filter(svMd -> svMd.name.equals(sv.name)).findFirst();
                        return correlatedScalars.get();
                    }).collect(Collectors.toList());
                    envInputs.put(outputEntry.getKey(), correlatedOutputs);
                }
                this.environmentFMU.calculateInputs(envInputs);
            }
            for (Map.Entry entry3 : Stream.concat(this.environmentFMU.getSourceToEnvironmentVariableInputs().entrySet().stream(), this.environmentFMU.getSourceToEnvironmentVariableOutputs().entrySet().stream()).collect(Collectors.toSet())) {
                ModelConnection.Variable from = null;
                ModelConnection.Variable to = null;
                switch (1.$SwitchMap$org$intocps$orchestration$coe$modeldefinition$ModelDescription$Causality[((ModelDescription.ScalarVariable)entry3.getValue()).causality.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        throw new InitializationException("Environment FMU Scalars are only for inputs and outputs.");
                    }
                    case 5: {
                        from = ModelConnection.Variable.parse((String)((String)entry3.getKey()));
                        to = this.environmentFMU.createVariable((ModelDescription.ScalarVariable)entry3.getValue());
                        break;
                    }
                    case 6: {
                        from = this.environmentFMU.createVariable((ModelDescription.ScalarVariable)entry3.getValue());
                        to = ModelConnection.Variable.parse((String)((String)entry3.getKey()));
                    }
                }
                connections.add(new ModelConnection(from, to));
            }
            FmuFactory.customFactory = new EnvironmentFMUFactory();
            this.environmentFMU.createModelDescriptionXML();
        }
        this.startTime = 0.0;
        this.endTime = endTime;
        if (connections == null || connections.isEmpty()) {
            throw new Exception("No connections provided");
        }
        try {
            Coe coe = this.get();
            coe.getConfiguration().isStabalizationEnabled = false;
            coe.getConfiguration().global_absolute_tolerance = 0.0;
            coe.getConfiguration().global_relative_tolerance = 0.0;
            coe.getConfiguration().loggingOn = requestedDebugLoggingCategories != null && !requestedDebugLoggingCategories.isEmpty();
            coe.getConfiguration().visible = false;
            coe.getConfiguration().parallelSimulation = false;
            coe.getConfiguration().simulationProgramDelay = false;
            coe.getConfiguration().hasExternalSignals = false;
            this.availableDebugLoggingCategories = coe.initialize(fmus, connections, parameters, stepSizeCalculator, new LogVariablesContainer(new HashMap(), outputs));
            this.initialized = true;
        }
        catch (Exception e) {
            logger.error("Internal error in initialization", (Throwable)e);
            throw new InitializationException(e.getMessage(), (Throwable)e);
        }
        this.requestedDebugLoggingCategories = new HashMap();
        if (requestedDebugLoggingCategories != null) {
            boolean logVariablesOK = requestedDebugLoggingCategories.entrySet().stream().filter(x -> x.getValue() != null && ((List)x.getValue()).size() > 0).allMatch(entry -> {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                return this.availableDebugLoggingCategories.containsKey(key) && ((List)this.availableDebugLoggingCategories.get(key)).stream().map(logCategory -> logCategory.name).collect(Collectors.toList()).containsAll(value);
            });
            this.requestedDebugLoggingCategories = requestedDebugLoggingCategories;
            if (!logVariablesOK) {
                throw new IllegalArgumentException("Log categories do not align with the log categories within the FMUs");
            }
        }
        logger.trace("Initialization completed obtained the following logging categories: {}", (Object)this.availableDebugLoggingCategories.entrySet().stream().map(map -> (String)map.getKey() + "=" + ((List)map.getValue()).stream().map(c -> c.name).collect(Collectors.joining(",", "[", "]"))).collect(Collectors.joining(",")));
        this.cachedInitializeArguments = new CachedInitializeArguments(fmus, stepSizeCalculator, endTime, parameters, connections, requestedDebugLoggingCategories, inputs, outputs);
    }

    public void simulate(Map<ModelConnection.ModelInstance, List<String>> debugLoggingCategories, boolean reportProgress, double liveLogInterval) {
        this.get().simulate(this.startTime, this.endTime, debugLoggingCategories, reportProgress, liveLogInterval);
    }

    private void configureSimulationDeltaStepping(Map<String, List<String>> requestedDebugLoggingCategories, boolean reportProgress, double liveLogInterval) throws ModelConnection.InvalidConnectionException {
        if (this.simulationHandle == null) {
            HashMap<ModelConnection.ModelInstance, List<String>> reqDebugLoggingCategories = new HashMap<ModelConnection.ModelInstance, List<String>>();
            for (Map.Entry<String, List<String>> entry : requestedDebugLoggingCategories.entrySet()) {
                reqDebugLoggingCategories.put(ModelConnection.ModelInstance.parse((String)entry.getKey()), entry.getValue());
            }
            this.simulationHandle = this.get().getSimulateControlHandle(this.startTime, this.endTime, reqDebugLoggingCategories, reportProgress, liveLogInterval);
        }
    }

    private void simulate(double delta) throws SimulatorNotConfigured {
        if (this.simulationHandle == null) {
            throw new SimulatorNotConfigured(this, "Simulation handle not configured");
        }
        if (!this.simulating) {
            this.simulationHandle.preSimulation();
            this.simulating = true;
        }
        this.simulationHandle.simulate(delta);
    }

    public void stop() {
        if (this.simulationHandle != null && this.simulating) {
            this.simulationHandle.postSimulation();
            this.simulationHandle = null;
        }
        this.get().stopSimulation();
    }

    public Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, Object>> simulate(double delta, List<ModelParameter> inputs) throws SimulatorNotConfigured, ModelConnection.InvalidConnectionException, InvalidVariableStringException {
        if (!this.initialized) {
            throw new IllegalStateException("Simulator is not initialized");
        }
        if (!inputs.stream().map(p -> p.variable.toString()).allMatch(v -> this.acceptedInputs.contains(v))) {
            throw new IllegalStateException("Simulator called with undeclared input: " + inputs.stream().map(p -> p.variable.toString()).filter(v -> !this.acceptedInputs.contains(v)).collect(Collectors.joining(",")));
        }
        if (this.simulationHandle == null) {
            this.configureSimulationDeltaStepping(new HashMap(), false, 0.0);
        }
        if (this.simulationHandle == null) {
            throw new SimulatorNotConfigured(this, "Simulation handle not configured");
        }
        if (!this.simulating) {
            this.simulationHandle.preSimulation();
            this.simulating = true;
        }
        this.environmentFMU.setOutputValues(inputs);
        inputs.forEach(inp -> this.simulationHandle.updateState(inp, this.environmentFMU.environmentFmuModelInstance, ((ModelDescription.ScalarVariable)this.environmentFMU.getSourceToEnvironmentVariableOutputs().get((Object)inp.variable.toString())).valueReference));
        this.simulationHandle.simulate(delta);
        Map outputs = this.simulationHandle.getOutputs(this.requestedOutputs);
        return outputs;
    }
}

