/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.intocps.maestro.webapi.controllers.EsaSimulationController;
import org.intocps.maestro.webapi.controllers.InitializationException;
import org.intocps.maestro.webapi.services.CoeService;
import org.intocps.orchestration.coe.config.InvalidVariableStringException;
import org.intocps.orchestration.coe.config.ModelConnection;
import org.intocps.orchestration.coe.cosim.BasicFixedStepSizeCalculator;
import org.intocps.orchestration.coe.cosim.CoSimStepSizeCalculator;
import org.intocps.orchestration.coe.httpserver.RequestProcessors;
import org.intocps.orchestration.coe.modeldefinition.ModelDescription;
import org.intocps.orchestration.coe.scala.Coe;
import org.intocps.orchestration.coe.util.ZipDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/esav1/simulator"})
public class EsaSimulationController {
    static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(EsaSimulationController.class);
    final CoeService coeService;

    @Autowired
    public EsaSimulationController(CoeService coeService) {
        this.coeService = coeService;
    }

    @RequestMapping(value={"/ping"})
    public String ping() {
        return "OK";
    }

    @RequestMapping(value={"/initialize"}, method={RequestMethod.POST})
    public void initializeSession(@RequestBody EsaIninializationData body) throws Exception, InitializationException {
        this.validate(body);
        logger.debug("Got initial data: {}", (Object)new ObjectMapper().writeValueAsString((Object)body));
        mapper.writeValue(new File(this.coeService.get().getResultRoot(), "initialize.json"), (Object)body);
        if (body.simulatorLogLevel != null) {
            LogManager.getRootLogger().setLevel(Level.toLevel((String)body.simulatorLogLevel.name()));
        }
        BasicFixedStepSizeCalculator stepSizeCalculator = new BasicFixedStepSizeCalculator(body.stepSize.doubleValue());
        List connections = body.connections != null ? RequestProcessors.buildConnections((Map)body.connections) : null;
        List parameters = RequestProcessors.buildParameters((Map)body.parameters);
        Map fmus = body.getFmuFiles();
        List inputs = RequestProcessors.buildParameters((Map)body.inputs);
        Map outputs = RequestProcessors.buildVariableMap((Map)body.requestedOutputs);
        this.coeService.initialize(fmus, (CoSimStepSizeCalculator)stepSizeCalculator, body.endTime, parameters, connections, body.getLogLevels(), inputs, outputs);
    }

    private void validate(EsaIninializationData body) throws InitializationException {
        if (body == null) {
            throw new InitializationException("Missing body");
        }
        if (body.fmus == null || body.fmus.isEmpty()) {
            throw new InitializationException("Missing fmus");
        }
        if (body.requestedOutputs == null || body.requestedOutputs.isEmpty()) {
            throw new InitializationException("Missing requested outputs");
        }
        if (body.stepSize == null) {
            throw new InitializationException("Missing step size");
        }
        if (body.stepSize < 0.0) {
            throw new InitializationException("Invalid step size " + body.stepSize + " must be > 0");
        }
        if (body.endTime == null) {
            throw new InitializationException("Missing end time");
        }
        if (body.endTime < 0.0) {
            throw new InitializationException("Invalid end time " + body.endTime + " must be > 0");
        }
        if (body.endTime < body.stepSize) {
            throw new InitializationException("End time must be equal or larger than step size. End time: " + body.endTime + ", Step size: " + body.stepSize);
        }
    }

    @RequestMapping(value={"/simulate"}, method={RequestMethod.POST})
    public Map<String, Map<String, Object>> simulate(@RequestBody EsaSimulateRequestBody body) throws CoeService.SimulatorNotConfigured, IOException, InvalidVariableStringException, ModelConnection.InvalidConnectionException {
        Coe coe = this.coeService.get();
        mapper.writeValue(new File(coe.getResultRoot(), "simulate.json"), (Object)body);
        List inputs = RequestProcessors.buildParameters((Map)body.inputs);
        try {
            Map outputs = this.coeService.simulate(body.timeStep, inputs);
            return outputs.entrySet().stream().collect(Collectors.toMap(x -> ((ModelConnection.ModelInstance)x.getKey()).toString(), x -> ((Map)x.getValue()).entrySet().stream().collect(Collectors.toMap(y -> ((ModelDescription.ScalarVariable)y.getKey()).name, Map.Entry::getValue))));
        }
        catch (Exception e) {
            logger.error("Error in simulation", (Throwable)e);
            throw e;
        }
    }

    @RequestMapping(value={"/stop"}, method={RequestMethod.POST})
    public void stop() {
        this.coeService.stop();
    }

    @RequestMapping(value={"/reset"}, method={RequestMethod.POST})
    public void reset() throws Exception {
        this.coeService.reset();
        this.coeService.reinitialize();
    }

    @RequestMapping(value={"/result/plain"}, method={RequestMethod.GET})
    public ResponseEntity<Resource> getResultPlain() throws Exception {
        Coe coe = this.coeService.get();
        if (coe == null) {
            throw new Exception("bad session");
        }
        File result = coe.getResult();
        InputStreamResource resource = new InputStreamResource((InputStream)new FileInputStream(result));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).header("Content-Disposition", new String[]{"attachment; filename=\"" + result.getName() + "\""})).contentLength(result.length()).body((Object)resource);
    }

    @RequestMapping(value={"/result/zip"}, method={RequestMethod.GET}, produces={"application/zip"})
    public void getResultZip(HttpServletResponse response) throws Exception {
        Coe coe = this.coeService.get();
        if (coe == null) {
            throw new Exception("bad session");
        }
        response.setStatus(200);
        response.addHeader("Content-Disposition", "attachment; filename=\"results.zip\"");
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
        ZipDirectory.addDir((File)coe.getResultRoot(), (File)coe.getResultRoot(), (ZipOutputStream)zipOutputStream);
        zipOutputStream.close();
    }

    @RequestMapping(value={"/destroy"}, method={RequestMethod.GET})
    public void destroy() throws Exception {
        Coe coe = this.coeService.get();
        if (coe == null) {
            throw new Exception("bad session");
        }
        org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
        ArrayList<FileAppender> appendersToRemove = new ArrayList<FileAppender>();
        Enumeration appenders = rootLogger.getAllAppenders();
        if (appenders != null) {
            while (appenders.hasMoreElements()) {
                try {
                    Object element = appenders.nextElement();
                    if (element == null || !(element instanceof FileAppender)) continue;
                    FileAppender fileAppender = (FileAppender)element;
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            appendersToRemove.forEach(fa -> rootLogger.removeAppender((Appender)fa));
        }
        FileUtils.deleteDirectory((File)coe.getResultRoot());
    }
}

