/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro1;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.intocps.maestro.webapi.maestro1.Maestro1SimulationController;
import org.intocps.orchestration.coe.config.ModelConnection;
import org.intocps.orchestration.coe.cosim.BasicFixedStepSizeCalculator;
import org.intocps.orchestration.coe.cosim.CoSimStepSizeCalculator;
import org.intocps.orchestration.coe.cosim.VariableStepSizeCalculator;
import org.intocps.orchestration.coe.cosim.varstep.StepsizeInterval;
import org.intocps.orchestration.coe.httpserver.Algorithm;
import org.intocps.orchestration.coe.httpserver.RequestProcessors;
import org.intocps.orchestration.coe.json.InitializationMsgJson;
import org.intocps.orchestration.coe.scala.Coe;
import org.intocps.orchestration.coe.scala.LogVariablesContainer;
import org.intocps.orchestration.coe.util.ZipDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/maestro1/"})
public class Maestro1SimulationController {
    static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(Maestro1SimulationController.class);
    private final Map<String, Coe> sessions = new HashMap();

    public static InitializationMsgJson.Constraint convert(IVarStepConstraint constraint) {
        if (constraint instanceof IninializationData.FmuMaxStepSizeConstraint) {
            InitializationMsgJson.Constraint c = new InitializationMsgJson.Constraint();
            c.type = "fmumaxstepsize";
            return c;
        }
        if (constraint instanceof IninializationData.BoundedDifferenceConstraint) {
            IninializationData.BoundedDifferenceConstraint cIn = (IninializationData.BoundedDifferenceConstraint)constraint;
            InitializationMsgJson.Constraint c = new InitializationMsgJson.Constraint();
            c.type = "boundeddifference";
            c.abstol = cIn.abstol;
            c.ports = cIn.ports;
            c.reltol = cIn.reltol;
            c.safety = cIn.safety;
            c.skipDiscrete = cIn.skipDiscrete;
            return c;
        }
        if (constraint instanceof IninializationData.SamplingConstraint) {
            IninializationData.SamplingConstraint cIn = (IninializationData.SamplingConstraint)constraint;
            InitializationMsgJson.Constraint c = new InitializationMsgJson.Constraint();
            c.type = "samplingrate";
            c.base = cIn.base;
            c.rate = cIn.rate;
            c.startTime = cIn.startTime;
            return c;
        }
        if (constraint instanceof IninializationData.ZeroCrossingConstraint) {
            IninializationData.ZeroCrossingConstraint cIn = (IninializationData.ZeroCrossingConstraint)constraint;
            InitializationMsgJson.Constraint c = new InitializationMsgJson.Constraint();
            c.type = "zerocrossing";
            c.abstol = cIn.abstol;
            c.ports = cIn.ports;
            c.order = cIn.order;
            c.safety = cIn.safety;
            return c;
        }
        return null;
    }

    @RequestMapping(value={"/upload/{sessionId}"}, method={RequestMethod.POST})
    public void uploadFile(@PathVariable String sessionId, @ApiParam(value="File", required=true) @RequestParam(value="fieldFile") MultipartFile file) throws IOException {
        try (InputStream is = file.getInputStream();){
            logger.debug("Uploaded file: {}", (Object)file.getOriginalFilename());
            File targetFile = new File(((Coe)this.sessions.get(sessionId)).getResultRoot(), file.getOriginalFilename());
            IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(targetFile));
        }
    }

    @RequestMapping(value={"/ping"}, method={RequestMethod.GET})
    public String ping() {
        return "OK";
    }

    StatusModel getStatus(String sessionId) {
        Coe coe = (Coe)this.sessions.get(sessionId);
        return new StatusModel(coe.getState(), sessionId, coe.getLastExecTime());
    }

    @RequestMapping(value={"/status/{sessionId}"}, method={RequestMethod.GET})
    public List<StatusModel> getStatuses(@PathVariable String sessionId) {
        return Arrays.asList(this.getStatus(sessionId));
    }

    @RequestMapping(value={"/createSession"}, method={RequestMethod.GET})
    public StatusModel createSession() {
        String session = UUID.randomUUID().toString();
        File root = new File(session);
        root.mkdirs();
        this.sessions.put(session, new Coe(root));
        return this.getStatus(session);
    }

    @RequestMapping(value={"/initialize/{sessionId}"}, method={RequestMethod.POST})
    public InitializeStatusModel initializeSession(@PathVariable String sessionId, @RequestBody IninializationData body) throws Exception {
        FixedStepAlgorithmConfig algorithm;
        logger.debug("Got initial data: {}", (Object)new ObjectMapper().writeValueAsString((Object)body));
        Coe coe = (Coe)this.sessions.get(sessionId);
        if (coe == null) {
            throw new Exception("bad session");
        }
        if (body == null) {
            throw new Exception("Could not parse configuration: ");
        }
        if (body.fmus == null) {
            throw new Exception("FMUs must not be null");
        }
        if (body.connections == null) {
            throw new Exception("Connections must not be null");
        }
        BasicFixedStepSizeCalculator stepSizeCalculator = null;
        Algorithm stepAlgorithm = Algorithm.NONE;
        if (body.algorithm == null) {
            stepAlgorithm = Algorithm.FIXED;
            stepSizeCalculator = new BasicFixedStepSizeCalculator(0.1);
            logger.info("No step size algorithm given. Defaulting to fixed-step with size 0.1");
        } else if (body.algorithm instanceof FixedStepAlgorithmConfig) {
            algorithm = (FixedStepAlgorithmConfig)body.algorithm;
            if (algorithm.size == null) {
                throw new Exception("fixed-step size must be an integer or double");
            }
            logger.info("Using Fixed-step size calculator with size = {}", (Object)algorithm.size);
            stepSizeCalculator = new BasicFixedStepSizeCalculator(algorithm.size.doubleValue());
            stepAlgorithm = Algorithm.FIXED;
        } else if (body.algorithm instanceof VariableStepAlgorithmConfig) {
            algorithm = (VariableStepAlgorithmConfig)body.algorithm;
            if (algorithm.size.length != 2) {
                logger.error("Unable to obtain the two size intervals");
                throw new Exception("size must be a 2-dimensional array of doubles: [minsize,maxsize]");
            }
            StepsizeInterval stepsizeInterval = new StepsizeInterval(algorithm.size[0], algorithm.size[1]);
            if (algorithm.initsize == null) {
                throw new Exception("initsize must be a double");
            }
            if (algorithm.constraints != null) {
                for (IVarStepConstraint c2 : algorithm.constraints) {
                    c2.validate();
                }
            }
            Set constraints = algorithm.constraints == null ? null : algorithm.constraints.stream().map(c -> Maestro1SimulationController.convert((IVarStepConstraint)c)).collect(Collectors.toSet());
            stepSizeCalculator = new VariableStepSizeCalculator(constraints, stepsizeInterval, algorithm.initsize);
            stepAlgorithm = Algorithm.VARSTEP;
            logger.info("Using Variable-step size calculator.");
        }
        Map logs = null;
        mapper.writeValue(new File(coe.getResultRoot(), "initialize.json"), (Object)body);
        try {
            coe.getConfiguration().isStabalizationEnabled = body.stabalizationEnabled;
            coe.getConfiguration().global_absolute_tolerance = body.global_absolute_tolerance;
            coe.getConfiguration().global_relative_tolerance = body.global_relative_tolerance;
            coe.getConfiguration().loggingOn = body.loggingOn;
            coe.getConfiguration().visible = body.visible;
            coe.getConfiguration().parallelSimulation = body.parallelSimulation;
            coe.getConfiguration().simulationProgramDelay = body.simulationProgramDelay;
            coe.getConfiguration().hasExternalSignals = body.hasExternalSignals;
            logs = coe.initialize(body.getFmuFiles(), RequestProcessors.buildConnections((Map)body.connections), RequestProcessors.buildParameters((Map)body.parameters), (CoSimStepSizeCalculator)stepSizeCalculator, new LogVariablesContainer(RequestProcessors.buildVariableMap((Map)body.livestream), RequestProcessors.buildVariableMap((Map)body.logVariables)));
            if (stepAlgorithm == Algorithm.VARSTEP && !coe.canDoVariableStep()) {
                logger.error("Initialization failed: One or more FMUs cannot perform variable step size");
            }
            logger.trace("Initialization completed obtained the following logging categories: {}", (Object)logs);
            return new InitializeStatusModel(coe.getState(), sessionId, null, coe.lastExecTime());
        }
        catch (Exception e) {
            logger.error("Internal error in initialization", (Throwable)e);
            throw new Exception("internal error");
        }
    }

    @RequestMapping(value={"/simulate/{sessionId}"}, method={RequestMethod.POST})
    public StatusModel simulate(@PathVariable String sessionId, @RequestBody SimulateRequestBody body) throws Exception {
        boolean async;
        Coe coe = (Coe)this.sessions.get(sessionId);
        mapper.writeValue(new File(coe.getResultRoot(), "simulate.json"), (Object)body);
        HashMap<ModelConnection.ModelInstance, List> logLevels = new HashMap<ModelConnection.ModelInstance, List>();
        if (body.logLevels != null) {
            for (Map.Entry entry : body.logLevels.entrySet()) {
                try {
                    logLevels.put(ModelConnection.ModelInstance.parse((String)((String)entry.getKey())), (List)entry.getValue());
                }
                catch (Exception e) {
                    throw new Exception("Error in logging levels");
                }
            }
        }
        if (!(async = false)) {
            try {
                coe.simulate(body.startTime, body.endTime, logLevels, body.reportProgress.booleanValue(), (double)body.liveLogInterval.intValue());
                return this.getStatus(sessionId);
            }
            catch (Exception e) {
                logger.error("Error in simulation", (Throwable)e);
                throw e;
            }
        }
        new Thread(() -> {
            try {
                coe.simulate(body.startTime, body.endTime, logLevels, body.reportProgress.booleanValue(), (double)body.liveLogInterval.intValue());
            }
            catch (Exception e) {
                coe.setLastError(e);
            }
        }).start();
        return this.getStatus(sessionId);
    }

    @RequestMapping(value={"/stopsimulation/{sessionId}"}, method={RequestMethod.POST})
    public void stop(@PathVariable String sessionId) {
        if (this.sessions.containsKey(sessionId)) {
            ((Coe)this.sessions.get(sessionId)).stopSimulation();
        }
    }

    @RequestMapping(value={"/result/{sessionId}/plain"}, method={RequestMethod.GET})
    public ResponseEntity<Resource> getResultPlain(@PathVariable String sessionId) throws Exception {
        Coe coe = (Coe)this.sessions.get(sessionId);
        if (coe == null) {
            throw new Exception("bad session");
        }
        ByteArrayResource resource = new ByteArrayResource(FileUtils.readFileToByteArray((File)coe.getResult()));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).header("Content-Disposition", new String[]{"attachment; filename=\"" + coe.getResult().getName() + "\""})).body((Object)resource);
    }

    @RequestMapping(value={"/result/{sessionId}/zip"}, method={RequestMethod.GET}, produces={"application/zip"})
    public void getResultZip(@PathVariable String sessionId, HttpServletResponse response) throws Exception {
        Coe coe = (Coe)this.sessions.get(sessionId);
        if (coe == null) {
            throw new Exception("bad session");
        }
        response.setStatus(200);
        response.addHeader("Content-Disposition", "attachment; filename=\"results.zip\"");
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
        ZipDirectory.addDir((File)coe.getResultRoot(), (File)coe.getResultRoot(), (ZipOutputStream)zipOutputStream);
        zipOutputStream.close();
    }

    @RequestMapping(value={"/destroy/{sessionId}"}, method={RequestMethod.GET})
    public void destroy(@PathVariable String sessionId) throws Exception {
        Coe coe = (Coe)this.sessions.get(sessionId);
        if (coe == null) {
            throw new Exception("bad session");
        }
        org.apache.log4j.Logger rootLogger = org.apache.log4j.Logger.getRootLogger();
        ArrayList<FileAppender> appendersToRemove = new ArrayList<FileAppender>();
        Enumeration appenders = rootLogger.getAllAppenders();
        if (appenders != null) {
            while (appenders.hasMoreElements()) {
                try {
                    FileAppender fileAppender;
                    Object element = appenders.nextElement();
                    if (element == null || !(element instanceof FileAppender) || (fileAppender = (FileAppender)element).getFile() == null || !fileAppender.getFile().matches("(.*)(" + sessionId + ")[/\\\\](.*)[/\\\\].*(\\.log)$")) continue;
                    fileAppender.close();
                    appendersToRemove.add(fileAppender);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            appendersToRemove.forEach(fa -> rootLogger.removeAppender((Appender)fa));
        }
        FileUtils.deleteDirectory((File)coe.getResultRoot());
    }
}

