/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro2.interpreter;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.datawriter.DataListenerUtilities;
import org.intocps.maestro.interpreter.values.datawriter.IDataListener;
import org.intocps.maestro.webapi.maestro2.interpreter.WebsocketDataWriter;
import org.intocps.maestro.webapi.maestro2.interpreter.WebsocketValueConverter;
import org.springframework.web.socket.WebSocketSession;

public class WebsocketDataWriter
implements IDataListener {
    final List<String> filter;
    final double interval;
    private final HashMap<UUID, WebsocketDataWriterInstance> instances = new HashMap();
    private final WebSocketSession webSocketSession;
    private final WebsocketValueConverter webSocketConverter;

    public WebsocketDataWriter(WebSocketSession ws, List<String> filter, double interval) {
        this.webSocketSession = ws;
        this.filter = filter;
        this.webSocketConverter = new WebsocketValueConverter(ws);
        this.interval = interval;
    }

    public void writeHeader(UUID uuid, List<String> headers) {
        List hoi = this.filter;
        List ioi = DataListenerUtilities.indicesOfInterest(headers, (List)hoi);
        WebsocketDataWriterInstance wdwi = new WebsocketDataWriterInstance(hoi, ioi);
        wdwi.interval = this.interval;
        this.instances.put(uuid, wdwi);
        this.webSocketConverter.configure(hoi);
    }

    public void writeDataPoint(UUID uuid, double time, List<Value> dataPoint) {
        WebsocketDataWriterInstance instance = (WebsocketDataWriterInstance)this.instances.get(uuid);
        if (instance.shallLog(Double.valueOf(time)).booleanValue()) {
            instance.updateNextReportTime();
            Vector<Object> data = new Vector<Object>();
            for (Integer i : instance.indicesOfInterest) {
                Value d = dataPoint.get(i);
                if (d instanceof IntegerValue) {
                    data.add(((IntegerValue)d).intValue());
                }
                if (d instanceof RealValue) {
                    data.add(((RealValue)d).realValue());
                }
                if (!(d instanceof BooleanValue)) continue;
                data.add("" + Boolean.valueOf(((BooleanValue)d).getValue()));
            }
            this.webSocketConverter.update(time, data);
            this.webSocketConverter.send();
        }
    }

    public void close() {
        try {
            this.webSocketSession.close();
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
    }
}

