/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intocps.maestro.Mabl;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.display.PrettyPrinter;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.core.api.FixedStepAlgorithm;
import org.intocps.maestro.core.api.IStepAlgorithm;
import org.intocps.maestro.core.api.VariableStepAlgorithm;
import org.intocps.maestro.core.messages.ErrorReporter;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.fmi2.ComponentInfo;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironmentConfiguration;
import org.intocps.maestro.framework.fmi2.LegacyMMSupport;
import org.intocps.maestro.interpreter.DefaultExternalValueFactory;
import org.intocps.maestro.interpreter.MableInterpreter;
import org.intocps.maestro.plugin.IPluginConfiguration;
import org.intocps.maestro.plugin.JacobianStepConfig;
import org.intocps.maestro.template.MaBLTemplateConfiguration;
import org.intocps.maestro.webapi.maestro2.dto.FixedStepAlgorithmConfig;
import org.intocps.maestro.webapi.maestro2.dto.InitializationData;
import org.intocps.maestro.webapi.maestro2.dto.SimulateRequestBody;
import org.intocps.maestro.webapi.maestro2.dto.VariableStepAlgorithmConfig;
import org.intocps.maestro.webapi.maestro2.interpreter.WebApiInterpreterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketSession;

public class Maestro2Broker {
    private static final Logger logger = LoggerFactory.getLogger(Maestro2Broker.class);
    final Mabl mabl;
    final File workingDirectory;
    final ErrorReporter reporter;

    public Maestro2Broker(File workingDirectory, ErrorReporter reporter) throws IOException {
        this.workingDirectory = workingDirectory;
        Mabl.MableSettings mableSettings = new Mabl.MableSettings();
        mableSettings.dumpIntermediateSpecs = false;
        mableSettings.inlineFrameworkConfig = true;
        this.mabl = new Mabl(workingDirectory, null, mableSettings);
        this.reporter = reporter;
        this.mabl.setReporter((IErrorReporter)this.reporter);
    }

    public void buildAndRun(InitializationData initializeRequest, SimulateRequestBody body, WebSocketSession socket, File csvOutputFile) throws Exception {
        FixedStepAlgorithm algorithm;
        Fmi2SimulationEnvironmentConfiguration simulationConfiguration = new Fmi2SimulationEnvironmentConfiguration();
        simulationConfiguration.fmus = initializeRequest.getFmus();
        if (simulationConfiguration.fmus == null) {
            simulationConfiguration.fmus = new HashMap();
        }
        simulationConfiguration.connections = initializeRequest.getConnections();
        if (simulationConfiguration.connections == null) {
            simulationConfiguration.connections = new HashMap();
        }
        simulationConfiguration.logVariables = initializeRequest.getLogVariables();
        if (simulationConfiguration.logVariables == null) {
            simulationConfiguration.variablesToLog = new HashMap();
        }
        simulationConfiguration.livestream = initializeRequest.getLivestream();
        Map instanceRemapping = LegacyMMSupport.adjustFmi2SimulationEnvironmentConfiguration((Fmi2SimulationEnvironmentConfiguration)simulationConfiguration);
        HashMap<String, Object> initialize = new HashMap<String, Object>();
        Map parameters = initializeRequest.getParameters();
        if (parameters != null) {
            initialize.put("parameters", parameters);
            if (instanceRemapping != null && instanceRemapping.size() > 0) {
                LegacyMMSupport.fixVariableToXMap((Map)instanceRemapping, (Map)parameters);
            }
        }
        if (initializeRequest.getEnvironmentParameters() != null) {
            initialize.put("environmentParameters", initializeRequest.getEnvironmentParameters());
        }
        Fmi2SimulationEnvironment simulationEnvironment = Fmi2SimulationEnvironment.of((Fmi2SimulationEnvironmentConfiguration)simulationConfiguration, (IErrorReporter)this.reporter);
        HashMap removedFMUKeyFromLogLevels = body.getLogLevels() == null ? new HashMap() : body.getLogLevels().entrySet().stream().collect(Collectors.toMap(entry -> MaBLTemplateConfiguration.MaBLTemplateConfigurationBuilder.getFmuInstanceFromFmuKeyInstance((String)((String)entry.getKey())), Map.Entry::getValue));
        JacobianStepConfig config = new JacobianStepConfig();
        config.stabilisation = initializeRequest.isStabalizationEnabled();
        config.absoluteTolerance = initializeRequest.getGlobal_absolute_tolerance();
        config.relativeTolerance = initializeRequest.getGlobal_relative_tolerance();
        config.stabilisationLoopMaxIterations = 5;
        config.simulationProgramDelay = initializeRequest.isSimulationProgramDelay();
        if (initializeRequest.getAlgorithm() instanceof FixedStepAlgorithmConfig) {
            algorithm = new FixedStepAlgorithm(body.getEndTime(), ((FixedStepAlgorithmConfig)initializeRequest.getAlgorithm()).getSize().doubleValue(), body.getStartTime());
        } else if (initializeRequest.getAlgorithm() instanceof VariableStepAlgorithmConfig) {
            algorithm = new VariableStepAlgorithm(body.getEndTime(), ((VariableStepAlgorithmConfig)initializeRequest.getAlgorithm()).getSize(), ((VariableStepAlgorithmConfig)initializeRequest.getAlgorithm()).getInitsize(), new ObjectMapper().writeValueAsString((Object)initializeRequest.getAlgorithm()), body.getStartTime());
            ((VariableStepAlgorithmConfig)initializeRequest.getAlgorithm()).getConstraints().values().forEach(v -> {
                if (v instanceof InitializationData.ZeroCrossingConstraint) {
                    config.variablesOfInterest.addAll(((InitializationData.ZeroCrossingConstraint)v).getPorts());
                } else if (v instanceof InitializationData.BoundedDifferenceConstraint) {
                    config.variablesOfInterest.addAll(((InitializationData.BoundedDifferenceConstraint)v).getPorts());
                }
            });
        } else {
            throw new Exception("Could not get algorithm from specification");
        }
        MaBLTemplateConfiguration.MaBLTemplateConfigurationBuilder builder = MaBLTemplateConfiguration.MaBLTemplateConfigurationBuilder.getBuilder().setFrameworkConfig(Framework.FMI2, simulationConfiguration).useInitializer(true, new ObjectMapper().writeValueAsString(initialize)).setFramework(Framework.FMI2).setLogLevels(removedFMUKeyFromLogLevels).setVisible(initializeRequest.isVisible()).setLoggingOn(initializeRequest.isLoggingOn()).setStepAlgorithm((IStepAlgorithm)algorithm).setStepAlgorithmConfig((IPluginConfiguration)config);
        MaBLTemplateConfiguration configuration = builder.build();
        String runtimeJsonConfigString = this.generateSpecification(configuration, parameters);
        if (!((Boolean)this.mabl.typeCheck().getKey()).booleanValue()) {
            throw new Exception("Specification did not type check");
        }
        if (!this.mabl.verify(Framework.FMI2)) {
            throw new Exception("Specification did not verify");
        }
        Function<Map, List> flattenFmuIds = map -> map.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(v -> (String)entry.getKey() + "." + v)).collect(Collectors.toList());
        List connectedOutputs = simulationEnvironment.getConnectedOutputs().stream().map(x -> {
            ComponentInfo i = (ComponentInfo)simulationEnvironment.getUnitInfo(new LexIdentifier(x.instance.getText(), null), Framework.FMI2);
            return String.format("%s.%s.%s", i.fmuIdentifier, x.instance.getText(), x.scalarVariable.getName());
        }).collect(Collectors.toList());
        this.executeInterpreter(socket, Stream.concat(connectedOutputs.stream(), (initializeRequest.getLogVariables() == null ? new Vector() : flattenFmuIds.apply(initializeRequest.getLogVariables())).stream()).collect(Collectors.toList()), initializeRequest.getLivestream() == null ? new Vector() : flattenFmuIds.apply(initializeRequest.getLivestream()), body.getLiveLogInterval() == null ? 0.0 : body.getLiveLogInterval(), csvOutputFile, (InputStream)new ByteArrayInputStream(runtimeJsonConfigString.getBytes()));
    }

    public String generateSpecification(MaBLTemplateConfiguration config, Map<String, Object> parameters) throws Exception {
        this.mabl.generateSpec(config);
        this.mabl.expand();
        this.mabl.setRuntimeEnvironmentVariables(parameters);
        this.mabl.dump(this.workingDirectory);
        logger.debug(PrettyPrinter.printLineNumbers((INode)this.mabl.getMainSimulationUnit()));
        return new ObjectMapper().writeValueAsString(this.mabl.getRuntimeData());
    }

    public void executeInterpreter(WebSocketSession webSocket, List<String> csvFilter, List<String> webSocketFilter, double interval, File csvOutputFile, InputStream config) throws IOException, AnalysisException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        WebApiInterpreterFactory factory = webSocket != null ? new WebApiInterpreterFactory(this.workingDirectory, webSocket, interval, webSocketFilter, new File(this.workingDirectory, "outputs.csv"), csvFilter, config) : new WebApiInterpreterFactory(this.workingDirectory, csvOutputFile, csvFilter, config);
        new MableInterpreter((DefaultExternalValueFactory)factory).execute(this.mabl.getMainSimulationUnit());
    }

    public void setVerbose(boolean verbose) {
        this.mabl.setVerbose(verbose);
    }
}

