/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro2.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intocps.maestro.webapi.maestro2.dto.IAlgorithmConfig;
import org.intocps.maestro.webapi.maestro2.dto.InitializationData;

public class InitializationData {
    @JsonIgnore
    @JsonProperty(value="liveGraphColumns")
    final Object liveGraphColumns = null;
    @JsonIgnore
    @JsonProperty(value="liveGraphVisibleRowCount")
    final Object liveGraphVisibleRowCount = null;
    @JsonIgnore
    @JsonProperty(value="livestreamInterval")
    final Object livestreamInterval = null;
    @JsonProperty(value="fmus")
    final Map<String, String> fmus;
    @JsonProperty(value="connections")
    final Map<String, List<String>> connections;
    @JsonProperty(value="parameters")
    final Map<String, Object> parameters;
    @JsonProperty(value="environmentParameters")
    final List<String> environmentParameters;
    @JsonProperty(value="livestream")
    final Map<String, List<String>> livestream;
    @JsonProperty(value="logVariables")
    final Map<String, List<String>> logVariables;
    @JsonProperty(value="parallelSimulation")
    final boolean parallelSimulation;
    @JsonProperty(value="stabalizationEnabled")
    final boolean stabalizationEnabled;
    @JsonProperty(value="global_absolute_tolerance")
    final double global_absolute_tolerance;
    @JsonProperty(value="global_relative_tolerance")
    final double global_relative_tolerance;
    @JsonProperty(value="loggingOn")
    final boolean loggingOn;
    @JsonProperty(value="visible")
    final boolean visible;
    @JsonProperty(value="simulationProgramDelay")
    final boolean simulationProgramDelay;
    @JsonProperty(value="hasExternalSignals")
    final boolean hasExternalSignals;
    @JsonProperty(value="overrideLogLevel")
    final InitializeLogLevel overrideLogLevel;
    @JsonProperty(value="algorithm")
    IAlgorithmConfig algorithm;

    @JsonCreator
    public InitializationData(@JsonProperty(value="fmus") Map<String, String> fmus, @JsonProperty(value="connections") Map<String, List<String>> connections, @JsonProperty(value="parameters") Map<String, Object> parameters, @JsonProperty(value="livestream") Map<String, List<String>> livestream, @JsonProperty(value="logVariables") Map<String, List<String>> logVariables, @JsonProperty(value="parallelSimulation") boolean parallelSimulation, @JsonProperty(value="stabalizationEnabled") boolean stabalizationEnabled, @JsonProperty(value="global_absolute_tolerance") double global_absolute_tolerance, @JsonProperty(value="global_relative_tolerance") double global_relative_tolerance, @JsonProperty(value="loggingOn") boolean loggingOn, @JsonProperty(value="visible") boolean visible, @JsonProperty(value="simulationProgramDelay") boolean simulationProgramDelay, @JsonProperty(value="hasExternalSignals") boolean hasExternalSignals, @JsonProperty(value="algorithm") IAlgorithmConfig algorithm, @JsonProperty(value="overrideLogLevel") InitializeLogLevel overrideLogLevel, @JsonProperty(value="liveGraphColumns") Object liveGraphColumns, @JsonProperty(value="liveGraphVisibleRowCount") Object liveGraphVisibleRowCount, @JsonProperty(value="livestreamInterval") Object livestreamInterval, @JsonProperty(value="environmentParameters") List<String> environmentParameters) {
        this.fmus = fmus;
        this.connections = connections;
        this.parameters = parameters;
        this.livestream = livestream;
        this.logVariables = logVariables;
        this.loggingOn = loggingOn;
        this.visible = visible;
        this.simulationProgramDelay = simulationProgramDelay;
        this.hasExternalSignals = hasExternalSignals;
        this.parallelSimulation = parallelSimulation;
        this.stabalizationEnabled = stabalizationEnabled;
        this.global_absolute_tolerance = global_absolute_tolerance;
        this.global_relative_tolerance = global_relative_tolerance;
        this.algorithm = algorithm;
        this.overrideLogLevel = overrideLogLevel;
        this.environmentParameters = environmentParameters;
    }

    public List<String> getEnvironmentParameters() {
        return this.environmentParameters;
    }

    public InitializeLogLevel getOverrideLogLevel() {
        return this.overrideLogLevel;
    }

    public Map<String, String> getFmus() {
        return this.fmus;
    }

    public Map<String, List<String>> getConnections() {
        return this.connections;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Map<String, List<String>> getLivestream() {
        return this.livestream;
    }

    public Map<String, List<String>> getLogVariables() {
        return this.logVariables;
    }

    public boolean isParallelSimulation() {
        return this.parallelSimulation;
    }

    public boolean isStabalizationEnabled() {
        return this.stabalizationEnabled;
    }

    public double getGlobal_absolute_tolerance() {
        return this.global_absolute_tolerance;
    }

    public double getGlobal_relative_tolerance() {
        return this.global_relative_tolerance;
    }

    public boolean isLoggingOn() {
        return this.loggingOn;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isSimulationProgramDelay() {
        return this.simulationProgramDelay;
    }

    public boolean isHasExternalSignals() {
        return this.hasExternalSignals;
    }

    public IAlgorithmConfig getAlgorithm() {
        return this.algorithm;
    }

    @JsonIgnore
    public Map<String, URI> getFmuFiles() throws Exception {
        HashMap<String, URI> files = new HashMap<String, URI>();
        if (this.fmus != null) {
            for (Map.Entry entry : this.fmus.entrySet()) {
                try {
                    files.put((String)entry.getKey(), new URI((String)entry.getValue()));
                }
                catch (Exception e) {
                    throw new Exception((String)entry.getKey() + "-" + (String)entry.getValue() + ": " + e.getMessage(), e);
                }
            }
        }
        return files;
    }
}

