/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.intocps.maestro.MaestroV1CliProxy;
import org.intocps.maestro.Main;
import org.intocps.maestro.webapi.Application;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.context.ServletWebServerInitializedEvent;
import org.springframework.context.event.EventListener;

@SpringBootApplication
public class Application {
    static final ObjectMapper mapper = new ObjectMapper();
    private static boolean serverAcquiresPort = false;

    @EventListener
    public void onApplicationEvent(ServletWebServerInitializedEvent event) {
        if (serverAcquiresPort) {
            int port = event.getWebServer().getPort();
            System.err.println("Server acquired port: {" + port + "}");
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("cliMain")) {
            Main.argumentHandler((String[])((String[])Arrays.stream(args).skip(1L).toArray(String[]::new)));
        } else {
            CommandLine cmd = MaestroV1CliProxy.parse((String[])args);
            if (!MaestroV1CliProxy.process((CommandLine)cmd, (MaestroV1CliProxy.OneShotRunner)new MableV1ToV2ProxyRunner(), port -> {
                serverAcquiresPort = port == 0;
                SpringApplication app = new SpringApplication(new Class[]{Application.class});
                app.run(new String[]{"--server.port=" + port});
            })) {
                System.exit(1);
            }
        }
    }
}

