/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro2;

import api.TraceResult;
import api.VerificationAPI;
import cli.VerifyTA;
import core.MasterModel;
import core.ModelEncoding;
import core.ScenarioGenerator;
import core.ScenarioLoader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.intocps.maestro.core.dto.ExtendedMultiModel;
import org.intocps.maestro.core.messages.ErrorReporter;
import org.intocps.maestro.plugin.MasterModelMapper;
import org.intocps.maestro.webapi.dto.ExecutableMasterAndMultiModelTDO;
import org.intocps.maestro.webapi.dto.VerificationDTO;
import org.intocps.maestro.webapi.maestro2.Maestro2Broker;
import org.intocps.maestro.webapi.maestro2.dto.SigverSimulateRequestBody;
import org.intocps.maestro.webapi.util.ZipDirectory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import synthesizer.ConfParser.ScenarioConfGenerator;

@RestController
@Component
public class Maestro2ScenarioController {
    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseEntity<String> handleJsonParseException(HttpMessageNotReadableException exception, HttpServletRequest request) {
        return new ResponseEntity((Object)exception.getMessage(), HttpStatus.BAD_REQUEST);
    }

    @RequestMapping(value={"/generateAlgorithmFromScenario"}, method={RequestMethod.POST}, consumes={"text/plain"}, produces={"text/plain"})
    public String generateAlgorithmFromScenario(@RequestBody String scenario) {
        MasterModel masterModel = MasterModelMapper.Companion.scenarioToMasterModel(scenario);
        return ScenarioConfGenerator.generate((MasterModel)masterModel, (String)masterModel.name());
    }

    @RequestMapping(value={"/generateAlgorithmFromMultiModel"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"text/plain"})
    public String generateAlgorithmFromMultiModel(@RequestBody ExtendedMultiModel multiModel) {
        MasterModel masterModel = MasterModelMapper.Companion.multiModelToMasterModel(multiModel, 3);
        return ScenarioConfGenerator.generate((MasterModel)masterModel, (String)masterModel.name());
    }

    @RequestMapping(value={"/verifyAlgorithm"}, method={RequestMethod.POST}, consumes={"text/plain"}, produces={"application/json"})
    public VerificationDTO verifyAlgorithm(@RequestBody String masterModelAsString) throws IOException {
        try {
            VerificationAPI.checkUppaalVersion();
        }
        catch (Exception e) {
            return new VerificationDTO(false, "", "UPPAAL v.4.1 is not in PATH - please install it and try again!");
        }
        MasterModel masterModel = ScenarioLoader.load((InputStream)new ByteArrayInputStream(masterModelAsString.getBytes()));
        ModelEncoding encoding = new ModelEncoding(masterModel);
        String encodedModel = ScenarioGenerator.generate((ModelEncoding)encoding);
        File tempFile = Files.createTempFile(null, ".xml", new FileAttribute[0]).toFile();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), StandardCharsets.UTF_8));){
            writer.write(encodedModel);
        }
        int verificationCode = VerifyTA.verify((File)tempFile);
        tempFile.delete();
        switch (verificationCode) {
            case 0: {
                return new VerificationDTO(true, encodedModel, "");
            }
            case 1: {
                return new VerificationDTO(false, encodedModel, "Model is not valid. Generate the trace and use it to correct the algorithm.");
            }
            case 2: {
                return new VerificationDTO(false, encodedModel, "The verification in Uppaal failed most likely due to a syntax error in the UPPAAL model.");
            }
        }
        return new VerificationDTO(false, encodedModel, "");
    }

    @RequestMapping(value={"/visualizeTrace"}, method={RequestMethod.POST}, consumes={"text/plain"}, produces={"video/mp4"})
    public FileSystemResource visualizeTrace(@RequestBody String masterModelAsString) throws Exception {
        MasterModel masterModel = ScenarioLoader.load((InputStream)new ByteArrayInputStream(masterModelAsString.getBytes()));
        TraceResult traceResult = VerificationAPI.generateTraceFromMasterModel((MasterModel)masterModel);
        if (!traceResult.isGenerated()) {
            throw new Exception("Unable to generate trace results - the algorithm is probably successfully verified");
        }
        return new FileSystemResource(traceResult.file());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/executeAlgorithm"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/octet-stream"})
    public void executeAlgorithm(@RequestBody ExecutableMasterAndMultiModelTDO executableModel, HttpServletResponse response) throws Exception {
        if (executableModel.getMultiModel().getFmus() == null || executableModel.getMultiModel().getFmus().isEmpty()) {
            throw new IllegalArgumentException("Missing FMUs in multi model");
        }
        MasterModel masterModel = executableModel.getMasterModel().equals("") ? MasterModelMapper.Companion.multiModelToMasterModel(executableModel.getMultiModel(), 3) : ScenarioLoader.load((InputStream)new ByteArrayInputStream(executableModel.getMasterModel().getBytes()));
        if (executableModel.getMultiModel().sigver.verification && !VerificationAPI.verifyAlgorithm((MasterModel)masterModel)) {
            throw new Exception("Algorithm did not verify successfully - unable to execute it");
        }
        File zipDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        try {
            ErrorReporter reporter = new ErrorReporter();
            Maestro2Broker broker = new Maestro2Broker(zipDir, reporter, () -> false);
            SigverSimulateRequestBody requestBody = new SigverSimulateRequestBody(executableModel.getExecutionParameters().getStartTime(), executableModel.getExecutionParameters().getEndTime(), Map.of(), false, 0.0, ScenarioConfGenerator.generate((MasterModel)masterModel, (String)masterModel.name()));
            broker.buildAndRunMasterModel(null, null, executableModel.getMultiModel(), requestBody, new File(zipDir, "outputs.csv"));
            if (reporter.getErrorCount() > 0) {
                throw new Exception("Error(s) occurred during MaBL specification generation: " + reporter);
            }
            if (reporter.getWarningCount() > 0) {
                PrintWriter printWriter = new PrintWriter(Path.of(zipDir.getPath(), "Specification-generation-warnings.log").toFile());
                reporter.printWarnings(printWriter);
                printWriter.close();
            }
            response.setStatus(200);
            response.addHeader("Content-Disposition", "attachment; filename=\"results.zip\"");
            try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());){
                ZipDirectory.addDir(zipDir, zipDir, zipOutputStream);
            }
        }
        finally {
            zipDir.delete();
        }
    }
}

