/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.services;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.fmi.FmiInvalidNativeStateException;
import org.intocps.fmi.FmuInvocationException;
import org.intocps.fmi.FmuMissingLibraryException;
import org.intocps.fmi.IFmiComponent;
import org.intocps.fmi.IFmu;
import org.intocps.fmi.IFmuCallback;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.framework.fmi2.InvalidVariableStringException;
import org.intocps.maestro.framework.fmi2.ModelConnection;
import org.intocps.maestro.plugin.initializer.ModelParameter;
import org.intocps.maestro.webapi.services.EnvironmentFMUComponent;
import org.intocps.maestro.webapi.services.EnvironmentFMUModelDescription;
import org.intocps.maestro.webapi.services.IOTYPE;

public class EnvironmentFMU
implements IFmu {
    private static EnvironmentFMU environmentFMU;
    final ModelConnection.ModelInstance environmentFmuModelInstance;
    final String fmuName;
    private final Map<String, Fmi2ModelDescription.ScalarVariable> sourceToEnvironmentVariableInputs = new HashMap<String, Fmi2ModelDescription.ScalarVariable>();
    private final Map<String, Fmi2ModelDescription.ScalarVariable> sourceToEnvironmentVariableOutputs = new HashMap<String, Fmi2ModelDescription.ScalarVariable>();
    private final List<Fmi2ModelDescription.ScalarVariable> inputs = new ArrayList<Fmi2ModelDescription.ScalarVariable>();
    private final List<Fmi2ModelDescription.ScalarVariable> outputs = new ArrayList<Fmi2ModelDescription.ScalarVariable>();
    private Integer nextValueReference = 1;
    private String modelDescriptionXML;
    private EnvironmentFMUComponent environmentFMUComponent;

    public EnvironmentFMU(String fmuName, String instanceName) {
        this.fmuName = fmuName;
        this.environmentFmuModelInstance = new ModelConnection.ModelInstance("{" + fmuName + "}", instanceName);
    }

    public static EnvironmentFMU getInstance() {
        return environmentFMU;
    }

    public static EnvironmentFMU createEnvironmentFMU(String fmuName, String instanceName) {
        environmentFMU = new EnvironmentFMU(fmuName, instanceName);
        return EnvironmentFMU.getInstance();
    }

    public Map<ModelConnection.Variable, Object> getRequestedOutputValues() throws InvalidVariableStringException {
        HashMap<ModelConnection.Variable, Object> requestedOutputValues = new HashMap<ModelConnection.Variable, Object>();
        for (Map.Entry<String, Fmi2ModelDescription.ScalarVariable> entry : this.sourceToEnvironmentVariableInputs.entrySet()) {
            requestedOutputValues.put(ModelConnection.Variable.parse((String)entry.getKey()), this.environmentFMUComponent.getValue(entry.getValue()));
        }
        return requestedOutputValues;
    }

    public void setOutputValues(List<ModelParameter> outputValues) {
        outputValues.forEach(output -> this.environmentFMUComponent.setOutput(this.sourceToEnvironmentVariableOutputs.get(output.variable.toString()), output.value));
    }

    public Map<String, Fmi2ModelDescription.ScalarVariable> getSourceToEnvironmentVariableInputs() {
        return this.sourceToEnvironmentVariableInputs;
    }

    public Map<String, Fmi2ModelDescription.ScalarVariable> getSourceToEnvironmentVariableOutputs() {
        return this.sourceToEnvironmentVariableOutputs;
    }

    public ModelConnection.Variable createVariable(Fmi2ModelDescription.ScalarVariable sv) throws InvalidVariableStringException {
        return ModelConnection.Variable.parse((String)(this.environmentFmuModelInstance.toString() + "." + sv.name));
    }

    public void createModelDescriptionXML() {
        this.modelDescriptionXML = EnvironmentFMUModelDescription.createEnvironmentFMUModelDescription(this.inputs, this.outputs, this.fmuName);
    }

    private Object start(Fmi2ModelDescription.Type type) {
        if (type.start != null) {
            return type.start;
        }
        switch (type.type) {
            case Boolean: {
                return false;
            }
            case Real: {
                return 0.0;
            }
            case Integer: 
            case Enumeration: {
                return 0;
            }
            case String: {
                return "";
            }
        }
        return null;
    }

    private Fmi2ModelDescription.ScalarVariable createOutputScalarVariable(Fmi2ModelDescription.ScalarVariable sourceScalarVariable, long valueReference) {
        Fmi2ModelDescription.ScalarVariable outputScalarVariable = new Fmi2ModelDescription.ScalarVariable();
        outputScalarVariable.causality = Fmi2ModelDescription.Causality.Output;
        outputScalarVariable.variability = ModelDescription.Variability.Discrete;
        outputScalarVariable.type = new Fmi2ModelDescription.Type();
        outputScalarVariable.type.type = sourceScalarVariable.type.type;
        if (sourceScalarVariable.type.start != null) {
            outputScalarVariable.type.start = sourceScalarVariable.type.start;
            outputScalarVariable.initial = ModelDescription.Initial.Exact;
        }
        outputScalarVariable.valueReference = valueReference;
        outputScalarVariable.name = sourceScalarVariable.name + valueReference;
        return outputScalarVariable;
    }

    private Fmi2ModelDescription.ScalarVariable createInputScalarVariable(Fmi2ModelDescription.ScalarVariable sourceScalarVariable, long valueReference) {
        Fmi2ModelDescription.ScalarVariable inpSv = new Fmi2ModelDescription.ScalarVariable();
        inpSv.causality = Fmi2ModelDescription.Causality.Input;
        inpSv.type = new Fmi2ModelDescription.Type();
        inpSv.type.type = sourceScalarVariable.type.type;
        inpSv.variability = ModelDescription.Variability.Discrete;
        inpSv.type.start = this.start(sourceScalarVariable.type);
        inpSv.valueReference = valueReference;
        inpSv.name = sourceScalarVariable.name + valueReference;
        return inpSv;
    }

    public List<Fmi2ModelDescription.ScalarVariable> getInputs() {
        return this.inputs;
    }

    public List<Fmi2ModelDescription.ScalarVariable> getOutputs() {
        return this.outputs;
    }

    public void load() throws FmuInvocationException, FmuMissingLibraryException {
    }

    public IFmiComponent instantiate(String s, String s1, boolean b, boolean b1, IFmuCallback iFmuCallback) throws XPathExpressionException, FmiInvalidNativeStateException {
        this.environmentFMUComponent = new EnvironmentFMUComponent(this, this.inputs, this.outputs);
        return this.environmentFMUComponent;
    }

    public void unLoad() throws FmiInvalidNativeStateException {
    }

    public String getVersion() throws FmiInvalidNativeStateException {
        return "2.0";
    }

    public String getTypesPlatform() throws FmiInvalidNativeStateException {
        return "";
    }

    public InputStream getModelDescription() throws ZipException, IOException {
        return new ByteArrayInputStream(this.modelDescriptionXML.getBytes());
    }

    public boolean isValid() {
        return false;
    }

    public void calculateInputs(HashMap<ModelConnection.ModelInstance, List<Fmi2ModelDescription.ScalarVariable>> envInputs) {
        this.calculateScalarVariable(envInputs, IOTYPE.INPUT);
    }

    private void calculateScalarVariable(Map<ModelConnection.ModelInstance, List<Fmi2ModelDescription.ScalarVariable>> envInputs, IOTYPE IO) {
        for (Map.Entry<ModelConnection.ModelInstance, List<Fmi2ModelDescription.ScalarVariable>> entry : envInputs.entrySet()) {
            for (Fmi2ModelDescription.ScalarVariable sv : entry.getValue()) {
                Fmi2ModelDescription.ScalarVariable newEnvSv = null;
                switch (IO) {
                    case INPUT: {
                        newEnvSv = this.createInputScalarVariable(sv, this.nextValueReference.intValue());
                        this.inputs.add(newEnvSv);
                        this.sourceToEnvironmentVariableInputs.put(new ModelConnection.Variable(entry.getKey(), sv.name).toString(), newEnvSv);
                        break;
                    }
                    case OUTPUT: {
                        newEnvSv = this.createOutputScalarVariable(sv, this.nextValueReference.intValue());
                        this.outputs.add(newEnvSv);
                        this.sourceToEnvironmentVariableOutputs.put(new ModelConnection.Variable(entry.getKey(), sv.name).toString(), newEnvSv);
                    }
                }
                Integer n = this.nextValueReference;
                Integer n2 = this.nextValueReference = Integer.valueOf(this.nextValueReference + 1);
            }
        }
    }

    public void calculateOutputs(Map<ModelConnection.ModelInstance, List<Fmi2ModelDescription.ScalarVariable>> envOutputs) {
        this.calculateScalarVariable(envOutputs, IOTYPE.OUTPUT);
    }
}

