/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.controllers;

import java.io.IOException;
import java.util.UUID;
import org.apache.commons.lang3.NotImplementedException;
import org.intocps.maestro.webapi.controllers.SimulatorNotFoundException;
import org.intocps.maestro.webapi.controllers.VndErrors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;

@ControllerAdvice(value={"org.intocps.maestro.webapi"})
@Order
@RequestMapping(produces={"application/vnd.error+json"})
public class ControllerAdvisor {
    static final Logger logger = LoggerFactory.getLogger(ControllerAdvisor.class);

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseEntity<VndErrors> missingRequestParameterException(MissingServletRequestParameterException e) {
        String guid = UUID.randomUUID().toString();
        logger.error("API ref: " + guid, (Throwable)e);
        return this.error((Exception)e, HttpStatus.BAD_REQUEST, e.getMessage());
    }

    private ResponseEntity<VndErrors> error(Exception exception, HttpStatus httpStatus, String logRef) {
        String message = exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName();
        return new ResponseEntity((Object)new VndErrors(logRef, message), httpStatus);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<VndErrors> assertionException(IllegalArgumentException e) {
        logger.debug("API Exception: {}", (Object)e.getMessage());
        return this.error((Exception)e, HttpStatus.NOT_FOUND, e.getLocalizedMessage());
    }

    @ExceptionHandler(value={SimulatorNotFoundException.class})
    public ResponseEntity<VndErrors> simulatorNotFoundException(Exception e) {
        String guid = UUID.randomUUID().toString();
        logger.error("Internal API Exception ref: " + guid, (Throwable)e);
        return this.error(e, HttpStatus.NOT_FOUND, guid);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<VndErrors> runtimeExceptionException(Exception e) {
        String guid = UUID.randomUUID().toString();
        logger.error("Internal API Exception ref: " + guid, (Throwable)e);
        return this.error(e, HttpStatus.INTERNAL_SERVER_ERROR, guid);
    }

    @ExceptionHandler(value={IOException.class})
    public ResponseEntity<VndErrors> runtimeExceptionException(IOException e) {
        String guid = UUID.randomUUID().toString();
        logger.error("Internal API Exception ref: " + guid, (Throwable)e);
        return this.error((Exception)e, HttpStatus.INTERNAL_SERVER_ERROR, guid);
    }

    @ExceptionHandler(value={UnsupportedOperationException.class})
    public ResponseEntity<VndErrors> unsupportedOperationExceptionException(Exception e) {
        String guid = UUID.randomUUID().toString();
        logger.error("Internal API Exception ref: " + guid, (Throwable)e);
        return this.error(e, HttpStatus.UNPROCESSABLE_ENTITY, guid);
    }

    @ExceptionHandler(value={BeanCreationException.class})
    public ResponseEntity<VndErrors> beanCreationException(BeanCreationException e) {
        String guid = UUID.randomUUID().toString();
        logger.error("Internal API BeanCreationException ref: " + guid, (Throwable)e);
        return this.error((Exception)e, HttpStatus.INTERNAL_SERVER_ERROR, guid);
    }

    @ExceptionHandler(value={NotImplementedException.class})
    public ResponseEntity<VndErrors> notImplementedException(NotImplementedException e) {
        String guid = UUID.randomUUID().toString();
        logger.error("Internal API Exception ref: " + guid, (Throwable)e);
        return this.error((Exception)e, HttpStatus.BAD_REQUEST, guid);
    }
}

