/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.controllers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class VndErrors
implements Iterable<VndError> {
    private final List<VndError> vndErrors;

    public VndErrors(String logref, String message) {
        this(new VndError(logref, message), new VndError[0]);
    }

    public VndErrors(VndError error, VndError ... errors) {
        this.vndErrors = new ArrayList<VndError>(errors.length + 1);
        this.vndErrors.add(error);
        this.vndErrors.addAll(Arrays.asList(errors));
    }

    @JsonCreator
    public VndErrors(List<VndError> errors) {
        this.vndErrors = errors;
    }

    protected VndErrors() {
        this.vndErrors = new ArrayList<VndError>();
    }

    public VndErrors add(VndError error) {
        this.vndErrors.add(error);
        return this;
    }

    @JsonValue
    private List<VndError> getErrors() {
        return this.vndErrors;
    }

    @Override
    public Iterator<VndError> iterator() {
        return this.vndErrors.iterator();
    }

    public int hashCode() {
        return this.vndErrors.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VndErrors)) {
            return false;
        }
        VndErrors that = (VndErrors)obj;
        return this.vndErrors.equals(that.vndErrors);
    }

    public String toString() {
        return String.format("VndErrors[%s]", this.vndErrors.stream().map(Object::toString).collect(Collectors.joining(",")));
    }

    public static class VndError {
        @JsonProperty
        private final String logref;
        @JsonProperty
        private final String message;

        public VndError(String logref, String message) {
            this.logref = logref;
            this.message = message;
        }

        public VndError() {
            this.logref = null;
            this.message = null;
        }

        public String getLogref() {
            return this.logref;
        }

        public String getMessage() {
            return this.message;
        }

        public int hashCode() {
            int result = 17;
            result += 31 * this.logref.hashCode();
            return result += 31 * this.message.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof VndError)) {
                return false;
            }
            VndError that = (VndError)obj;
            return this.message.equals(that.message);
        }

        public String toString() {
            return String.format("VndError[logref: %s, message: %s]", this.logref, this.message);
        }
    }
}

