/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.intocps.fmi.IFmu;
import org.intocps.maestro.cli.MablCmdVersionProvider;
import org.intocps.maestro.core.dto.FixedStepAlgorithmConfig;
import org.intocps.maestro.core.dto.MultiModel;
import org.intocps.maestro.core.dto.VariableStepAlgorithmConfig;
import org.intocps.maestro.core.messages.ErrorReporter;
import org.intocps.maestro.core.messages.MableError;
import org.intocps.maestro.core.messages.MableWarning;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.framework.fmi2.FmuFactory;
import org.intocps.maestro.webapi.Application;
import org.intocps.maestro.webapi.controllers.JavaProcess;
import org.intocps.maestro.webapi.controllers.ProdSessionLogicFactory;
import org.intocps.maestro.webapi.controllers.SessionController;
import org.intocps.maestro.webapi.controllers.SessionLogic;
import org.intocps.maestro.webapi.maestro2.Maestro2Broker;
import org.intocps.maestro.webapi.maestro2.dto.BaseSimulateRequestBody;
import org.intocps.maestro.webapi.maestro2.dto.CliExecutionRequestBody;
import org.intocps.maestro.webapi.maestro2.dto.InitializationData;
import org.intocps.maestro.webapi.maestro2.dto.InitializeStatusModel;
import org.intocps.maestro.webapi.maestro2.dto.SigverSimulateRequestBody;
import org.intocps.maestro.webapi.maestro2.dto.SimulateRequestBody;
import org.intocps.maestro.webapi.maestro2.dto.StatusModel;
import org.intocps.maestro.webapi.util.ZipDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@Component
public class Maestro2SimulationController {
    public static final SessionController sessionController = new SessionController(new ProdSessionLogicFactory());
    static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(Maestro2SimulationController.class);

    public void overrideRootLoggerLogLevel(Level level) {
        if (level == null) {
            return;
        }
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        loggerConfig.setLevel(level);
        ctx.updateLoggers();
    }

    @RequestMapping(value={"/upload/{sessionId}"}, method={RequestMethod.POST})
    public void uploadFile(@PathVariable String sessionId, @ApiParam(value="File", required=true) @RequestParam(value="file") MultipartFile file) throws IOException {
        try (InputStream is = file.getInputStream();){
            logger.debug("Uploaded file: {}", (Object)file.getOriginalFilename());
            File targetFile = new File(sessionController.getSessionLogic(sessionId).getRootDirectory(), file.getOriginalFilename());
            IOUtils.copy((InputStream)is, (OutputStream)new FileOutputStream(targetFile));
        }
    }

    @RequestMapping(value={"/ping"}, method={RequestMethod.GET}, produces={"text/plain"})
    public String ping() {
        return "OK";
    }

    @RequestMapping(value={"/status/{sessionId}"}, method={RequestMethod.GET}, produces={"text/plain"})
    public String getStatuses(@PathVariable String sessionId) throws Exception {
        return new ObjectMapper().writeValueAsString((Object)sessionController.getStatus(sessionId));
    }

    @RequestMapping(value={"/status"}, method={RequestMethod.GET}, produces={"text/plain"})
    public String getStatuses() throws JsonProcessingException {
        return new ObjectMapper().writeValueAsString(sessionController.getStatus());
    }

    private StatusModel getStatus(String sessionId) {
        if (sessionController.containsSession(sessionId)) {
            return new StatusModel("Session exists", sessionId, 0L);
        }
        return new StatusModel("Session does not exist", sessionId, 0L);
    }

    @RequestMapping(value={"/createSession"}, method={RequestMethod.GET}, produces={"application/json"})
    public StatusModel createSession() {
        String session = sessionController.createNewSession();
        return this.getStatus(session);
    }

    @RequestMapping(value={"/initialize/{sessionId}"}, method={RequestMethod.POST}, consumes={"text/plain", "application/json"}, produces={"application/json"})
    public InitializeStatusModel initializeSession(@PathVariable String sessionId, @RequestBody InitializationData body) throws Exception {
        FixedStepAlgorithmConfig algorithm;
        logger.debug("Got initial data");
        SessionLogic logic = sessionController.getSessionLogic(sessionId);
        ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.writeValue(new File(logic.rootDirectory, "initialize.json"), (Object)body);
        if (body == null) {
            throw new Exception("Could not parse configuration: ");
        }
        if (body.getOverrideLogLevel() != null) {
            this.overrideRootLoggerLogLevel(this.convertLogLevel(body.getOverrideLogLevel()));
        }
        if (body.getFmus() == null) {
            throw new Exception("FMUs must not be null");
        }
        if (body.getConnections() == null) {
            throw new Exception("Connections must not be null");
        }
        if (body.getAlgorithm() instanceof FixedStepAlgorithmConfig) {
            algorithm = (FixedStepAlgorithmConfig)body.getAlgorithm();
            if (algorithm.size == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "fixed-step size must be an integer or double");
            }
            logger.info("Using Fixed-step size calculator with size = {}", (Object)algorithm.size);
        } else if (body.getAlgorithm() instanceof VariableStepAlgorithmConfig) {
            algorithm = (VariableStepAlgorithmConfig)body.getAlgorithm();
            if (algorithm.getSize() == null) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "min and max variable-step size must be integers or doubles");
            }
            if (algorithm.getSize()[0] <= 0.0) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "the minimum variable-step size does not conform to the minimum step-size of FMI2");
            }
            if (algorithm.getSize()[1] <= 0.0) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "the maximum variable-step size does not conform to the minimum step-size of FMI2");
            }
            logger.info("Using variable-step size calculator with minimum step-size: {}, maximum step-size: {} and initial step-size: {}", new Object[]{algorithm.getSize()[0], algorithm.getSize()[1], algorithm.getInitsize()});
        }
        if (body.isParallelSimulation()) {
            throw new NotImplementedException("ParallelSimulation is not implemented");
        }
        if (body.isHasExternalSignals()) {
            throw new NotImplementedException("HasExternalSignals is not implemented");
        }
        logger.trace("Initialization completed");
        logic.setInitializationData(body);
        logic.setStatus(SessionLogic.SessionStatus.Initialized);
        HashMap<String, List<InitializeStatusModel.LogLevelModel>> logcategoryKeyToLogCategories = new HashMap<String, List<InitializeStatusModel.LogLevelModel>>();
        try {
            for (Map.Entry fmuKeyToFmuURI : body.getFmus().entrySet()) {
                IFmu iFmu = FmuFactory.create((File)logic.rootDirectory, (URI)URI.create((String)fmuKeyToFmuURI.getValue()));
                Fmi2ModelDescription fmi2ModelDescription = new Fmi2ModelDescription(iFmu.getModelDescription());
                try {
                    List logCategories = fmi2ModelDescription.getLogCategories();
                    logcategoryKeyToLogCategories.put((String)fmuKeyToFmuURI.getKey(), logCategories.stream().map(x -> new InitializeStatusModel.LogLevelModel(x.getName(), x.getDescription())).collect(Collectors.toList()));
                }
                catch (NullPointerException e) {
                    logger.trace("No log categories found for FMU: " + (String)fmuKeyToFmuURI.getKey());
                }
            }
        }
        catch (Exception e) {
            logger.info("Could not retrieve logging levels for one or more FMUs.");
        }
        return new InitializeStatusModel("initialized", sessionId, logcategoryKeyToLogCategories, 0L);
    }

    @ApiOperation(value="This request executes the algorithm provided in the master model")
    @RequestMapping(value={"/sigverSimulate/{sessionId}"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public StatusModel sigverSimulate(@PathVariable String sessionId, @RequestBody SigverSimulateRequestBody body) throws Exception {
        SessionLogic logic = sessionController.getSessionLogic(sessionId);
        return this.runSimulation(broker -> broker.buildAndRunMasterModel(logic.getInitializationData().getLivestream(), logic.getSocket(), logic.getInitializationData(), body, new File(logic.rootDirectory, "outputs.csv")), logic, body, sessionId);
    }

    @ApiOperation(value="This request begins the co-simulation")
    @RequestMapping(value={"/simulate/{sessionId}"}, method={RequestMethod.POST}, consumes={"text/plain", "application/json"}, produces={"application/json"})
    public StatusModel simulate(@PathVariable String sessionId, @RequestBody SimulateRequestBody body) throws Exception {
        SessionLogic logic = sessionController.getSessionLogic(sessionId);
        if (!logic.getCliExecution()) {
            return this.runSimulation(broker -> broker.buildAndRun(logic.getInitializationData(), body, logic.getSocket(), new File(logic.rootDirectory, "outputs.csv")), logic, body, sessionId);
        }
        mapper.writeValue(new File(logic.rootDirectory, "simulate.json"), (Object)body);
        logic.setStatus(SessionLogic.SessionStatus.Simulating);
        String simulateJsonPath = new File(logic.rootDirectory, "simulate.json").getAbsolutePath();
        String initializeJsonPath = new File(logic.rootDirectory, "initialize.json").getAbsolutePath();
        String dumpDirectory = logic.rootDirectory.getAbsolutePath();
        ArrayList<String> arguments = new ArrayList<String>(List.of("cliMain", "import", "-output", dumpDirectory, "--dump-intermediate", "sg1", initializeJsonPath, simulateJsonPath, "-i", "-v", "FMI2", "--fmu-search-path", sessionController.getSessionLogic(sessionId).getRootDirectory().getAbsolutePath()));
        ArrayList<String> error = new ArrayList<String>();
        ArrayList<String> out = new ArrayList<String>();
        List<String> command = JavaProcess.calculateCommand(Application.class, Arrays.asList(new String[0]), arguments);
        logger.info("Executing command: " + String.join((CharSequence)" ", command));
        long preSimTime = System.currentTimeMillis();
        Process p = Runtime.getRuntime().exec((String[])command.toArray(String[]::new));
        Scanner outputStreamSc = new Scanner(p.getInputStream());
        Scanner errorStream = new Scanner(p.getErrorStream());
        while (outputStreamSc.hasNextLine() || errorStream.hasNext()) {
            if (outputStreamSc.hasNextLine()) {
                String outLine = outputStreamSc.nextLine();
                out.add(outLine);
                System.out.println(outLine);
            }
            if (!errorStream.hasNext()) continue;
            String line = errorStream.nextLine();
            error.add(line);
            System.out.println(line);
        }
        int result = p.waitFor();
        if (error.size() > 0) {
            logic.setStatus(SessionLogic.SessionStatus.Error);
        } else {
            logic.setStatus(SessionLogic.SessionStatus.Finished);
        }
        long postSimTime = System.currentTimeMillis();
        logic.setExecTime(postSimTime - preSimTime);
        return new StatusModel(result + " - Simulation completed", sessionId, 0L, error, out);
    }

    @RequestMapping(value={"/stopsimulation/{sessionId}"}, method={RequestMethod.POST, RequestMethod.GET})
    public void stop(@PathVariable String sessionId) {
        SessionLogic sessionLogic = sessionController.getSessionLogic(sessionId);
        if (sessionLogic != null) {
            sessionLogic.setStopRequested(true);
        }
    }

    @RequestMapping(value={"/result/{sessionId}/plain"}, method={RequestMethod.GET}, produces={"text/csv"})
    public ResponseEntity<Resource> getResultPlain(@PathVariable String sessionId) throws Exception {
        SessionLogic sessionLogic = sessionController.getSessionLogic(sessionId);
        if (sessionLogic == null) {
            throw new IllegalArgumentException("The session with id: " + sessionId + " does not exist.");
        }
        ByteArrayResource resource = new ByteArrayResource(FileUtils.readFileToByteArray((File)new File(sessionLogic.rootDirectory, "outputs.csv")));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.TEXT_PLAIN).header("Content-Disposition", new String[]{"attachment; filename=\"outputs.csv\""})).body((Object)resource);
    }

    @RequestMapping(value={"/result/{sessionId}/zip"}, method={RequestMethod.GET}, produces={"application/zip"})
    public void getResultZip(@PathVariable String sessionId, HttpServletResponse response) throws Exception {
        SessionLogic sessionLogic = sessionController.getSessionLogic(sessionId);
        if (sessionLogic == null) {
            throw new IllegalArgumentException("The session with id: " + sessionId + " does not exist.");
        }
        response.setStatus(200);
        response.addHeader("Content-Disposition", "attachment; filename=\"results.zip\"");
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
        ZipDirectory.addDir(sessionLogic.rootDirectory, sessionLogic.rootDirectory, zipOutputStream);
        zipOutputStream.close();
    }

    @RequestMapping(value={"/destroy/{sessionId}"}, method={RequestMethod.GET})
    public void destroy(@PathVariable String sessionId) throws Exception {
        sessionController.deleteSession(sessionId);
    }

    @RequestMapping(value={"/version"}, method={RequestMethod.GET}, produces={"text/plain"})
    public String version() {
        String message;
        try {
            message = "{\"version\":\"" + new MablCmdVersionProvider().getVersion()[0] + "\"}";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "unknown";
        }
        return message;
    }

    @RequestMapping(value={"/executeViaCLI/{sessionId}"}, method={RequestMethod.POST})
    public void executeViaCLI(@PathVariable String sessionId, @RequestBody CliExecutionRequestBody cliExecutionRequestBody) {
        sessionController.getSessionLogic(sessionId).setCliExecution(cliExecutionRequestBody.executeViaCLI);
    }

    private Level convertLogLevel(MultiModel.InitializeLogLevel overrideLogLevel) {
        switch (overrideLogLevel) {
            case OFF: {
                return Level.OFF;
            }
            case FATAL: {
                return Level.FATAL;
            }
            case ERROR: {
                return Level.ERROR;
            }
            case WARN: {
                return Level.WARN;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case TRACE: {
                return Level.TRACE;
            }
            case ALL: {
                return Level.ALL;
            }
        }
        return null;
    }

    private StatusModel runSimulation(IBuildAndRun func, SessionLogic logic, BaseSimulateRequestBody body, String sessionId) throws Exception {
        mapper.writeValue(new File(logic.rootDirectory, "simulate.json"), (Object)body);
        ErrorReporter reporter = new ErrorReporter();
        logic.setStatus(SessionLogic.SessionStatus.Simulating);
        logic.setStopRequested(false);
        long preSimTime = System.currentTimeMillis();
        func.apply(new Maestro2Broker(logic.rootDirectory, reporter, () -> logic.isStopRequested()));
        long postSimTime = System.currentTimeMillis();
        logic.setExecTime(postSimTime - preSimTime);
        if (reporter.getErrorCount() > 0) {
            logic.setStatus(SessionLogic.SessionStatus.Error);
            reporter.getErrors().forEach(x -> logger.error(x.toString()));
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            reporter.printWarnings(writer);
            reporter.printErrors(writer);
            throw new Exception(out.toString());
        }
        reporter.getWarnings().forEach(x -> logger.warn(x.toString()));
        logic.setStatus(SessionLogic.SessionStatus.Finished);
        return new StatusModel("Simulation completed", sessionId, 0L, reporter.getErrors().stream().map(MableError::toString).collect(Collectors.toList()), reporter.getWarnings().stream().map(MableWarning::toString).collect(Collectors.toList()));
    }

    @FunctionalInterface
    private static interface IBuildAndRun {
        public void apply(Maestro2Broker var1) throws Exception;
    }
}

