/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro2.interpreter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.intocps.maestro.webapi.maestro2.interpreter.WebsocketValueConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class WebsocketValueConverter {
    static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(WebsocketValueConverter.class);
    final WebSocketSession ws;
    Dto data = new Dto(this);
    List<String> names = new ArrayList();

    public WebsocketValueConverter(WebSocketSession ws) {
        this.ws = ws;
    }

    public void configure(List<String> names) {
        this.names = names;
    }

    public void update(double time, List<Object> updates) {
        this.data.time = time;
        for (int i = 0; i < updates.size(); ++i) {
            String[] name = ((String)this.names.get(i)).split("\\.");
            Map dataMap = this.data.data;
            for (int segement = 0; segement < name.length; ++segement) {
                String s = name[segement];
                if (segement == name.length - 1) {
                    dataMap.put(s, updates.get(i));
                    continue;
                }
                dataMap = (Map)dataMap.computeIfAbsent(s, k -> new HashMap());
            }
        }
    }

    public void send() {
        try {
            String json = this.getJson();
            logger.info("Sending: {}", (Object)json);
            this.ws.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getJson() throws JsonProcessingException {
        return mapper.writeValueAsString((Object)this.data);
    }
}

