/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.controllers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.intocps.maestro.webapi.controllers.SessionLogic;
import org.intocps.maestro.webapi.controllers.SessionLogicFactory;
import org.intocps.maestro.webapi.maestro2.dto.StatusModel;
import org.intocps.maestro.webapi.util.Files;
import org.springframework.web.socket.WebSocketSession;

public class SessionController {
    public static boolean test = false;
    private final Map<String, SessionLogic> maestroInstanceMap = new HashMap();
    private final SessionLogicFactory sessionLogicFactory;

    public SessionController(SessionLogicFactory sessionLogicFactory) {
        this.sessionLogicFactory = sessionLogicFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createNewSession() {
        String session = UUID.randomUUID().toString();
        Map map = this.maestroInstanceMap;
        synchronized (map) {
            this.maestroInstanceMap.put(session, this.sessionLogicFactory.createSessionLogic(this.getSessionRootDir(session)));
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionLogic getSessionLogic(String sessionID) {
        Map map = this.maestroInstanceMap;
        synchronized (map) {
            return (SessionLogic)this.maestroInstanceMap.get(sessionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsSession(String sessionId) {
        Map map = this.maestroInstanceMap;
        synchronized (map) {
            return this.maestroInstanceMap.containsKey(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionLogic removeSession(String sessionId) {
        Map map = this.maestroInstanceMap;
        synchronized (map) {
            return (SessionLogic)this.maestroInstanceMap.remove(sessionId);
        }
    }

    public List<StatusModel> getStatus() {
        return this.maestroInstanceMap.entrySet().stream().map(entry -> new StatusModel("" + ((SessionLogic)entry.getValue()).getStatus(), (String)entry.getKey(), ((SessionLogic)entry.getValue()).getLastExecTime().longValue())).collect(Collectors.toCollection(Vector::new));
    }

    public StatusModel getStatus(String sessionId) throws Exception {
        return this.maestroInstanceMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(sessionId)).findFirst().map(kv -> new StatusModel("" + ((SessionLogic)kv.getValue()).getStatus(), (String)kv.getKey(), ((SessionLogic)kv.getValue()).getLastExecTime().longValue())).orElseThrow(() -> new Exception("No such session id."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSession(String sessionId) throws IOException {
        Map map = this.maestroInstanceMap;
        synchronized (map) {
            FileUtils.deleteDirectory((File)((SessionLogic)this.maestroInstanceMap.get((Object)sessionId)).rootDirectory);
        }
        this.removeSession(sessionId);
    }

    public File getSessionRootDir(String session) {
        if (test) {
            return new File(new File("target"), session);
        }
        return new File(Files.createTempDir(), session);
    }

    public void removeSocket(String sessionId) {
        this.getSessionLogic(sessionId).removeSocket();
    }

    public boolean containsSocket(String sessionId) {
        return this.getSessionLogic(sessionId).containsSocket();
    }

    public void addSocket(String sessionId, WebSocketSession socket) {
        this.getSessionLogic(sessionId).setWebsocketSession(socket);
    }
}

