/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.cli.CommandLine;
import org.intocps.maestro.MaestroV1CliProxy;
import org.intocps.maestro.Main;
import org.intocps.maestro.core.messages.ErrorReporter;
import org.intocps.maestro.webapi.maestro2.Maestro2Broker;
import org.intocps.maestro.webapi.maestro2.dto.InitializationData;
import org.intocps.maestro.webapi.maestro2.dto.SimulateRequestBody;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.context.ServletWebServerInitializedEvent;
import org.springframework.context.event.EventListener;

@SpringBootApplication
public class Application {
    static final ObjectMapper mapper = new ObjectMapper();
    private static boolean serverAcquiresPort = false;

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("cliMain")) {
            Main.argumentHandler((String[])((String[])Arrays.stream(args).skip(1L).toArray(String[]::new)));
        } else {
            CommandLine cmd = MaestroV1CliProxy.parse((String[])args);
            if (!MaestroV1CliProxy.process((CommandLine)cmd, (MaestroV1CliProxy.OneShotRunner)new MableV1ToV2ProxyRunner(), port -> {
                serverAcquiresPort = port == 0;
                SpringApplication app = new SpringApplication(new Class[]{Application.class});
                app.run(new String[]{"--server.port=" + port});
            })) {
                System.exit(1);
            }
        }
    }

    @EventListener
    public void onApplicationEvent(ServletWebServerInitializedEvent event) {
        if (serverAcquiresPort) {
            int port = event.getWebServer().getPort();
            System.err.println("Server acquired port: {" + port + "}");
        }
    }

    static class MableV1ToV2ProxyRunner
    implements MaestroV1CliProxy.OneShotRunner {
        MableV1ToV2ProxyRunner() {
        }

        public boolean run(boolean verbose, File configFile, File simulationConfigFile, Double startTime, Double endTime, File outputFile) throws IOException {
            InitializationData initializationData = (InitializationData)((Object)mapper.readValue(configFile, InitializationData.class));
            SimulateRequestBody simulationData = null;
            simulationData = simulationConfigFile != null && simulationConfigFile.exists() ? (SimulateRequestBody)mapper.readValue(simulationConfigFile, SimulateRequestBody.class) : new SimulateRequestBody(startTime, endTime, new HashMap<String, List<String>>(), false, 0.0, "");
            Function<File, File> calculateWorkingDirectory = file -> {
                if (file == null) {
                    return new File(".");
                }
                if (file.isDirectory()) {
                    return file;
                }
                return file.getParentFile();
            };
            File workingDirectory = calculateWorkingDirectory.apply(outputFile);
            ErrorReporter reporter = new ErrorReporter();
            Maestro2Broker mc = new Maestro2Broker(workingDirectory, reporter, () -> false);
            mc.setVerbose(verbose);
            try {
                mc.buildAndRun(initializationData, simulationData, null, outputFile);
                return true;
            }
            catch (Exception e) {
                if (reporter.getErrorCount() > 0) {
                    reporter.printWarnings(new PrintWriter(System.err, true));
                    reporter.printErrors(new PrintWriter(System.err, true));
                }
                e.printStackTrace();
                return false;
            }
        }
    }
}

