/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro2;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.intocps.maestro.webapi.maestro2.Maestro2SimulationController;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class SocketHandler
extends TextWebSocketHandler {
    List<WebSocketSession> sessions = new CopyOnWriteArrayList<WebSocketSession>();

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        String sessionID = session.getUri().getRawPath().substring(session.getUri().getRawPath().lastIndexOf("/") + 1);
        Maestro2SimulationController.sessionController.addSocket(sessionID, session);
        this.sessions.add(session);
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) {
        String sessionID = session.getUri().getRawPath().substring(session.getUri().getRawPath().lastIndexOf("/") + 1);
        Maestro2SimulationController.sessionController.removeSocket(sessionID);
        this.sessions.remove(session);
    }
}

