/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro2.interpreter;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import org.intocps.maestro.interpreter.values.ArrayValue;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.ExternalModuleValue;
import org.intocps.maestro.interpreter.values.FunctionValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.StringValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.VoidValue;
import org.intocps.maestro.interpreter.values.csv.CsvFileValue;
import org.intocps.maestro.webapi.maestro2.interpreter.WebsocketValueConverter;
import org.springframework.web.socket.WebSocketSession;

class WebSocketSenderValue
extends ExternalModuleValue<WebsocketValueConverter> {
    public WebSocketSenderValue(WebSocketSession ws) {
        super(WebSocketSenderValue.createMembers(new WebsocketValueConverter(ws)), null);
    }

    private static Map<String, Value> createMembers(WebsocketValueConverter ws) {
        HashMap<String, Value> members = new HashMap<String, Value>();
        members.put("writeHeader", (Value)new FunctionValue.ExternalFunctionValue(fcargs -> {
            WebSocketSenderValue.checkArgLength((List)fcargs, (int)1);
            List headers = CsvFileValue.getArrayValue((Value)((Value)fcargs.get(0)), StringValue.class);
            ws.configure(headers.stream().map(StringValue::getValue).collect(Collectors.toList()));
            return new VoidValue();
        }));
        members.put("writeRow", (Value)new FunctionValue.ExternalFunctionValue(fcargs -> {
            WebSocketSenderValue.checkArgLength((List)fcargs, (int)2);
            double time = CsvFileValue.getDouble((Value)((Value)fcargs.get(0)));
            ArrayValue arrayValue = (ArrayValue)((Value)fcargs.get(1)).deref();
            Vector<Object> data = new Vector<Object>();
            for (Value d : arrayValue.getValues()) {
                if (d instanceof IntegerValue) {
                    data.add(((IntegerValue)d).intValue());
                }
                if (d instanceof RealValue) {
                    data.add(((RealValue)d).realValue());
                }
                if (!(d instanceof BooleanValue)) continue;
                data.add(Boolean.valueOf(((BooleanValue)d).getValue()).toString());
            }
            ws.update(time, data);
            ws.send();
            return new VoidValue();
        }));
        return members;
    }
}

