/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro2.interpreter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.intocps.maestro.interpreter.values.datawriter.DataListenerUtilities;
import org.intocps.maestro.interpreter.values.datawriter.WebSocketDataWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class WebsocketValueConverter {
    static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(WebsocketValueConverter.class);
    final WebSocketSession ws;
    final WebSocketDataWriter.JsonLiveStreamValueConverter converter = new WebSocketDataWriter.JsonLiveStreamValueConverter();

    public WebsocketValueConverter(WebSocketSession ws) {
        this.ws = ws;
    }

    public void configure(List<String> names) {
        this.configure(DataListenerUtilities.indicesToHeaders(names, null));
    }

    public void configure(Map<Integer, String> ith) {
        this.converter.configure(ith);
    }

    public void update(double time, List<Object> updates) {
        this.converter.update(time, updates);
    }

    public void send() {
        try {
            String json = this.converter.getJson();
            logger.info("Sending: {}", (Object)json);
            this.ws.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getJson() throws JsonProcessingException {
        return this.converter.getJson();
    }
}

