/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulationLauncher {
    public static final String SUN_JAVA_COMMAND = "sun.java.command";
    private static final Logger logger = LoggerFactory.getLogger(SimulationLauncher.class);

    public static Process restartApplication(File workingDirectory, String ... additionalArguments) throws IOException {
        try {
            String java = "java";
            ProcessBuilder pb = new ProcessBuilder(java);
            Stream.of(additionalArguments).forEach(c -> pb.command().add((String)c));
            if (workingDirectory != null) {
                if (!workingDirectory.mkdirs() && !workingDirectory.exists()) {
                    logger.warn("Working directory does not exist {}", (Object)workingDirectory);
                }
                logger.debug("Setting working directory to: '{}'", (Object)workingDirectory.getAbsoluteFile());
                pb.directory(workingDirectory.getAbsoluteFile());
            }
            List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String arg : vmArguments) {
                if (arg.contains("-agentlib") || arg.contains("-javaagent") || arg.contains("-Dserver.port=")) continue;
                pb.command().add(arg);
            }
            String[] mainCommand = System.getProperty(SUN_JAVA_COMMAND).split(" ");
            if (mainCommand[0].endsWith(".jar")) {
                pb.command().add("-jar");
                File jarFile = new File(mainCommand[0]);
                if (!jarFile.isAbsolute()) {
                    jarFile = jarFile.getAbsoluteFile();
                }
                pb.command().add(jarFile.getCanonicalPath());
            } else {
                pb.environment().put("CLASSPATH", System.getProperty("java.class.path"));
                pb.command().add(mainCommand[0]);
            }
            for (int i = 1; i < mainCommand.length; ++i) {
                pb.command().add(mainCommand[i]);
            }
            logger.debug(String.join((CharSequence)" ", pb.command()));
            return pb.inheritIO().start();
        }
        catch (Exception e) {
            throw new IOException("Error while trying to restart the application", e);
        }
    }
}

