/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro2.interpreter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Vector;
import org.intocps.maestro.interpreter.InterpreterException;
import org.intocps.maestro.interpreter.values.BooleanValue;
import org.intocps.maestro.interpreter.values.IntegerValue;
import org.intocps.maestro.interpreter.values.RealValue;
import org.intocps.maestro.interpreter.values.Value;
import org.intocps.maestro.interpreter.values.datawriter.DataListenerUtilities;
import org.intocps.maestro.interpreter.values.datawriter.IDataListener;
import org.intocps.maestro.webapi.maestro2.interpreter.WebsocketValueConverter;
import org.springframework.web.socket.WebSocketSession;

public class WebsocketDataWriter
implements IDataListener {
    final List<String> filter;
    final double interval;
    private final HashMap<UUID, WebsocketDataWriterInstance> instances = new HashMap();
    private final WebSocketSession webSocketSession;
    private final WebsocketValueConverter webSocketConverter;

    public WebsocketDataWriter(WebSocketSession ws, List<String> filter, double interval) {
        this.webSocketSession = ws;
        this.filter = filter;
        this.webSocketConverter = new WebsocketValueConverter(ws);
        this.interval = interval;
    }

    public void writeHeader(UUID uuid, List<String> headers) {
        Map ith = DataListenerUtilities.indicesToHeaders(headers, this.filter);
        ArrayList<Integer> ioi = new ArrayList<Integer>(ith.keySet());
        ArrayList<String> hoi = new ArrayList<String>(ith.values());
        WebsocketDataWriterInstance wdwi = new WebsocketDataWriterInstance(hoi, ioi);
        wdwi.interval = this.interval;
        this.instances.put(uuid, wdwi);
        this.webSocketConverter.configure(ith);
    }

    public void writeDataPoint(UUID uuid, double time, List<Value> dataPoint) {
        WebsocketDataWriterInstance instance = this.instances.get(uuid);
        if (instance.shallLog(time).booleanValue()) {
            instance.updateNextReportTime();
            Vector<Object> data = new Vector<Object>();
            for (Value d : dataPoint) {
                if (d instanceof IntegerValue) {
                    data.add(((IntegerValue)d).intValue());
                }
                if (d instanceof RealValue) {
                    data.add(((RealValue)d).realValue());
                }
                if (!(d instanceof BooleanValue)) continue;
                data.add("" + Boolean.valueOf(((BooleanValue)d).getValue()));
            }
            this.webSocketConverter.update(time, data);
            this.webSocketConverter.send();
        }
    }

    public void close() {
        try {
            this.webSocketSession.close();
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
    }

    static class WebsocketDataWriterInstance {
        public final List<Integer> indicesOfInterest;
        public final List<String> headersOfInterest;
        public double nextReportTime = 0.0;
        public Double interval = 0.1;

        WebsocketDataWriterInstance(List<String> headersOfInterest, List<Integer> indicesOfInterest) {
            this.headersOfInterest = headersOfInterest;
            this.indicesOfInterest = indicesOfInterest;
        }

        public Boolean shallLog(Double time) {
            return time >= this.nextReportTime;
        }

        public void updateNextReportTime() {
            this.nextReportTime += this.interval.doubleValue();
        }
    }
}

