/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.maestro2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.intocps.maestro.Mabl;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.display.PrettyPrinter;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.cli.ImportCmd;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.core.dto.MultiModel;
import org.intocps.maestro.core.messages.ErrorReporter;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.fmi2.ComponentInfo;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironmentConfiguration;
import org.intocps.maestro.interpreter.DefaultExternalValueFactory;
import org.intocps.maestro.interpreter.MableInterpreter;
import org.intocps.maestro.interpreter.api.IValueLifecycleHandler;
import org.intocps.maestro.plugin.IPluginConfiguration;
import org.intocps.maestro.plugin.JacobianStepConfig;
import org.intocps.maestro.plugin.MasterModelMapper;
import org.intocps.maestro.template.MaBLTemplateConfiguration;
import org.intocps.maestro.template.ScenarioConfiguration;
import org.intocps.maestro.typechecker.TypeChecker;
import org.intocps.maestro.webapi.maestro2.Maestro2Broker;
import org.intocps.maestro.webapi.maestro2.dto.InitializationData;
import org.intocps.maestro.webapi.maestro2.dto.SigverSimulateRequestBody;
import org.intocps.maestro.webapi.maestro2.dto.SimulateRequestBody;
import org.intocps.maestro.webapi.maestro2.interpreter.WebApiInterpreterFactory;
import org.intocps.verification.scenarioverifier.core.ScenarioLoaderFMI2;
import org.intocps.verification.scenarioverifier.core.masterModel.MasterModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.socket.WebSocketSession;

public class Maestro2Broker {
    private static final Logger logger = LoggerFactory.getLogger(Maestro2Broker.class);
    final Mabl mabl;
    final File workingDirectory;
    final ErrorReporter reporter;
    private final Supplier<Boolean> isStopRequsted;
    private final Function<Map<String, List<String>>, List<String>> flattenFmuIds = map -> map.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(v -> (String)entry.getKey() + "." + v)).collect(Collectors.toList());
    private Map.Entry<Boolean, Map<INode, PType>> typeCheckResult;

    public Maestro2Broker(File workingDirectory, ErrorReporter reporter, Supplier<Boolean> isStopRequsted) {
        this.workingDirectory = workingDirectory;
        this.isStopRequsted = isStopRequsted;
        Mabl.MableSettings mableSettings = new Mabl.MableSettings();
        mableSettings.dumpIntermediateSpecs = false;
        mableSettings.inlineFrameworkConfig = true;
        this.mabl = new Mabl(workingDirectory, null, mableSettings);
        this.reporter = reporter;
        this.mabl.setReporter((IErrorReporter)this.reporter);
    }

    public <T extends MultiModel> void buildAndRunMasterModel(Map<String, List<String>> livestreamVariables, WebSocketSession socket, T multiModel, SigverSimulateRequestBody body, File csvOutputFile) throws Exception {
        MasterModel masterModel = ScenarioLoaderFMI2.load((InputStream)new ByteArrayInputStream(body.getMasterModel().getBytes()));
        Fmi2SimulationEnvironmentConfiguration simulationConfiguration = new Fmi2SimulationEnvironmentConfiguration((Map)MasterModelMapper.Companion.masterModelConnectionsToMultiModelConnections(masterModel), multiModel.getFmus());
        simulationConfiguration.variablesToLog = multiModel.getLogVariables();
        if (simulationConfiguration.variablesToLog == null) {
            simulationConfiguration.variablesToLog = new HashMap();
        }
        Fmi2SimulationEnvironment simulationEnvironment = Fmi2SimulationEnvironment.of((Fmi2SimulationEnvironmentConfiguration)simulationConfiguration, (IErrorReporter)this.reporter);
        ScenarioConfiguration configuration = new ScenarioConfiguration(simulationEnvironment, masterModel, multiModel.getParameters(), Double.valueOf(multiModel.getGlobal_relative_tolerance()), Double.valueOf(multiModel.getGlobal_absolute_tolerance()), Integer.valueOf(multiModel.getConvergenceAttempts()), Double.valueOf(body.getStartTime()), Double.valueOf(body.getEndTime()), Double.valueOf(multiModel.getAlgorithm().getStepSize()), Pair.of((Object)Framework.FMI2, (Object)simulationConfiguration), Boolean.valueOf(multiModel.isLoggingOn()), multiModel.getLogLevels());
        String runtimeJsonConfigString = this.generateSpecification(configuration, null);
        this.typeCheckResult = this.mabl.typeCheck();
        if (!((Boolean)this.typeCheckResult.getKey()).booleanValue()) {
            throw new Exception("Specification did not type check");
        }
        if (!this.mabl.verify(Framework.FMI2)) {
            throw new Exception("Specification did not verify");
        }
        List portsToLog = Stream.concat(simulationEnvironment.getConnectedOutputs().stream().map(x -> {
            ComponentInfo i = (ComponentInfo)simulationEnvironment.getUnitInfo(new LexIdentifier(x.instance.getText(), null), Framework.FMI2);
            return String.format("%s.%s.%s", i.fmuIdentifier, x.instance.getText(), x.getName());
        }), multiModel.getLogVariables() == null ? Stream.of(new String[0]) : multiModel.getLogVariables().entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(v -> (String)entry.getKey() + "." + v))).collect(Collectors.toList());
        List liveStreamFilter = livestreamVariables == null ? List.of() : (List)this.flattenFmuIds.apply(livestreamVariables);
        this.executeInterpreter(socket, portsToLog, liveStreamFilter, body.getLiveLogInterval().doubleValue(), csvOutputFile, (InputStream)new ByteArrayInputStream(runtimeJsonConfigString.getBytes()));
    }

    public void buildAndRun(InitializationData initializeRequest, SimulateRequestBody body, WebSocketSession socket, File csvOutputFile) throws Exception {
        ImportCmd.resolveFmuPaths(Collections.singletonList(this.workingDirectory), (Map)initializeRequest.getFmus());
        Fmi2SimulationEnvironmentConfiguration simulationConfiguration = new Fmi2SimulationEnvironmentConfiguration(initializeRequest.getConnections(), initializeRequest.getFmus());
        simulationConfiguration.variablesToLog = initializeRequest.getLogVariables();
        if (simulationConfiguration.variablesToLog == null) {
            simulationConfiguration.variablesToLog = new HashMap();
        }
        simulationConfiguration.livestream = initializeRequest.getLivestream();
        simulationConfiguration.faultInjectInstances = initializeRequest.faultInjectInstances;
        simulationConfiguration.faultInjectConfigurationPath = initializeRequest.faultInjectConfigurationPath;
        HashMap<String, Object> initialize = new HashMap<String, Object>();
        Map parameters = initializeRequest.getParameters();
        if (parameters != null) {
            initialize.put("parameters", parameters);
        }
        if (initializeRequest.getEnvironmentParameters() != null) {
            initialize.put("environmentParameters", initializeRequest.getEnvironmentParameters());
        }
        Fmi2SimulationEnvironment simulationEnvironment = Fmi2SimulationEnvironment.of((Fmi2SimulationEnvironmentConfiguration)simulationConfiguration, (IErrorReporter)this.reporter);
        HashMap removedFMUKeyFromLogLevels = body.getLogLevels() == null ? new HashMap() : body.getLogLevels().entrySet().stream().collect(Collectors.toMap(entry -> MaBLTemplateConfiguration.MaBLTemplateConfigurationBuilder.getFmuInstanceFromFmuKeyInstance((String)((String)entry.getKey())), Map.Entry::getValue));
        JacobianStepConfig config = new JacobianStepConfig();
        config.stabilisation = initializeRequest.isStabalizationEnabled();
        config.absoluteTolerance = initializeRequest.getGlobal_absolute_tolerance();
        config.relativeTolerance = initializeRequest.getGlobal_relative_tolerance();
        config.stabilisationLoopMaxIterations = 5;
        config.simulationProgramDelay = initializeRequest.isSimulationProgramDelay();
        config.stepAlgorithm = initializeRequest.getAlgorithm();
        config.startTime = body.getStartTime();
        config.endTime = body.getEndTime();
        MaBLTemplateConfiguration.MaBLTemplateConfigurationBuilder builder = MaBLTemplateConfiguration.MaBLTemplateConfigurationBuilder.getBuilder().setFrameworkConfig(Framework.FMI2, simulationConfiguration).useInitializer(true, new ObjectMapper().writeValueAsString(initialize)).setFramework(Framework.FMI2).setLogLevels(removedFMUKeyFromLogLevels).setVisible(initializeRequest.isVisible()).setLoggingOn(initializeRequest.isLoggingOn()).setStepAlgorithmConfig((IPluginConfiguration)config);
        MaBLTemplateConfiguration configuration = builder.build();
        AtomicBoolean didLocateFaultInjectionFile = new AtomicBoolean(false);
        if (initializeRequest.getExternalSpecs() != null) {
            ArrayList filesNotResolved = new ArrayList();
            List nonMablFiles = initializeRequest.getExternalSpecs().stream().filter(file -> {
                if (!file.exists()) {
                    filesNotResolved.add(file);
                }
                if (file.getName().toLowerCase().endsWith("faultinject.mabl")) {
                    didLocateFaultInjectionFile.set(true);
                }
                return !file.getName().toLowerCase(Locale.ROOT).endsWith(".mabl");
            }).collect(Collectors.toList());
            Object errMsg = "";
            if (filesNotResolved.size() > 0) {
                errMsg = "Cannot resolve path to spec files: " + nonMablFiles.stream().map(File::getName).reduce("", (prev, cur) -> prev + " " + cur);
            } else if (nonMablFiles.size() > 0) {
                errMsg = "Cannot load spec files: " + nonMablFiles.stream().map(File::getName).reduce("", (prev, cur) -> prev + " " + cur) + ". Only mabl files should be included as external specs.";
            }
            if (!((String)errMsg).equals("")) {
                throw new Exception((String)errMsg);
            }
            this.mabl.parse(initializeRequest.getExternalSpecs());
        }
        if (initializeRequest.faultInjectConfigurationPath != null && !initializeRequest.faultInjectConfigurationPath.equals("") && !didLocateFaultInjectionFile.get()) {
            throw new Exception("Remember to include FaultInject.mabl as an external spec");
        }
        String runtimeJsonConfigString = this.generateSpecification(configuration, parameters);
        if (!((Boolean)this.mabl.typeCheck().getKey()).booleanValue()) {
            throw new Exception("Specification did not type check");
        }
        if (!this.mabl.verify(Framework.FMI2)) {
            throw new Exception("Specification did not verify");
        }
        List connectedOutputs = simulationEnvironment.getConnectedOutputs().stream().map(x -> {
            ComponentInfo i = (ComponentInfo)simulationEnvironment.getUnitInfo(new LexIdentifier(x.instance.getText(), null), Framework.FMI2);
            return String.format("%s.%s.%s", i.fmuIdentifier, x.instance.getText(), x.getName());
        }).collect(Collectors.toList());
        this.executeInterpreter(socket, Stream.concat(connectedOutputs.stream(), (initializeRequest.getLogVariables() == null ? new Vector() : (List)this.flattenFmuIds.apply(initializeRequest.getLogVariables())).stream()).collect(Collectors.toList()), initializeRequest.getLivestream() == null ? new Vector() : (List)this.flattenFmuIds.apply(initializeRequest.getLivestream()), body.getLiveLogInterval() == null ? 0.0 : body.getLiveLogInterval(), csvOutputFile, (InputStream)new ByteArrayInputStream(runtimeJsonConfigString.getBytes()));
    }

    public String generateSpecification(ScenarioConfiguration config, Map<String, Object> parameters) throws Exception {
        this.mabl.generateSpec(config);
        return this.postGenerate(parameters);
    }

    public String generateSpecification(MaBLTemplateConfiguration config, Map<String, Object> parameters) throws Exception {
        this.mabl.generateSpec(config);
        return this.postGenerate(parameters);
    }

    private String postGenerate(Map<String, Object> parameters) throws Exception {
        this.mabl.expand();
        this.mabl.setRuntimeEnvironmentVariables(parameters);
        this.mabl.dump(this.workingDirectory);
        logger.debug(PrettyPrinter.printLineNumbers((INode)this.mabl.getMainSimulationUnit()));
        return new ObjectMapper().writeValueAsString(this.mabl.getRuntimeData());
    }

    public void executeInterpreter(WebSocketSession webSocket, List<String> csvFilter, List<String> webSocketFilter, double interval, File csvOutputFile, InputStream config) throws IOException, AnalysisException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        WebApiInterpreterFactory factory = webSocket != null ? new WebApiInterpreterFactory(this.workingDirectory, webSocket, interval, webSocketFilter, new File(this.workingDirectory, "outputs.csv"), csvFilter, name -> TypeChecker.findModule((Map)((Map)this.typeCheckResult.getValue()), (String)name), config) : new WebApiInterpreterFactory(this.workingDirectory, csvOutputFile, csvFilter, name -> TypeChecker.findModule((Map)((Map)this.typeCheckResult.getValue()), (String)name), config);
        factory.addLifecycleHandler((IValueLifecycleHandler)new WebSimulationControlDefaultLifecycleHandler(this));
        new MableInterpreter((DefaultExternalValueFactory)factory).execute(this.mabl.getMainSimulationUnit());
    }

    public void setVerbose(boolean verbose) {
        this.mabl.setVerbose(verbose);
    }
}

