/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.webapi.services;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.intocps.maestro.webapi.SimulationLauncher;

public class SimulatorManagementService {
    static Map<String, Process> simulators = new HashMap<String, Process>();

    private Integer getFreeport() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            Integer n = socket.getLocalPort();
            return n;
        }
    }

    public String getHostname() throws UnknownHostException {
        String hostname = "Unknown";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (UnknownHostException ex) {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.toString();
        }
    }

    public Pair<Integer, Process> launchNewClone(File base) throws IOException {
        int port = this.getFreeport();
        return Pair.of((Object)port, (Object)SimulationLauncher.restartApplication(base, "-Dserver.port=" + port));
    }

    public File getSimulatorDirectory(String simulatorId) {
        return Paths.get("simulators", simulatorId).toFile();
    }

    public boolean delete(String simulatorId) throws IOException {
        Process p = simulators.get(simulatorId);
        if (p != null) {
            p.destroy();
            simulators.remove(simulatorId);
            FileUtils.deleteDirectory((File)this.getSimulatorDirectory(simulatorId));
            return true;
        }
        return false;
    }

    public String create(String simulatorId) throws Exception {
        File base = this.getSimulatorDirectory(simulatorId);
        Pair<Integer, Process> integerProcessPair = this.launchNewClone(base);
        if (integerProcessPair == null || integerProcessPair.getValue() == null || !((Process)integerProcessPair.getValue()).isAlive()) {
            throw new Exception("failed to launch simulator");
        }
        simulators.put(simulatorId, (Process)integerProcessPair.getValue());
        return this.getHostname() + ":" + String.valueOf(integerProcessPair.getKey());
    }

    public void terminateApplication() {
        System.exit(0);
    }
}

