/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.modeldefinitionchecker;

import java.util.ArrayList;
import java.util.List;
import org.intocps.fmichecker.Orch;
import org.intocps.fmichecker.quotes.BooleanQuote;
import org.intocps.fmichecker.quotes.EnumerationQuote;
import org.intocps.fmichecker.quotes.IntegerQuote;
import org.intocps.fmichecker.quotes.RealQuote;
import org.intocps.fmichecker.quotes.StringQuote;
import org.intocps.fmichecker.quotes.approxQuote;
import org.intocps.fmichecker.quotes.calculatedParameterQuote;
import org.intocps.fmichecker.quotes.calculatedQuote;
import org.intocps.fmichecker.quotes.constantQuote;
import org.intocps.fmichecker.quotes.continuousQuote;
import org.intocps.fmichecker.quotes.discreteQuote;
import org.intocps.fmichecker.quotes.exactQuote;
import org.intocps.fmichecker.quotes.fixedQuote;
import org.intocps.fmichecker.quotes.independentQuote;
import org.intocps.fmichecker.quotes.inputQuote;
import org.intocps.fmichecker.quotes.localQuote;
import org.intocps.fmichecker.quotes.outputQuote;
import org.intocps.fmichecker.quotes.parameterQuote;
import org.intocps.fmichecker.quotes.tunableQuote;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.fmi.ModelDescription;
import org.overture.codegen.runtime.Tuple;

public class VdmSvChecker {
    public static List<Fmi2ModelDescription.ScalarVariable> validateModelVariables(List<Fmi2ModelDescription.ScalarVariable> modelVariables) throws ScalarVariableConfigException {
        ArrayList<Fmi2ModelDescription.ScalarVariable> SV_list = new ArrayList<Fmi2ModelDescription.ScalarVariable>();
        StringBuffer sb = new StringBuffer();
        for (Fmi2ModelDescription.ScalarVariable scalarVariable : modelVariables) {
            Orch.SV sv = new Orch.SV(VdmSvChecker.convertCausality(scalarVariable.causality), VdmSvChecker.convertVariability(scalarVariable.variability), VdmSvChecker.convertInitial(scalarVariable.initial), VdmSvChecker.convertType(scalarVariable.type));
            Orch.SV_X_ sv_x = Orch.InitSV(sv);
            Tuple res = Orch.Validate(sv_x);
            scalarVariable.causality = VdmSvChecker.convertCausalitySV(sv_x.causality);
            scalarVariable.variability = VdmSvChecker.convertVariabilitySV(sv_x.variability);
            scalarVariable.initial = VdmSvChecker.convertInitialSV(sv_x.initial);
            if (!((Boolean)res.get(0)).booleanValue()) {
                String message = String.valueOf(res.get(1));
                sb.append("Error in configuration of scalar variable '" + scalarVariable.name + "': " + message + "\n");
            }
            SV_list.add(scalarVariable);
        }
        if (sb.length() > 0) {
            throw new ScalarVariableConfigException(sb.toString());
        }
        return SV_list;
    }

    private static Orch.Type convertType(Fmi2ModelDescription.Type type) {
        Object t = null;
        switch (type.type) {
            case Boolean: {
                t = new BooleanQuote();
                break;
            }
            case Integer: {
                t = new IntegerQuote();
                break;
            }
            case Real: {
                t = new RealQuote();
                break;
            }
            case String: {
                t = new StringQuote();
                break;
            }
            case Enumeration: {
                t = new EnumerationQuote();
                break;
            }
        }
        return new Orch.Type(t, type.start != null ? type.start : null);
    }

    private static Object convertInitial(ModelDescription.Initial initial) {
        if (initial == null) {
            return null;
        }
        switch (initial) {
            case Approx: {
                return new approxQuote();
            }
            case Calculated: {
                return new calculatedQuote();
            }
            case Exact: {
                return new exactQuote();
            }
        }
        return null;
    }

    private static ModelDescription.Initial convertInitialSV(Object initial) {
        if (initial instanceof approxQuote) {
            return ModelDescription.Initial.Approx;
        }
        if (initial instanceof calculatedQuote) {
            return ModelDescription.Initial.Calculated;
        }
        if (initial instanceof exactQuote) {
            return ModelDescription.Initial.Exact;
        }
        return null;
    }

    private static Object convertVariability(ModelDescription.Variability variability) {
        if (variability == null) {
            return null;
        }
        switch (variability) {
            case Constant: {
                return new constantQuote();
            }
            case Continuous: {
                return new continuousQuote();
            }
            case Discrete: {
                return new discreteQuote();
            }
            case Fixed: {
                return new fixedQuote();
            }
            case Tunable: {
                return new tunableQuote();
            }
        }
        return null;
    }

    private static ModelDescription.Variability convertVariabilitySV(Object variability) {
        if (variability instanceof constantQuote) {
            return ModelDescription.Variability.Constant;
        }
        if (variability instanceof continuousQuote) {
            return ModelDescription.Variability.Continuous;
        }
        if (variability instanceof discreteQuote) {
            return ModelDescription.Variability.Discrete;
        }
        if (variability instanceof fixedQuote) {
            return ModelDescription.Variability.Fixed;
        }
        if (variability instanceof tunableQuote) {
            return ModelDescription.Variability.Tunable;
        }
        return null;
    }

    private static Object convertCausality(Fmi2ModelDescription.Causality causality) {
        if (causality == null) {
            return null;
        }
        switch (causality) {
            case CalculatedParameter: {
                return new calculatedParameterQuote();
            }
            case Independent: {
                return new independentQuote();
            }
            case Input: {
                return new inputQuote();
            }
            case Local: {
                return new localQuote();
            }
            case Output: {
                return new outputQuote();
            }
            case Parameter: {
                return new parameterQuote();
            }
        }
        return null;
    }

    private static Fmi2ModelDescription.Causality convertCausalitySV(Object causality) {
        if (causality instanceof calculatedParameterQuote) {
            return Fmi2ModelDescription.Causality.CalculatedParameter;
        }
        if (causality instanceof independentQuote) {
            return Fmi2ModelDescription.Causality.Independent;
        }
        if (causality instanceof inputQuote) {
            return Fmi2ModelDescription.Causality.Input;
        }
        if (causality instanceof localQuote) {
            return Fmi2ModelDescription.Causality.Local;
        }
        if (causality instanceof outputQuote) {
            return Fmi2ModelDescription.Causality.Output;
        }
        if (causality instanceof parameterQuote) {
            return Fmi2ModelDescription.Causality.Parameter;
        }
        return null;
    }

    public static class ScalarVariableConfigException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ScalarVariableConfigException(String message) {
            super(message);
        }
    }
}

