/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.parser;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Vector;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.parser.MablLexer;
import org.intocps.maestro.parser.MablParser;
import org.intocps.maestro.parser.ParseTree2AstConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MablParserUtil {
    static final Logger logger = LoggerFactory.getLogger(MablParserUtil.class);

    private static List<ARootDocument> parseStreams(List<CharStream> specStreams) {
        Vector<ARootDocument> documentList = new Vector<ARootDocument>();
        for (CharStream specStream : specStreams) {
            documentList.add(MablParserUtil.parse(specStream));
        }
        return documentList;
    }

    public static ARootDocument parse(CharStream specStreams) {
        MablLexer l = new MablLexer(specStreams);
        MablParser p = new MablParser((TokenStream)new CommonTokenStream((TokenSource)l));
        p.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, e);
            }
        });
        MablParser.CompilationUnitContext unit = p.compilationUnit();
        ARootDocument root = (ARootDocument)new ParseTree2AstConverter().visit((ParseTree)unit);
        return root;
    }

    public static ARootDocument parse(CharStream specStreams, final IErrorReporter reporter) {
        MablLexer l = new MablLexer(specStreams);
        MablParser p = new MablParser((TokenStream)new CommonTokenStream((TokenSource)l));
        p.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                reporter.report(0, msg, new LexToken("", line, 0));
            }
        });
        MablParser.CompilationUnitContext unit = p.compilationUnit();
        ARootDocument root = (ARootDocument)new ParseTree2AstConverter().visit((ParseTree)unit);
        return root;
    }

    public static List<ARootDocument> parse(List<File> sourceFiles, IErrorReporter reporter) throws IOException {
        Vector<ARootDocument> documentList = new Vector<ARootDocument>();
        for (File file : sourceFiles) {
            if (!file.exists()) {
                logger.warn("Unable to parse file. File does not exist: {}", (Object)file);
                continue;
            }
            logger.info("Parting file: {}", (Object)file);
            documentList.add(MablParserUtil.parse(CharStreams.fromPath((Path)Paths.get(file.toURI())), reporter));
        }
        return documentList;
    }

    public static List<ARootDocument> parse(List<File> sourceFiles) throws IOException {
        Vector<ARootDocument> documentList = new Vector<ARootDocument>();
        for (File file : sourceFiles) {
            if (!file.exists()) {
                logger.warn("Unable to parse file. File does not exist: {}", (Object)file);
                continue;
            }
            logger.info("Parting file: {}", (Object)file);
            documentList.add(MablParserUtil.parse(CharStreams.fromPath((Path)Paths.get(file.toURI()))));
        }
        return documentList;
    }
}

