/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.parser;

import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.intocps.maestro.ast.AAndBinaryExp;
import org.intocps.maestro.ast.ABasicBlockStm;
import org.intocps.maestro.ast.ADivideBinaryExp;
import org.intocps.maestro.ast.AEqualBinaryExp;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.AGreaterBinaryExp;
import org.intocps.maestro.ast.AGreaterEqualBinaryExp;
import org.intocps.maestro.ast.ALessBinaryExp;
import org.intocps.maestro.ast.ALessEqualBinaryExp;
import org.intocps.maestro.ast.AMinusBinaryExp;
import org.intocps.maestro.ast.AMinusUnaryExp;
import org.intocps.maestro.ast.AModuleDeclaration;
import org.intocps.maestro.ast.AMultiplyBinaryExp;
import org.intocps.maestro.ast.ANotEqualBinaryExp;
import org.intocps.maestro.ast.ANotUnaryExp;
import org.intocps.maestro.ast.AOrBinaryExp;
import org.intocps.maestro.ast.AParallelBlockStm;
import org.intocps.maestro.ast.APlusBinaryExp;
import org.intocps.maestro.ast.APlusUnaryExp;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.node.AArrayType;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.ABoolLiteralExp;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.ABreakStm;
import org.intocps.maestro.ast.node.AByteNumericPrimitiveType;
import org.intocps.maestro.ast.node.ACallExp;
import org.intocps.maestro.ast.node.AConfigFramework;
import org.intocps.maestro.ast.node.AConfigStm;
import org.intocps.maestro.ast.node.AErrorStm;
import org.intocps.maestro.ast.node.AExpInitializer;
import org.intocps.maestro.ast.node.AExpressionStm;
import org.intocps.maestro.ast.node.AFieldExp;
import org.intocps.maestro.ast.node.AFloatNumericPrimitiveType;
import org.intocps.maestro.ast.node.AFmuMappingStm;
import org.intocps.maestro.ast.node.AFormalParameter;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.AIdentifierStateDesignator;
import org.intocps.maestro.ast.node.AIfStm;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.node.AInstanceMappingStm;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.ALongNumericPrimitiveType;
import org.intocps.maestro.ast.node.ANameType;
import org.intocps.maestro.ast.node.ANullExp;
import org.intocps.maestro.ast.node.AObservableStm;
import org.intocps.maestro.ast.node.AParExp;
import org.intocps.maestro.ast.node.ARealLiteralExp;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.ARefExp;
import org.intocps.maestro.ast.node.AReferenceType;
import org.intocps.maestro.ast.node.ARootDocument;
import org.intocps.maestro.ast.node.AShortNumericPrimitiveType;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.AStringLiteralExp;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.ATransferAsStm;
import org.intocps.maestro.ast.node.ATransferStm;
import org.intocps.maestro.ast.node.ATryStm;
import org.intocps.maestro.ast.node.AUIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.AUnknownType;
import org.intocps.maestro.ast.node.AUnloadExp;
import org.intocps.maestro.ast.node.AVoidType;
import org.intocps.maestro.ast.node.AWhileStm;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PCompilationUnit;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.parser.MablParser;
import org.intocps.maestro.parser.MablParserBaseVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseTree2AstConverter
extends MablParserBaseVisitor<INode> {
    static final Logger logger = LoggerFactory.getLogger(ParseTree2AstConverter.class);

    @Override
    public INode visitCompilationUnit(MablParser.CompilationUnitContext ctx) {
        ARootDocument doc = new ARootDocument();
        List list = ctx.moduleDeclaration().stream().map(arg_0 -> ((ParseTree2AstConverter)this).visit(arg_0)).map(PCompilationUnit.class::cast).collect(Collectors.toCollection(Vector::new));
        if (ctx.simulationSpecification() != null) {
            list.add((PCompilationUnit)this.visit((ParseTree)ctx.simulationSpecification()));
        }
        doc.setContent(list);
        return doc;
    }

    @Override
    public INode visitModuleDeclaration(MablParser.ModuleDeclarationContext ctx) {
        AImportedModuleCompilationUnit unit = new AImportedModuleCompilationUnit();
        AModuleDeclaration module = new AModuleDeclaration();
        unit.setModule(module);
        module.setName(this.convert(ctx.name));
        if (ctx.imports != null && !ctx.imports.isEmpty()) {
            unit.setImports(ctx.imports.stream().map(this::convert).collect(Collectors.toList()));
        }
        module.setFunctions(ctx.functionDeclaration().stream().map(arg_0 -> ((ParseTree2AstConverter)this).visit(arg_0)).map(AFunctionDeclaration.class::cast).collect(Collectors.toList()));
        return unit;
    }

    @Override
    public INode visitTry(MablParser.TryContext ctx) {
        ATryStm tryStm = new ATryStm();
        tryStm.setBody((ABasicBlockStm)this.visit((ParseTree)ctx.tryBlock));
        tryStm.setFinally((ABasicBlockStm)this.visit((ParseTree)ctx.finallyBlock));
        return tryStm;
    }

    @Override
    public INode visitError(MablParser.ErrorContext ctx) {
        AErrorStm errStm = new AErrorStm();
        if (ctx.expression() != null) {
            errStm.setExp((PExp)this.visit((ParseTree)ctx.expression()));
        }
        return errStm;
    }

    @Override
    public INode visitFunctionDeclaration(MablParser.FunctionDeclarationContext ctx) {
        AFunctionDeclaration fun = new AFunctionDeclaration();
        fun.setName(this.convert(ctx.IDENTIFIER()));
        fun.setReturnType((PType)this.visit((ParseTree)ctx.ret));
        if (ctx.formalParameters().formalParameterList() != null) {
            fun.setFormals(ctx.formalParameters().formalParameterList().formalParameter().stream().map(arg_0 -> ((ParseTree2AstConverter)this).visit(arg_0)).map(AFormalParameter.class::cast).collect(Collectors.toList()));
        }
        return fun;
    }

    @Override
    public INode visitFormalParameter(MablParser.FormalParameterContext ctx) {
        AFormalParameter parameter = new AFormalParameter();
        parameter.setName(this.convert(ctx.IDENTIFIER()));
        PType type = (PType)this.visit((ParseTree)ctx.typeType());
        if (!(type instanceof AArrayType)) {
            for (int i = 0; i < ctx.dimentions.size(); ++i) {
                type = new AArrayType(type);
            }
        }
        if (ctx.direction != null && ctx.direction.getType() == 1) {
            AReferenceType refType = new AReferenceType();
            refType.setType(type);
            parameter.setType((PType)refType);
        } else {
            parameter.setType(type);
        }
        return parameter;
    }

    @Override
    public INode visitSimulationSpecification(MablParser.SimulationSpecificationContext ctx) {
        ASimulationSpecificationCompilationUnit unit = new ASimulationSpecificationCompilationUnit();
        unit.setBody((PStm)this.visit((ParseTree)ctx.statement()));
        if (ctx.imports != null && !ctx.imports.isEmpty()) {
            unit.setImports(ctx.imports.stream().map(this::convert).collect(Collectors.toList()));
        }
        if (ctx.framework() != null && !ctx.framework().isEmpty()) {
            unit.setFramework(ctx.framework().names.stream().map(s -> new LexIdentifier(s.getText().substring(1, s.getText().length() - 1), this.convertToLexToken((Token)s))).collect(Collectors.toList()));
        }
        if (ctx.frameworkConfigs() != null && !ctx.frameworkConfigs().isEmpty()) {
            unit.setFrameworkConfigs(ctx.frameworkConfigs().stream().map(arg_0 -> ((ParseTree2AstConverter)this).visit(arg_0)).map(AConfigFramework.class::cast).collect(Collectors.toList()));
        }
        return unit;
    }

    @Override
    public INode visitTransfer(MablParser.TransferContext ctx) {
        ATransferStm stm = new ATransferStm();
        if (ctx.names != null && !ctx.names.isEmpty()) {
            stm.setNames(ctx.names.stream().map(Token::getText).map(s -> new AStringLiteralExp(s.substring(1, s.length() - 1))).collect(Collectors.toList()));
        }
        return stm;
    }

    @Override
    public INode visitTransferAs(MablParser.TransferAsContext ctx) {
        ATransferAsStm stm = new ATransferAsStm();
        if (ctx.names != null && !ctx.names.isEmpty()) {
            stm.setNames(ctx.names.stream().map(Token::getText).map(s -> new AStringLiteralExp(s.substring(1, s.length() - 1))).collect(Collectors.toList()));
        }
        return stm;
    }

    @Override
    public INode visitFrameworkConfigs(MablParser.FrameworkConfigsContext ctx) {
        AConfigFramework config = new AConfigFramework();
        config.setName(new LexIdentifier(ctx.frameworkName.getText().substring(1, ctx.frameworkName.getText().length() - 1), this.convertToLexToken(ctx.frameworkName)));
        if (ctx.config != null) {
            config.setConfig(ctx.config.getText().substring(1, ctx.config.getText().length() - 1));
        }
        return config;
    }

    @Override
    public INode visitBlock(MablParser.BlockContext ctx) {
        ABasicBlockStm block = new ABasicBlockStm();
        List processedBody = ctx.statement().stream().filter(p -> !(p instanceof MablParser.SemiContext)).map(arg_0 -> ((ParseTree2AstConverter)this).visit(arg_0)).collect(Collectors.toList());
        processedBody.stream().filter(p -> !(p instanceof PStm)).forEach(s -> System.out.println("Wrong node type in body: " + s));
        List statements = processedBody.stream().map(PStm.class::cast).collect(Collectors.toList());
        if (statements.stream().anyMatch(Objects::isNull)) {
            logger.warn("found null");
        }
        block.setBody(statements);
        return block;
    }

    @Override
    public INode visitParallelBlockStm(MablParser.ParallelBlockStmContext ctx) {
        AParallelBlockStm parBlock = new AParallelBlockStm();
        parBlock.setBody((List)((ABasicBlockStm)this.visit((ParseTree)ctx.block())).getBody());
        return parBlock;
    }

    @Override
    public INode visitConfig(MablParser.ConfigContext ctx) {
        AConfigStm config = new AConfigStm();
        config.setConfig(ctx.config.getText().substring(1, ctx.STRING_LITERAL().getText().length() - 1));
        return config;
    }

    @Override
    public INode visitBreak(MablParser.BreakContext ctx) {
        return new ABreakStm(this.convertToLexToken(ctx.BREAK().getSymbol()));
    }

    @Override
    public INode visitAssignment(MablParser.AssignmentContext ctx) {
        AAssigmentStm assign = new AAssigmentStm();
        assign.setTarget((PStateDesignator)this.visit((ParseTree)ctx.stateDesignator()));
        assign.setExp((PExp)this.visit((ParseTree)ctx.expression()));
        return assign;
    }

    @Override
    public INode visitArrayStateDesignator(MablParser.ArrayStateDesignatorContext ctx) {
        AArrayStateDesignator designator = new AArrayStateDesignator();
        designator.setTarget((PStateDesignator)this.visit((ParseTree)ctx.stateDesignator()));
        designator.setExp((PExp)this.visit((ParseTree)ctx.expression()));
        return designator;
    }

    @Override
    public INode visitIdentifierStateDesignator(MablParser.IdentifierStateDesignatorContext ctx) {
        AIdentifierStateDesignator identifierExp = new AIdentifierStateDesignator();
        identifierExp.setName(this.convert(ctx.IDENTIFIER()));
        return identifierExp;
    }

    @Override
    public INode visitWhile(MablParser.WhileContext ctx) {
        AWhileStm stm = new AWhileStm();
        stm.setTest((PExp)this.visit((ParseTree)ctx.parExpression()));
        stm.setBody((PStm)this.visit((ParseTree)ctx.statement()));
        return stm;
    }

    @Override
    public INode visitBinaryExp(MablParser.BinaryExpContext ctx) {
        AMultiplyBinaryExp exp = null;
        if (ctx.MUL() != null) {
            exp = new AMultiplyBinaryExp();
        } else if (ctx.DIV() != null) {
            exp = new ADivideBinaryExp();
        } else if (ctx.ADD() != null) {
            exp = new APlusBinaryExp();
        } else if (ctx.SUB() != null) {
            exp = new AMinusBinaryExp();
        } else if (ctx.LE() != null) {
            exp = new ALessEqualBinaryExp();
        } else if (ctx.GE() != null) {
            exp = new AGreaterEqualBinaryExp();
        } else if (ctx.GT() != null) {
            exp = new AGreaterBinaryExp();
        } else if (ctx.LT() != null) {
            exp = new ALessBinaryExp();
        } else if (ctx.EQUAL() != null) {
            exp = new AEqualBinaryExp();
        } else if (ctx.NOTEQUAL() != null) {
            exp = new ANotEqualBinaryExp();
        } else if (ctx.AND() != null) {
            exp = new AAndBinaryExp();
        } else if (ctx.OR() != null) {
            exp = new AOrBinaryExp();
        }
        exp.setLeft((PExp)this.visit((ParseTree)ctx.left));
        exp.setRight((PExp)this.visit((ParseTree)ctx.right));
        return exp;
    }

    @Override
    public INode visitParenExp(MablParser.ParenExpContext ctx) {
        return new AParExp((PExp)this.visit((ParseTree)ctx.expression()));
    }

    @Override
    public INode visitLiteralExp(MablParser.LiteralExpContext ctx) {
        return (INode)this.visit((ParseTree)ctx.literal());
    }

    @Override
    public INode visitDotPrefixExp(MablParser.DotPrefixExpContext ctx) {
        PExp root = (PExp)this.visit((ParseTree)ctx.expression());
        if (ctx.IDENTIFIER() != null) {
            AFieldExp fieldExp = new AFieldExp();
            fieldExp.setRoot(root);
            fieldExp.setField(this.convert(ctx.IDENTIFIER()));
            return fieldExp;
        }
        if (ctx.methodCall() != null) {
            ACallExp call = (ACallExp)this.visit((ParseTree)ctx.methodCall());
            call.setObject(root);
            return call;
        }
        return null;
    }

    @Override
    public INode visitPlainMetodExp(MablParser.PlainMetodExpContext ctx) {
        return (INode)this.visit((ParseTree)ctx.methodCall());
    }

    @Override
    public INode visitUnaryExp(MablParser.UnaryExpContext ctx) {
        ANotUnaryExp exp = null;
        if (ctx.BANG() != null) {
            exp = new ANotUnaryExp();
        } else if (ctx.ADD() != null) {
            exp = new APlusUnaryExp();
        } else if (ctx.SUB() != null) {
            exp = new AMinusUnaryExp();
        }
        exp.setExp((PExp)this.visit((ParseTree)ctx.expression()));
        return exp;
    }

    @Override
    public INode visitIdentifierExp(MablParser.IdentifierExpContext ctx) {
        return new AIdentifierExp(this.convert(ctx.IDENTIFIER()));
    }

    @Override
    public INode visitArrayIndex(MablParser.ArrayIndexContext ctx) {
        AArrayIndexExp apply = new AArrayIndexExp();
        apply.setArray((PExp)this.visit((ParseTree)ctx.array));
        if (ctx.index != null) {
            apply.setIndices(ctx.index.stream().map(e -> (PExp)this.visit((ParseTree)e)).collect(Collectors.toList()));
        }
        return apply;
    }

    @Override
    public INode visitObservable(MablParser.ObservableContext ctx) {
        return new AObservableStm();
    }

    @Override
    public INode visitParExpression(MablParser.ParExpressionContext ctx) {
        return new AParExp((PExp)this.visit((ParseTree)ctx.expression()));
    }

    void checkList(List source, List processed) {
        if (!source.stream().anyMatch(p -> p == null)) {
            return;
        }
        for (int i = 0; i < source.size(); ++i) {
            if (processed.get(i) != null) continue;
            System.out.println("Problem translating: " + source.get(i).getClass().getSimpleName());
        }
    }

    private LexToken convertToLexToken(Token token) {
        return new LexToken(token.getText(), token.getLine(), token.getCharPositionInLine());
    }

    @Override
    public INode visitMethodCall(MablParser.MethodCallContext ctx) {
        ACallExp call = new ACallExp();
        if (ctx.expressionList() != null && ctx.expressionList().expression() != null) {
            List args = ctx.expressionList().expression().stream().map(arg_0 -> ((ParseTree2AstConverter)this).visit(arg_0)).map(PExp.class::cast).collect(Collectors.toList());
            this.checkList(ctx.expressionList().expression(), args);
            call.setArgs(args);
        }
        if (ctx.EXPAND() != null) {
            call.setExpand(this.convertToLexToken(ctx.EXPAND().getSymbol()));
        }
        call.setMethodName(this.convert(ctx.IDENTIFIER()));
        if (call.getMethodName().getText().equals("load")) {
            ALoadExp load = new ALoadExp();
            load.setArgs((List)call.getArgs());
            return load;
        }
        if (call.getMethodName().getText().equals("unload")) {
            AUnloadExp unload = new AUnloadExp();
            unload.setArgs((List)call.getArgs());
            return unload;
        }
        return call;
    }

    @Override
    public INode visitExpressionStatement(MablParser.ExpressionStatementContext ctx) {
        AExpressionStm stm = new AExpressionStm();
        stm.setExp((PExp)this.visit((ParseTree)ctx.statementExpression));
        return stm;
    }

    @Override
    public INode visitIf(MablParser.IfContext ctx) {
        AIfStm stm = new AIfStm();
        stm.setTest((PExp)this.visit((ParseTree)ctx.parExpression()));
        stm.setThen((PStm)this.visit((ParseTree)ctx.then));
        if (ctx.el != null) {
            stm.setElse((PStm)this.visit((ParseTree)ctx.el));
        }
        return stm;
    }

    @Override
    public INode visitVariableDeclarator(MablParser.VariableDeclaratorContext ctx) {
        MablParser.VariableInitializerContext initializer;
        AVariableDeclaration def = new AVariableDeclaration();
        def.setExternal(Boolean.valueOf(ctx.EXTERNAL() != null));
        PType primitiveType = (PType)this.visit((ParseTree)ctx.typeType());
        def.setType(primitiveType);
        def.setName(this.convert(ctx.IDENTIFIER()));
        if (ctx.size != null && !ctx.size.isEmpty()) {
            Vector<PExp> sizes = new Vector<PExp>();
            for (int i = 0; i < ctx.size.size(); ++i) {
                PExp elementSize = (PExp)this.visit((ParseTree)ctx.size.get(i));
                if (elementSize == null) continue;
                sizes.add(elementSize);
            }
            def.setSize(sizes);
        }
        if ((initializer = ctx.variableInitializer()) != null) {
            def.setInitializer((PInitializer)this.visit((ParseTree)initializer));
        }
        ALocalVariableStm var = new ALocalVariableStm();
        var.setDeclaration(def);
        return var;
    }

    @Override
    public INode visitLocalVariable(MablParser.LocalVariableContext ctx) {
        return (INode)this.visit((ParseTree)ctx.variableDeclarator());
    }

    @Override
    public INode visitArrayInit(MablParser.ArrayInitContext ctx) {
        AArrayInitializer initializer = new AArrayInitializer();
        initializer.setExp(ctx.arrayInitializer().init.stream().map(arg_0 -> ((ParseTree2AstConverter)this).visit(arg_0)).map(PExp.class::cast).collect(Collectors.toList()));
        return initializer;
    }

    @Override
    public INode visitExpInit(MablParser.ExpInitContext ctx) {
        AExpInitializer init = new AExpInitializer();
        init.setExp((PExp)this.visit((ParseTree)ctx.expression()));
        return init;
    }

    @Override
    public INode visitLiteral(MablParser.LiteralContext ctx) {
        if (ctx.BOOL_LITERAL() != null) {
            ABoolLiteralExp literal = new ABoolLiteralExp();
            literal.setValue(Boolean.valueOf(Boolean.parseBoolean(ctx.BOOL_LITERAL().getText())));
            return literal;
        }
        if (ctx.DECIMAL_LITERAL() != null) {
            AIntLiteralExp literal = new AIntLiteralExp();
            literal.setValue(Integer.valueOf(Integer.parseInt(ctx.DECIMAL_LITERAL().getText())));
            return literal;
        }
        if (ctx.FLOAT_LITERAL() != null) {
            ARealLiteralExp literal = new ARealLiteralExp();
            literal.setValue(Double.valueOf(Double.parseDouble(ctx.FLOAT_LITERAL().getText())));
            return literal;
        }
        if (ctx.STRING_LITERAL() != null) {
            AStringLiteralExp literal = new AStringLiteralExp();
            literal.setValue(ctx.STRING_LITERAL().getText().substring(1, ctx.STRING_LITERAL().getText().length() - 1));
            return literal;
        }
        if (ctx.NULL_LITERAL() != null) {
            ANullExp literal = new ANullExp();
            literal.setToken(this.convertToLexToken(ctx.NULL_LITERAL().getSymbol()));
            return literal;
        }
        throw new RuntimeException("unsupported literal");
    }

    @Override
    public INode visitInstanceMapping(MablParser.InstanceMappingContext ctx) {
        return new AInstanceMappingStm(this.convert(ctx.identifier), ctx.name.getText().substring(1, ctx.name.getText().length() - 1));
    }

    @Override
    public INode visitFmuMapping(MablParser.FmuMappingContext ctx) {
        return new AFmuMappingStm(this.convert(ctx.identifier), ctx.name.getText().substring(1, ctx.name.getText().length() - 1));
    }

    @Override
    public INode visitUnknownType(MablParser.UnknownTypeContext ctx) {
        return new AUnknownType();
    }

    @Override
    public INode visitBoolType(MablParser.BoolTypeContext ctx) {
        return new ABooleanPrimitiveType();
    }

    @Override
    public INode visitByteType(MablParser.ByteTypeContext ctx) {
        return new AByteNumericPrimitiveType();
    }

    @Override
    public INode visitShortType(MablParser.ShortTypeContext ctx) {
        return new AShortNumericPrimitiveType();
    }

    @Override
    public INode visitFloatType(MablParser.FloatTypeContext ctx) {
        return new AFloatNumericPrimitiveType();
    }

    @Override
    public INode visitLongType(MablParser.LongTypeContext ctx) {
        return new ALongNumericPrimitiveType();
    }

    @Override
    public INode visitRealType(MablParser.RealTypeContext ctx) {
        return new ARealNumericPrimitiveType();
    }

    @Override
    public INode visitUintType(MablParser.UintTypeContext ctx) {
        return new AUIntNumericPrimitiveType();
    }

    @Override
    public INode visitIntType(MablParser.IntTypeContext ctx) {
        return new AIntNumericPrimitiveType();
    }

    @Override
    public INode visitStringType(MablParser.StringTypeContext ctx) {
        return new AStringPrimitiveType();
    }

    @Override
    public INode visitVoidType(MablParser.VoidTypeContext ctx) {
        return new AVoidType();
    }

    private LexIdentifier convert(Token identifier) {
        return new LexIdentifier(identifier.getText(), this.convertToLexToken(identifier));
    }

    private LexIdentifier convert(TerminalNode identifier) {
        return new LexIdentifier(identifier.getText(), this.convertToLexToken(identifier.getSymbol()));
    }

    @Override
    public INode visitArrayTypeType(MablParser.ArrayTypeTypeContext ctx) {
        PType type = (PType)this.visit((ParseTree)ctx.type);
        for (int i = 0; i < ctx.dimentions.size(); ++i) {
            type = new AArrayType(type);
        }
        return type;
    }

    @Override
    public INode visitIdentifierTypeType(MablParser.IdentifierTypeTypeContext ctx) {
        return new ANameType(this.convert(ctx.type));
    }

    @Override
    public INode visitPrimitiveTypeType(MablParser.PrimitiveTypeTypeContext ctx) {
        return (INode)this.visit((ParseTree)ctx.type);
    }

    @Override
    public INode visitRefExpression(MablParser.RefExpressionContext ctx) {
        ARefExp exp = new ARefExp();
        exp.setExp((PExp)this.visit((ParseTree)ctx.expression()));
        return exp;
    }

    @Override
    public INode visitAndmedOrPrimitiveTypeType(MablParser.AndmedOrPrimitiveTypeTypeContext ctx) {
        return (INode)this.visit((ParseTree)ctx.type);
    }
}

