/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.parser.template;

import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.intocps.maestro.ast.AAndBinaryExp;
import org.intocps.maestro.ast.ADivideBinaryExp;
import org.intocps.maestro.ast.AEqualBinaryExp;
import org.intocps.maestro.ast.AGreaterBinaryExp;
import org.intocps.maestro.ast.AGreaterEqualBinaryExp;
import org.intocps.maestro.ast.ALessBinaryExp;
import org.intocps.maestro.ast.ALessEqualBinaryExp;
import org.intocps.maestro.ast.AMinusBinaryExp;
import org.intocps.maestro.ast.AMinusUnaryExp;
import org.intocps.maestro.ast.AMultiplyBinaryExp;
import org.intocps.maestro.ast.ANotEqualBinaryExp;
import org.intocps.maestro.ast.ANotUnaryExp;
import org.intocps.maestro.ast.AOrBinaryExp;
import org.intocps.maestro.ast.APlusBinaryExp;
import org.intocps.maestro.ast.APlusUnaryExp;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.ABoolLiteralExp;
import org.intocps.maestro.ast.node.ACallExp;
import org.intocps.maestro.ast.node.AFieldExp;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.ALoadExp;
import org.intocps.maestro.ast.node.ANullExp;
import org.intocps.maestro.ast.node.AParExp;
import org.intocps.maestro.ast.node.ARealLiteralExp;
import org.intocps.maestro.ast.node.AStringLiteralExp;
import org.intocps.maestro.ast.node.AUnloadExp;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.parser.ParseTree2AstConverter;
import org.intocps.maestro.parser.template.MablSwapConditionLexer;
import org.intocps.maestro.parser.template.MablSwapConditionParser;
import org.intocps.maestro.parser.template.MablSwapConditionParserBaseVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MablSwapConditionParserUtil {
    public static PExp parse(final CharStream specStreams) {
        MablSwapConditionLexer l = new MablSwapConditionLexer(specStreams);
        MablSwapConditionParser p = new MablSwapConditionParser((TokenStream)new CommonTokenStream((TokenSource)l));
        p.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                System.out.println(specStreams);
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, e);
            }
        });
        MablSwapConditionParser.ExpressionContext unit = p.expression();
        PExp root = (PExp)new SwapConditionParseTree2AstConverter().visit((ParseTree)unit);
        return root;
    }

    public static PExp parse(CharStream specStreams, final IErrorReporter reporter) {
        MablSwapConditionLexer l = new MablSwapConditionLexer(specStreams);
        MablSwapConditionParser p = new MablSwapConditionParser((TokenStream)new CommonTokenStream((TokenSource)l));
        p.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                reporter.report(0, msg, new LexToken("", line, 0));
            }
        });
        MablSwapConditionParser.ExpressionContext unit = p.expression();
        PExp root = (PExp)new SwapConditionParseTree2AstConverter().visit((ParseTree)unit);
        return root;
    }

    static class SwapConditionParseTree2AstConverter
    extends MablSwapConditionParserBaseVisitor<INode> {
        static final Logger logger = LoggerFactory.getLogger(ParseTree2AstConverter.class);

        SwapConditionParseTree2AstConverter() {
        }

        @Override
        public INode visitBinaryExp(MablSwapConditionParser.BinaryExpContext ctx) {
            AMultiplyBinaryExp exp = null;
            if (ctx.MUL() != null) {
                exp = new AMultiplyBinaryExp();
            } else if (ctx.DIV() != null) {
                exp = new ADivideBinaryExp();
            } else if (ctx.ADD() != null) {
                exp = new APlusBinaryExp();
            } else if (ctx.SUB() != null) {
                exp = new AMinusBinaryExp();
            } else if (ctx.LE() != null) {
                exp = new ALessEqualBinaryExp();
            } else if (ctx.GE() != null) {
                exp = new AGreaterEqualBinaryExp();
            } else if (ctx.GT() != null) {
                exp = new AGreaterBinaryExp();
            } else if (ctx.LT() != null) {
                exp = new ALessBinaryExp();
            } else if (ctx.EQUAL() != null) {
                exp = new AEqualBinaryExp();
            } else if (ctx.NOTEQUAL() != null) {
                exp = new ANotEqualBinaryExp();
            } else if (ctx.AND() != null) {
                exp = new AAndBinaryExp();
            } else if (ctx.OR() != null) {
                exp = new AOrBinaryExp();
            }
            exp.setLeft((PExp)this.visit((ParseTree)ctx.left));
            exp.setRight((PExp)this.visit((ParseTree)ctx.right));
            return exp;
        }

        @Override
        public INode visitParenExp(MablSwapConditionParser.ParenExpContext ctx) {
            return new AParExp((PExp)this.visit((ParseTree)ctx.expression()));
        }

        @Override
        public INode visitLiteralExp(MablSwapConditionParser.LiteralExpContext ctx) {
            return (INode)this.visit((ParseTree)ctx.literal());
        }

        @Override
        public INode visitDotPrefixExp(MablSwapConditionParser.DotPrefixExpContext ctx) {
            PExp root = (PExp)this.visit((ParseTree)ctx.expression());
            if (ctx.IDENTIFIER() != null) {
                AFieldExp fieldExp = new AFieldExp();
                fieldExp.setRoot(root);
                fieldExp.setField(this.convert(ctx.IDENTIFIER()));
                return fieldExp;
            }
            if (ctx.methodCall() != null) {
                ACallExp call = (ACallExp)this.visit((ParseTree)ctx.methodCall());
                call.setObject(root);
                return call;
            }
            return null;
        }

        @Override
        public INode visitPlainMetodExp(MablSwapConditionParser.PlainMetodExpContext ctx) {
            return (INode)this.visit((ParseTree)ctx.methodCall());
        }

        @Override
        public INode visitUnaryExp(MablSwapConditionParser.UnaryExpContext ctx) {
            ANotUnaryExp exp = null;
            if (ctx.BANG() != null) {
                exp = new ANotUnaryExp();
            } else if (ctx.ADD() != null) {
                exp = new APlusUnaryExp();
            } else if (ctx.SUB() != null) {
                exp = new AMinusUnaryExp();
            }
            exp.setExp((PExp)this.visit((ParseTree)ctx.expression()));
            return exp;
        }

        @Override
        public INode visitIdentifierExp(MablSwapConditionParser.IdentifierExpContext ctx) {
            return new AIdentifierExp(this.convert(ctx.IDENTIFIER()));
        }

        @Override
        public INode visitArrayIndex(MablSwapConditionParser.ArrayIndexContext ctx) {
            AArrayIndexExp apply = new AArrayIndexExp();
            apply.setArray((PExp)this.visit((ParseTree)ctx.array));
            if (ctx.index != null) {
                apply.setIndices(ctx.index.stream().map(e -> (PExp)this.visit((ParseTree)e)).collect(Collectors.toList()));
            }
            return apply;
        }

        @Override
        public INode visitParExpression(MablSwapConditionParser.ParExpressionContext ctx) {
            return new AParExp((PExp)this.visit((ParseTree)ctx.expression()));
        }

        void checkList(List source, List processed) {
            if (!source.stream().anyMatch(p -> p == null)) {
                return;
            }
            for (int i = 0; i < source.size(); ++i) {
                if (processed.get(i) != null) continue;
                System.out.println("Problem translating: " + source.get(i).getClass().getSimpleName());
            }
        }

        private LexToken convertToLexToken(Token token) {
            return new LexToken(token.getText(), token.getLine(), token.getCharPositionInLine());
        }

        @Override
        public INode visitMethodCall(MablSwapConditionParser.MethodCallContext ctx) {
            ACallExp call = new ACallExp();
            if (ctx.expressionList() != null && ctx.expressionList().expression() != null) {
                List args = ctx.expressionList().expression().stream().map(arg_0 -> ((SwapConditionParseTree2AstConverter)this).visit(arg_0)).map(PExp.class::cast).collect(Collectors.toList());
                this.checkList(ctx.expressionList().expression(), args);
                call.setArgs(args);
            }
            call.setMethodName(this.convert(ctx.IDENTIFIER()));
            if (call.getMethodName().getText().equals("load")) {
                ALoadExp load = new ALoadExp();
                load.setArgs((List)call.getArgs());
                return load;
            }
            if (call.getMethodName().getText().equals("unload")) {
                AUnloadExp unload = new AUnloadExp();
                unload.setArgs((List)call.getArgs());
                return unload;
            }
            return call;
        }

        @Override
        public INode visitLiteral(MablSwapConditionParser.LiteralContext ctx) {
            if (ctx.BOOL_LITERAL() != null) {
                ABoolLiteralExp literal = new ABoolLiteralExp();
                literal.setValue(Boolean.valueOf(Boolean.parseBoolean(ctx.BOOL_LITERAL().getText())));
                return literal;
            }
            if (ctx.DECIMAL_LITERAL() != null) {
                AIntLiteralExp literal = new AIntLiteralExp();
                literal.setValue(Integer.valueOf(Integer.parseInt(ctx.DECIMAL_LITERAL().getText())));
                return literal;
            }
            if (ctx.FLOAT_LITERAL() != null) {
                ARealLiteralExp literal = new ARealLiteralExp();
                literal.setValue(Double.valueOf(Double.parseDouble(ctx.FLOAT_LITERAL().getText())));
                return literal;
            }
            if (ctx.STRING_LITERAL() != null) {
                AStringLiteralExp literal = new AStringLiteralExp();
                literal.setValue(ctx.STRING_LITERAL().getText().substring(1, ctx.STRING_LITERAL().getText().length() - 1));
                return literal;
            }
            if (ctx.NULL_LITERAL() != null) {
                ANullExp literal = new ANullExp();
                literal.setToken(this.convertToLexToken(ctx.NULL_LITERAL().getSymbol()));
                return literal;
            }
            throw new RuntimeException("unsupported literal");
        }

        private LexIdentifier convert(Token identifier) {
            return new LexIdentifier(identifier.getText(), this.convertToLexToken(identifier));
        }

        private LexIdentifier convert(TerminalNode identifier) {
            return new LexIdentifier(identifier.getText(), this.convertToLexToken(identifier.getSymbol()));
        }
    }
}

