/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.node.AFormalParameter;
import org.intocps.maestro.ast.node.ANameType;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.AVoidType;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.core.ISimulationEnvironment;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.plugin.ExpandException;
import org.intocps.maestro.plugin.IMaestroExpansionPlugin;
import org.intocps.maestro.plugin.IPluginConfiguration;

public abstract class BasicMaestroExpansionPlugin
implements IMaestroExpansionPlugin {
    protected FunctionDeclarationBuilder getFunctionDeclarationBuilder(String name, PType returnType) {
        return new FunctionDeclarationBuilder(this, name, returnType);
    }

    protected FunctionDeclarationBuilder getFunctionDeclarationBuilder(String name) {
        return new FunctionDeclarationBuilder(this, name, (PType)new AVoidType());
    }

    @Override
    public IMaestroExpansionPlugin.ConfigOption getConfigRequirement() {
        return this.requireConfig() ? IMaestroExpansionPlugin.ConfigOption.Required : IMaestroExpansionPlugin.ConfigOption.NotRequired;
    }

    @Override
    public boolean requireConfig() {
        return false;
    }

    @Override
    public IPluginConfiguration parseConfig(InputStream is) throws IOException {
        return null;
    }

    @Override
    public <R> Map.Entry<List<PStm>, IMaestroExpansionPlugin.RuntimeConfigAddition<R>> expandWithRuntimeAddition(AFunctionDeclaration declaredFunction, List<PExp> formalArguments, IPluginConfiguration config, ISimulationEnvironment env, IErrorReporter errorReporter) throws ExpandException {
        return Map.entry(this.expand(declaredFunction, formalArguments, config, env, errorReporter), new IMaestroExpansionPlugin.EmptyRuntimeConfig());
    }

    @Override
    public List<PStm> expand(AFunctionDeclaration declaredFunction, List<PExp> formalArguments, IPluginConfiguration config, ISimulationEnvironment env, IErrorReporter errorReporter) throws ExpandException {
        return null;
    }

    @Override
    public <R> IMaestroExpansionPlugin.RuntimeConfigAddition<R> expandWithRuntimeAddition(AFunctionDeclaration declaredFunction, FmiBuilder<PStm, ASimulationSpecificationCompilationUnit, PExp, ?> builder, List<FmiBuilder.Variable<PStm, ?>> formalArguments, IPluginConfiguration config, ISimulationEnvironment env, IErrorReporter errorReporter) throws ExpandException {
        return new IMaestroExpansionPlugin.EmptyRuntimeConfig();
    }

    protected class FunctionDeclarationBuilder {
        private final String name;
        private final PType returnType;
        private final List<Map.Entry<String, PType>> args = new Vector<Map.Entry<String, PType>>();

        public FunctionDeclarationBuilder(BasicMaestroExpansionPlugin this$0, String name, PType returnType) {
            this.name = name;
            this.returnType = returnType;
        }

        public AFunctionDeclaration build() {
            return new AFunctionDeclaration(new LexIdentifier(this.name, null), this.returnType, this.args.stream().map(arg -> new AFormalParameter((PType)arg.getValue(), new LexIdentifier((String)arg.getKey(), null))).collect(Collectors.toList()));
        }

        public FunctionDeclarationBuilder addArg(Class<? extends PType> type, String name) {
            try {
                this.args.add(Map.entry(name, type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])));
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public FunctionDeclarationBuilder addArg(String typeName, String name) {
            this.args.add(Map.entry(name, new ANameType(new LexIdentifier(typeName, null))));
            return this;
        }
    }
}

