/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.AIdentifierExp;
import org.intocps.maestro.ast.AIntLiteralExp;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.PExp;
import org.intocps.maestro.ast.PInitializer;
import org.intocps.maestro.ast.PStateDesignator;
import org.intocps.maestro.ast.PStm;
import org.intocps.maestro.ast.PType;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.core.ISimulationEnvironment;
import org.intocps.maestro.plugin.ExpandException;
import org.intocps.maestro.plugin.IMaestroExpansionPlugin;
import org.intocps.maestro.plugin.IPluginConfiguration;
import org.intocps.maestro.plugin.SimulationFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SimulationFramework(framework=Framework.FMI2)
public class DebugLogging
implements IMaestroExpansionPlugin {
    static final String fixedStepStatus = "fix_status";
    static final Logger logger = LoggerFactory.getLogger(DebugLogging.class);
    private static final int FMI_OK = 0;
    private static final int FMI_WARNING = 1;
    private static final int FMI_DISCARD = 2;
    private static final int FMI_ERROR = 3;
    private static final int FMI_FATAL = 4;
    private static final int FMI_PENDING = 5;
    private static final String CATEGORY_STATUS = "category_status";
    final AFunctionDeclaration funEnable = MableAstFactory.newAFunctionDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)"enableDebugLogging"), Arrays.asList(MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newANameType((String)"FMI2Component")), (LexIdentifier)MableAstFactory.newAIdentifier((String)"component")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newAStringPrimitiveType()), (LexIdentifier)MableAstFactory.newAIdentifier((String)"categories")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAUIntNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"categoriesSize"))), (PType)MableAstFactory.newAVoidType());
    final AFunctionDeclaration funDisable = MableAstFactory.newAFunctionDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)"disableDebugLogging"), Arrays.asList(MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newANameType((String)"FMI2Component")), (LexIdentifier)MableAstFactory.newAIdentifier((String)"component")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newAStringPrimitiveType()), (LexIdentifier)MableAstFactory.newAIdentifier((String)"categories")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAUIntNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"categoriesSize"))), (PType)MableAstFactory.newAVoidType());

    public Set<AFunctionDeclaration> getDeclaredUnfoldFunctions() {
        return Stream.of(this.funEnable, this.funDisable).collect(Collectors.toSet());
    }

    public List<PStm> expand(AFunctionDeclaration declaredFunction, List<PExp> formalArguments, IPluginConfiguration config, ISimulationEnvironment env, IErrorReporter errorReporter) throws ExpandException {
        logger.info("Unfolding with fixed step: {}", (Object)declaredFunction.toString());
        if (!this.getDeclaredUnfoldFunctions().contains(declaredFunction)) {
            throw new ExpandException("Unknown function declaration");
        }
        AFunctionDeclaration selectedFun = declaredFunction;
        if (formalArguments == null || formalArguments.size() != selectedFun.getFormals().size()) {
            throw new ExpandException("Invalid args");
        }
        if (env == null) {
            throw new ExpandException("Simulation environment must not be null");
        }
        LexIdentifier name = ((AIdentifierExp)formalArguments.get(0)).getName();
        Vector<Object> statements = new Vector<Object>();
        AIdentifierExp categories = (AIdentifierExp)formalArguments.get(1);
        AIntLiteralExp size = (AIntLiteralExp)formalArguments.get(2);
        LexIdentifier statusIdentifier = MableAstFactory.newAIdentifier((String)CATEGORY_STATUS);
        statements.add(MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)statusIdentifier, (PType)MableAstFactory.newAIntNumericPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)((LexIdentifier)name.clone())), (LexIdentifier)MableAstFactory.newAIdentifier((String)"fmi2SetDebugLogging"), Arrays.asList(MableAstFactory.newABoolLiteralExp((Boolean)(selectedFun == this.funEnable ? 1 : 0)), size.clone(), categories.clone()))))));
        statements.add(MableAstFactory.newIf((PExp)MableAstFactory.newOr((PExp)MableAstFactory.newPar((PExp)MableAstFactory.newEqual((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)((LexIdentifier)statusIdentifier.clone())), (PExp)MableAstFactory.newAIntLiteralExp((Integer)3))), (PExp)MableAstFactory.newPar((PExp)MableAstFactory.newEqual((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)((LexIdentifier)statusIdentifier.clone())), (PExp)MableAstFactory.newAIntLiteralExp((Integer)4)))), (PStm)MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)"global_execution_continue")), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false)), null));
        return Arrays.asList(MableAstFactory.newIf((PExp)MableAstFactory.newAIdentifierExp((String)"global_execution_continue"), (PStm)MableAstFactory.newABlockStm(statements), null));
    }

    public boolean requireConfig() {
        return false;
    }

    public IPluginConfiguration parseConfig(InputStream is) throws IOException {
        return new FixedstepConfig((Integer)new ObjectMapper().readValue(is, Integer.class));
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getVersion() {
        return "0.0.1";
    }

    class FixedstepConfig
    implements IPluginConfiguration {
        final int endTime;

        public FixedstepConfig(int endTime) {
            this.endTime = endTime;
        }
    }
}

