/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intocps.maestro.ast.AArrayInitializer;
import org.intocps.maestro.ast.ABlockStm;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.AIdentifierExp;
import org.intocps.maestro.ast.ALocalVariableStm;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.PExp;
import org.intocps.maestro.ast.PInitializer;
import org.intocps.maestro.ast.PStm;
import org.intocps.maestro.ast.PType;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.core.ISimulationEnvironment;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.plugin.ExpandException;
import org.intocps.maestro.plugin.FixedstepConfig;
import org.intocps.maestro.plugin.IMaestroExpansionPlugin;
import org.intocps.maestro.plugin.IPluginConfiguration;
import org.intocps.maestro.plugin.JacobianFixedStep;
import org.intocps.maestro.plugin.SimulationFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SimulationFramework(framework=Framework.FMI2)
public class FixedStep
implements IMaestroExpansionPlugin {
    static final Logger logger = LoggerFactory.getLogger(FixedStep.class);
    final AFunctionDeclaration fun = MableAstFactory.newAFunctionDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)"fixedStep"), Arrays.asList(MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newANameType((String)"FMI2Component")), (LexIdentifier)MableAstFactory.newAIdentifier((String)"component")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAIntNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"stepSize")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAIntNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"startTime")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAIntNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"endTime"))), (PType)MableAstFactory.newAVoidType());

    public Set<AFunctionDeclaration> getDeclaredUnfoldFunctions() {
        return Stream.of(this.fun).collect(Collectors.toSet());
    }

    public List<PStm> expand(AFunctionDeclaration declaredFunction, List<PExp> formalArguments, IPluginConfiguration config, ISimulationEnvironment envIn, IErrorReporter errorReporter) throws ExpandException {
        logger.info("Unfolding with fixed step: {}", (Object)declaredFunction.toString());
        if (!this.getDeclaredUnfoldFunctions().contains(declaredFunction)) {
            throw new ExpandException("Unknown function declaration");
        }
        AFunctionDeclaration selectedFun = this.fun;
        if (formalArguments == null || formalArguments.size() != selectedFun.getFormals().size()) {
            throw new ExpandException("Invalid args");
        }
        if (envIn == null) {
            throw new ExpandException("Simulation environment must not be null");
        }
        Fmi2SimulationEnvironment env = (Fmi2SimulationEnvironment)envIn;
        ALocalVariableStm componentDecl = null;
        String componentsIdentifier = "fix_components";
        List knownComponentNames = null;
        if (formalArguments.get(0) instanceof AIdentifierExp) {
            LexIdentifier name = ((AIdentifierExp)formalArguments.get(0)).getName();
            ABlockStm containingBlock = (ABlockStm)formalArguments.get(0).getAncestor(ABlockStm.class);
            Optional<AVariableDeclaration> compDecl = containingBlock.getBody().stream().filter(ALocalVariableStm.class::isInstance).map(ALocalVariableStm.class::cast).map(ALocalVariableStm::getDeclaration).filter(decl -> decl.getName().equals((Object)name) && decl.getIsArray() != false && decl.getInitializer() != null).findFirst();
            if (!compDecl.isPresent()) {
                throw new ExpandException("Could not find names for comps");
            }
            AArrayInitializer initializer = (AArrayInitializer)compDecl.get().getInitializer();
            AVariableDeclaration varDecl = MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)componentsIdentifier), (PType)compDecl.get().getType().clone(), (PInitializer)compDecl.get().getInitializer().clone());
            varDecl.setSize((List)compDecl.get().getSize().clone());
            componentDecl = MableAstFactory.newALocalVariableStm((AVariableDeclaration)varDecl);
            knownComponentNames = initializer.getExp().stream().filter(AIdentifierExp.class::isInstance).map(AIdentifierExp.class::cast).map(AIdentifierExp::getName).collect(Collectors.toList());
        }
        if (knownComponentNames == null || knownComponentNames.isEmpty()) {
            throw new ExpandException("No components found cannot fixed step with 0 components");
        }
        List componentNames = knownComponentNames;
        Set<Fmi2SimulationEnvironment.Relation> relations = env.getRelations(componentNames).stream().filter(r -> r.getOrigin() == Fmi2SimulationEnvironment.Relation.InternalOrExternal.External).collect(Collectors.toSet());
        PExp stepSize = formalArguments.get(1).clone();
        PExp startTime = formalArguments.get(2).clone();
        PExp endTime = formalArguments.get(3).clone();
        return Arrays.asList(MableAstFactory.newIf((PExp)MableAstFactory.newAIdentifierExp((String)"global_execution_continue"), (PStm)MableAstFactory.newABlockStm(Stream.concat(Stream.of(componentDecl), JacobianFixedStep.generate(env, errorReporter, componentNames, componentsIdentifier, stepSize, startTime, endTime, relations).stream()).collect(Collectors.toList())), null));
    }

    LexIdentifier getStateName(LexIdentifier comp) {
        return MableAstFactory.newAIdentifier((String)(comp.getText() + "State"));
    }

    public boolean requireConfig() {
        return false;
    }

    public IPluginConfiguration parseConfig(InputStream is) throws IOException {
        return new FixedstepConfig((Integer)new ObjectMapper().readValue(is, Integer.class));
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getVersion() {
        return "0.0.1";
    }

    static enum ExecutionPhase {
        PreSimulationAllocation,
        SimulationLoopStage1,
        SimulationLoopStage2,
        SimulationLoopStage3,
        PostTimeSync,
        PostSimulationDeAllocation;

    }
}

