/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.MableBuilder;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.framework.fmi2.ComponentInfo;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateHandler {
    static final Logger logger = LoggerFactory.getLogger(StateHandler.class);
    final boolean supportsGetSetState;
    final List<LexIdentifier> componentNames;
    final String fix_comp_states = "fix_comp_states";
    Function<LexIdentifier, PStateDesignator> getCompStatusDesignator;
    BiConsumer<Map.Entry<Boolean, String>, Map.Entry<LexIdentifier, List<PStm>>> checkStatus;
    Function<LexIdentifier, PExp> getCompStateDesignator;

    public StateHandler(List<LexIdentifier> componentNames, Fmi2SimulationEnvironment env, Function<LexIdentifier, PStateDesignator> getCompStatusDesignator, BiConsumer<Map.Entry<Boolean, String>, Map.Entry<LexIdentifier, List<PStm>>> checkStatus) {
        this.componentNames = componentNames;
        this.getCompStatusDesignator = getCompStatusDesignator;
        this.checkStatus = checkStatus;
        this.supportsGetSetState = env.getInstances().stream().filter(f -> componentNames.stream().anyMatch(m -> m.getText().equals(f.getKey()))).allMatch(pair -> {
            try {
                return ((ComponentInfo)pair.getValue()).modelDescription.getCanGetAndSetFmustate();
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
                return false;
            }
        });
        this.getCompStateDesignator = comp -> MableBuilder.arrayGet((String)"fix_comp_states", (int)componentNames.indexOf(comp));
        logger.debug("Expand with get/set state: {}", (Object)this.supportsGetSetState);
    }

    public List<PStm> allocate() {
        if (!this.supportsGetSetState) {
            return Collections.emptyList();
        }
        return Collections.singletonList(MableBuilder.newVariable((String)"fix_comp_states", (PType)MableAstFactory.newANameType((String)"FmiComponentState"), (int)this.componentNames.size()));
    }

    public List<PStm> getAllStates() {
        if (!this.supportsGetSetState) {
            return Collections.emptyList();
        }
        Consumer<List> getAllStates = list -> this.componentNames.forEach(comp -> {
            list.add(MableAstFactory.newAAssignmentStm((PStateDesignator)this.getCompStatusDesignator.apply((LexIdentifier)comp), (PExp)MableBuilder.call((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)((LexIdentifier)comp.clone())), (String)"getState", (PExp[])new PExp[]{MableAstFactory.newARefExp((PExp)this.getCompStateDesignator.apply((LexIdentifier)comp))})));
            this.checkStatus.accept(Map.entry(true, "get state failed"), Map.entry(comp, list));
        });
        Vector<PStm> statements = new Vector<PStm>();
        getAllStates.accept(statements);
        return statements;
    }

    public List<PStm> freeAllStates() {
        if (!this.supportsGetSetState) {
            return Collections.emptyList();
        }
        Consumer<List> freeAllStates = list -> this.componentNames.forEach(comp -> {
            list.add(MableAstFactory.newAAssignmentStm((PStateDesignator)this.getCompStatusDesignator.apply((LexIdentifier)comp), (PExp)MableBuilder.call((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)((LexIdentifier)comp.clone())), (String)"freeState", (PExp[])new PExp[]{this.getCompStateDesignator.apply((LexIdentifier)comp)})));
            this.checkStatus.accept(Map.entry(true, "free state failed"), Map.entry(comp, list));
        });
        Vector<PStm> statements = new Vector<PStm>();
        freeAllStates.accept(statements);
        return statements;
    }
}

