/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.AArrayStateDesignator;
import org.intocps.maestro.ast.node.ABooleanPrimitiveType;
import org.intocps.maestro.ast.node.AIntNumericPrimitiveType;
import org.intocps.maestro.ast.node.ARealNumericPrimitiveType;
import org.intocps.maestro.ast.node.AStringPrimitiveType;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.SPrimitiveType;
import org.intocps.maestro.fmi.ModelDescription;
import org.intocps.maestro.framework.core.IRelation;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.RelationVariable;

public class DataExchangeHandler {
    private final Set<Fmi2SimulationEnvironment.Relation> outputRelations;
    private final Map<LexIdentifier, Map<ModelDescription.Types, List<ModelDescription.ScalarVariable>>> outputs;
    private final Set<Fmi2SimulationEnvironment.Relation> inputRelations;
    private final Map<LexIdentifier, Map<ModelDescription.Types, List<ModelDescription.ScalarVariable>>> inputs;
    Function<LexIdentifier, PStateDesignator> getCompStatusDesignator;
    BiConsumer<Map.Entry<Boolean, String>, Map.Entry<LexIdentifier, List<PStm>>> checkStatus;

    public DataExchangeHandler(Set<Fmi2SimulationEnvironment.Relation> relations, Fmi2SimulationEnvironment env, Function<LexIdentifier, PStateDesignator> getCompStatusDesignator, BiConsumer<Map.Entry<Boolean, String>, Map.Entry<LexIdentifier, List<PStm>>> checkStatus) {
        this.checkStatus = checkStatus;
        this.getCompStatusDesignator = getCompStatusDesignator;
        this.outputRelations = relations.stream().filter(r -> r.getDirection() == IRelation.Direction.OutputToInput).collect(Collectors.toSet());
        this.outputs = this.outputRelations.stream().map(r -> r.getSource().scalarVariable.instance).distinct().collect(Collectors.toMap(Function.identity(), s -> this.outputRelations.stream().filter(r -> r.getSource().scalarVariable.instance.equals(s)).flatMap(r -> {
            List outputs_ = env.getVariablesToLog(s.getText()).stream().map(x -> x.scalarVariable).collect(Collectors.toList());
            return outputs_.stream();
        }).distinct().collect(Collectors.groupingBy(sv -> sv.getType().type))));
        this.inputRelations = relations.stream().filter(r -> r.getDirection() == IRelation.Direction.InputToOutput).collect(Collectors.toSet());
        this.inputs = this.inputRelations.stream().map(r -> r.getSource().scalarVariable.instance).distinct().collect(Collectors.toMap(Function.identity(), s -> this.inputRelations.stream().filter(r -> r.getSource().scalarVariable.instance.equals(s)).map(r -> r.getSource().scalarVariable.getScalarVariable()).collect(Collectors.groupingBy(sv -> sv.getType().type))));
    }

    static String getFmiGetName(ModelDescription.Types type, UsageType usage) {
        String fun = usage == UsageType.In ? "set" : "get";
        switch (type) {
            case Boolean: {
                return fun + "Boolean";
            }
            case Real: {
                return fun + "Real";
            }
            case Integer: {
                return fun + "Integer";
            }
            case String: {
                return fun + "String";
            }
        }
        return null;
    }

    static SPrimitiveType convert(ModelDescription.Types type) {
        switch (type) {
            case Boolean: {
                return MableAstFactory.newABoleanPrimitiveType();
            }
            case Real: {
                return MableAstFactory.newARealNumericPrimitiveType();
            }
            case Integer: {
                return MableAstFactory.newAIntNumericPrimitiveType();
            }
            case String: {
                return MableAstFactory.newAStringPrimitiveType();
            }
        }
        return null;
    }

    static LexIdentifier getBufferName(LexIdentifier comp, ModelDescription.Types type, UsageType usage) {
        return DataExchangeHandler.getBufferName(comp, DataExchangeHandler.convert(type), usage);
    }

    static LexIdentifier getBufferName(LexIdentifier comp, SPrimitiveType type, UsageType usage) {
        String t = DataExchangeHandler.getTypeId(type);
        return MableAstFactory.newAIdentifier((String)(comp.getText() + t + usage));
    }

    static String getTypeId(SPrimitiveType type) {
        String t = type.getClass().getSimpleName();
        if (type instanceof ARealNumericPrimitiveType) {
            t = "R";
        } else if (type instanceof AIntNumericPrimitiveType) {
            t = "I";
        } else if (type instanceof AStringPrimitiveType) {
            t = "S";
        } else if (type instanceof ABooleanPrimitiveType) {
            t = "B";
        }
        return t;
    }

    public Map<LexIdentifier, Map<ModelDescription.Types, List<ModelDescription.ScalarVariable>>> getOutputs() {
        return this.outputs;
    }

    public Set<Fmi2SimulationEnvironment.Relation> getInputRelations() {
        return this.inputRelations;
    }

    LexIdentifier getVrefName(LexIdentifier comp, ModelDescription.Types type, UsageType usage) {
        return MableAstFactory.newAIdentifier((String)(comp.getText() + "Vref" + DataExchangeHandler.getTypeId(DataExchangeHandler.convert(type)) + usage));
    }

    public List<PStm> allocate() {
        Vector<PStm> statements = new Vector<PStm>();
        this.outputs.forEach((comp, map) -> map.forEach((type, vars) -> statements.add((PStm)MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)DataExchangeHandler.getBufferName(comp, type, UsageType.Out), (PType)MableAstFactory.newAArrayType((PType)DataExchangeHandler.convert(type)), (int)vars.size(), null)))));
        this.outputs.forEach((comp, map) -> map.forEach((type, vars) -> statements.add((PStm)MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)this.getVrefName((LexIdentifier)comp, (ModelDescription.Types)type, UsageType.Out), (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newAUIntNumericPrimitiveType()), (int)vars.size(), (PInitializer)MableAstFactory.newAArrayInitializer(vars.stream().map(v -> MableAstFactory.newAIntLiteralExp((Integer)((int)v.valueReference))).collect(Collectors.toList())))))));
        this.inputs.forEach((comp, map) -> map.forEach((type, vars) -> statements.add((PStm)MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)DataExchangeHandler.getBufferName(comp, type, UsageType.In), (PType)MableAstFactory.newAArrayType((PType)DataExchangeHandler.convert(type)), (int)vars.size(), null)))));
        this.inputs.forEach((comp, map) -> map.forEach((type, vars) -> statements.add((PStm)MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)this.getVrefName((LexIdentifier)comp, (ModelDescription.Types)type, UsageType.In), (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newAUIntNumericPrimitiveType()), (int)vars.size(), (PInitializer)MableAstFactory.newAArrayInitializer(vars.stream().map(v -> MableAstFactory.newAIntLiteralExp((Integer)((int)v.valueReference))).collect(Collectors.toList())))))));
        return statements;
    }

    public List<PStm> getAll(boolean inSimulationLoop) {
        BiConsumer<Boolean, List> getAll = (inLoop, list) -> this.outputs.forEach((comp, map) -> map.forEach((type, vars) -> {
            list.add(MableAstFactory.newAAssignmentStm((PStateDesignator)this.getCompStatusDesignator.apply((LexIdentifier)comp), (PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)((LexIdentifier)comp.clone())), (LexIdentifier)MableAstFactory.newAIdentifier((String)DataExchangeHandler.getFmiGetName(type, UsageType.Out)), Arrays.asList(MableAstFactory.newAIdentifierExp((LexIdentifier)this.getVrefName((LexIdentifier)comp, (ModelDescription.Types)type, UsageType.Out)), MableAstFactory.newAIntLiteralExp((Integer)vars.size()), MableAstFactory.newAIdentifierExp((LexIdentifier)DataExchangeHandler.getBufferName(comp, type, UsageType.Out))))));
            this.checkStatus.accept(Map.entry(inSimulationLoop, "get failed"), Map.entry(comp, list));
        }));
        Vector<PStm> statements = new Vector<PStm>();
        getAll.accept(inSimulationLoop, statements);
        return statements;
    }

    public List<PStm> setAll() {
        Consumer<List> setAll = list -> this.inputs.forEach((comp, map) -> map.forEach((type, vars) -> {
            list.add(MableAstFactory.newAAssignmentStm((PStateDesignator)this.getCompStatusDesignator.apply((LexIdentifier)comp), (PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)((LexIdentifier)comp.clone())), (LexIdentifier)MableAstFactory.newAIdentifier((String)DataExchangeHandler.getFmiGetName(type, UsageType.In)), Arrays.asList(MableAstFactory.newAIdentifierExp((LexIdentifier)this.getVrefName((LexIdentifier)comp, (ModelDescription.Types)type, UsageType.In)), MableAstFactory.newAIntLiteralExp((Integer)vars.size()), MableAstFactory.newAIdentifierExp((LexIdentifier)DataExchangeHandler.getBufferName(comp, type, UsageType.In))))));
            this.checkStatus.accept(Map.entry(true, "set failed"), Map.entry(comp, list));
        }));
        Vector<PStm> statements = new Vector<PStm>();
        setAll.accept(statements);
        return statements;
    }

    public List<PStm> exchangeData() {
        Consumer<List> exchangeData = list -> this.inputRelations.forEach(r -> {
            int toIndex = this.inputs.get(r.getSource().scalarVariable.instance).get(r.getSource().scalarVariable.getScalarVariable().getType().type).stream().map(ModelDescription.ScalarVariable::getName).collect(Collectors.toList()).indexOf(r.getSource().scalarVariable.scalarVariable.getName());
            AArrayStateDesignator to = MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)DataExchangeHandler.getBufferName(r.getSource().scalarVariable.instance, r.getSource().scalarVariable.getScalarVariable().getType().type, UsageType.In)), (PExp)MableAstFactory.newAIntLiteralExp((Integer)toIndex));
            RelationVariable fromVar = ((Fmi2SimulationEnvironment.Variable)r.getTargets().values().iterator().next()).scalarVariable;
            AArrayIndexExp from = MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)DataExchangeHandler.getBufferName(fromVar.instance, fromVar.getScalarVariable().type.type, UsageType.Out)), Collections.singletonList(MableAstFactory.newAIntLiteralExp((Integer)this.outputs.get(fromVar.instance).get(fromVar.getScalarVariable().getType().type).stream().map(ModelDescription.ScalarVariable::getName).collect(Collectors.toList()).indexOf(fromVar.scalarVariable.getName()))));
            if (r.getSource().scalarVariable.getScalarVariable().getType().type != fromVar.getScalarVariable().getType().type) {
                AArrayIndexExp toAsExp = MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)DataExchangeHandler.getBufferName(r.getSource().scalarVariable.instance, r.getSource().scalarVariable.getScalarVariable().getType().type, UsageType.In)), Arrays.asList(MableAstFactory.newAIntLiteralExp((Integer)toIndex)));
                list.add(MableAstFactory.newExpressionStm((PExp)MableAstFactory.newACallExp((LexToken)MableAstFactory.newExpandToken(), (PExp)MableAstFactory.newAIdentifierExp((String)"TypeConverter"), (LexIdentifier)MableAstFactory.newAIdentifier((String)("convert" + fromVar.getScalarVariable().getType().type + "2" + r.getSource().scalarVariable.getScalarVariable().getType().type)), Arrays.asList(from, toAsExp))));
            } else {
                list.add(MableAstFactory.newAAssignmentStm((PStateDesignator)to, (PExp)from));
            }
        });
        Vector<PStm> statements = new Vector<PStm>();
        exchangeData.accept(statements);
        return statements;
    }

    static enum UsageType {
        In,
        Out;

    }
}

