/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.MableBuilder;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.framework.core.FrameworkUnitInfo;
import org.intocps.maestro.framework.fmi2.ComponentInfo;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.RelationVariable;
import org.intocps.maestro.plugin.DataExchangeHandler;
import org.intocps.maestro.plugin.GeneratorComponent;

public class DataWriterHandler
implements GeneratorComponent {
    private final String data_HeadersIdentifier = "data_headers";
    private final String dataWriter = "dataWriter";
    private final String data_valuesIdentifier = "data_values";
    private final String data_configuration = "dataWriter_configuration";
    Map<RelationVariable, PExp> csvFields;

    public List<PStm> allocate(Set<Fmi2SimulationEnvironment.Relation> inputRelations, Map<LexIdentifier, Map<Fmi2ModelDescription.Types, List<Fmi2ModelDescription.ScalarVariable>>> outputs, Fmi2SimulationEnvironment env) {
        Vector<PStm> statements = new Vector<PStm>();
        Vector variableNames = new Vector();
        Function<RelationVariable, String> getLogName = k -> k.instance.getText() + "." + k.getScalarVariable().getName();
        this.csvFields = inputRelations.stream().map(r -> r.getTargets().values().stream().findFirst()).filter(Optional::isPresent).map(Optional::get).flatMap(h -> {
            List outputs_ = env.getVariablesToLog(h.scalarVariable.instance.getText());
            return outputs_.stream();
        }).sorted(Comparator.comparing(getLogName::apply)).collect(Collectors.toMap(l -> l, r -> {
            RelationVariable fromVar = r;
            PExp from = MableBuilder.arrayGet((LexIdentifier)DataExchangeHandler.getBufferName(fromVar.instance, fromVar.getScalarVariable().type.type, DataExchangeHandler.UsageType.Out), (int)((List)((Map)outputs.get(fromVar.instance)).get(fromVar.getScalarVariable().getType().type)).stream().map(Fmi2ModelDescription.ScalarVariable::getName).collect(Collectors.toList()).indexOf(fromVar.scalarVariable.getName()));
            return from;
        }, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        variableNames.addAll(this.csvFields.keySet().stream().map(k -> {
            FrameworkUnitInfo info = env.getUnitInfo(k.instance, Framework.FMI2);
            Stream<String> nameComponents = Stream.of(k.instance.getText(), k.getScalarVariable().getName());
            if (info instanceof ComponentInfo) {
                nameComponents = Stream.concat(Stream.of(((ComponentInfo)info).fmuIdentifier), nameComponents);
            }
            return nameComponents.collect(Collectors.joining("."));
        }).collect(Collectors.toList()));
        statements.add(MableBuilder.newVariable((String)this.data_HeadersIdentifier, (PType)MableAstFactory.newAStringPrimitiveType(), variableNames.stream().map(MableAstFactory::newAStringLiteralExp).collect(Collectors.toList())));
        statements.add(MableBuilder.newVariable((String)this.data_configuration, (PType)MableAstFactory.newANameType((String)"DataWriterConfig"), (PExp)MableBuilder.call((String)this.dataWriter, (String)"writeHeader", (PExp[])new PExp[]{MableAstFactory.newAIdentifierExp((String)this.data_HeadersIdentifier)})));
        Consumer<List> declareCsvBuffer = list -> list.add(MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)this.data_valuesIdentifier), (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newAUnknownType()), (int)variableNames.size(), (PInitializer)MableAstFactory.newAArrayInitializer(this.csvFields.values().stream().map(PExp::clone).collect(Collectors.toList())))));
        declareCsvBuffer.accept(statements);
        return statements;
    }

    public List<PStm> write() {
        Consumer<List> logCsvValues = list -> {
            Vector<AIdentifierExp> args = new Vector<AIdentifierExp>();
            args.addAll(Arrays.asList(MableAstFactory.newAIdentifierExp((String)this.data_configuration), MableAstFactory.newAIdentifierExp((String)"time")));
            this.csvFields.values().forEach(v -> args.add((AIdentifierExp)v.clone()));
            list.add(MableAstFactory.newExpressionStm((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.dataWriter), (LexIdentifier)MableAstFactory.newAIdentifier((String)"writeDataPoint"), args)));
        };
        Vector<PStm> statements = new Vector<PStm>();
        logCsvValues.accept(statements);
        return statements;
    }

    @Override
    public List<PStm> deallocate() {
        return Collections.singletonList(MableAstFactory.newExpressionStm((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)this.dataWriter), (LexIdentifier)MableAstFactory.newAIdentifier((String)"close"), Arrays.asList(new PExp[0]))));
    }
}

