/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.AModuleDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.ToParExp;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.display.PrettyPrinter;
import org.intocps.maestro.ast.node.ABlockStm;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.core.ISimulationEnvironment;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.BooleanBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.DataWriter;
import org.intocps.maestro.framework.fmi2.api.mabl.FromMaBLToMaBLAPI;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.MathBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.ScopeFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.WhileMaBLScope;
import org.intocps.maestro.framework.fmi2.api.mabl.values.IntExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.IntVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.intocps.maestro.plugin.ExpandException;
import org.intocps.maestro.plugin.FixedstepConfig;
import org.intocps.maestro.plugin.IMaestroExpansionPlugin;
import org.intocps.maestro.plugin.IPluginConfiguration;
import org.intocps.maestro.plugin.SimulationFramework;
import org.intocps.orchestration.coe.modeldefinition.ModelDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SimulationFramework(framework=Framework.FMI2)
public class FixedStepBuilder
implements IMaestroExpansionPlugin {
    static final Logger logger = LoggerFactory.getLogger(FixedStepBuilder.class);
    final AFunctionDeclaration fun = MableAstFactory.newAFunctionDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)"fixedStep"), Arrays.asList(MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newANameType((String)"FMI2Component")), (LexIdentifier)MableAstFactory.newAIdentifier((String)"component")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newARealNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"stepSize")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newARealNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"startTime")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newARealNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"endTime"))), (PType)MableAstFactory.newAVoidType());

    public Set<AFunctionDeclaration> getDeclaredUnfoldFunctions() {
        return Stream.of(this.fun).collect(Collectors.toSet());
    }

    public List<PStm> expand(AFunctionDeclaration declaredFunction, List<PExp> formalArguments, IPluginConfiguration config, ISimulationEnvironment envIn, IErrorReporter errorReporter) throws ExpandException {
        logger.info("Unfolding with fixed step: {}", (Object)declaredFunction.toString());
        FixedstepConfig fixedstepConfig = (FixedstepConfig)config;
        if (!this.getDeclaredUnfoldFunctions().contains(declaredFunction)) {
            throw new ExpandException("Unknown function declaration");
        }
        AFunctionDeclaration selectedFun = this.fun;
        if (formalArguments == null || formalArguments.size() != selectedFun.getFormals().size()) {
            throw new ExpandException("Invalid args");
        }
        if (envIn == null) {
            throw new ExpandException("Simulation environment must not be null");
        }
        Fmi2SimulationEnvironment env = (Fmi2SimulationEnvironment)envIn;
        PExp stepSize = formalArguments.get(1).clone();
        PExp startTime = formalArguments.get(2).clone();
        PExp endTime = formalArguments.get(3).clone();
        if (declaredFunction.equals((Object)this.fun)) {
            try {
                MablApiBuilder.MablSettings settings = new MablApiBuilder.MablSettings();
                settings.externalRuntimeLogger = true;
                MablApiBuilder builder = new MablApiBuilder(settings, true);
                DynamicActiveBuilderScope dynamicScope = builder.getDynamicScope();
                MathBuilderFmi2Api math = builder.getMablToMablAPI().getMathBuilder();
                BooleanBuilderFmi2Api booleanLogic = builder.getMablToMablAPI().getBooleanBuilder();
                DoubleVariableFmi2Api externalStepSize = builder.getDoubleVariableFrom(stepSize);
                DoubleVariableFmi2Api stepSizeVar = dynamicScope.store("fixed_step_size", 0.0);
                stepSizeVar.setValue((Fmi2Builder.Variable)externalStepSize);
                DoubleVariableFmi2Api externalStartTime = new DoubleVariableFmi2Api(null, null, null, null, startTime);
                DoubleVariableFmi2Api currentCommunicationTime = dynamicScope.store("fixed_current_communication_point", 0.0);
                currentCommunicationTime.setValue((Fmi2Builder.Variable)externalStartTime);
                DoubleVariableFmi2Api externalEndTime = new DoubleVariableFmi2Api(null, null, null, null, endTime);
                DoubleVariableFmi2Api endTimeVar = dynamicScope.store("fixed_end_time", 0.0);
                endTimeVar.setValue((Fmi2Builder.Variable)externalEndTime);
                Map fmuInstances = FromMaBLToMaBLAPI.GetComponentVariablesFrom((MablApiBuilder)builder, (PExp)formalArguments.get(0), (Fmi2SimulationEnvironment)env);
                FromMaBLToMaBLAPI.CreateBindings((Map)fmuInstances, (ISimulationEnvironment)env);
                DataWriter dataWriter = builder.getMablToMablAPI().getDataWriter();
                DataWriter.DataWriterInstance dataWriterInstance = dataWriter.createDataWriterInstance();
                dataWriterInstance.initialize(fmuInstances.values().stream().flatMap(x -> x.getVariablesToLog().stream()).collect(Collectors.toList()));
                PredicateFmi2Api loopPredicate = currentCommunicationTime.toMath().addition((Fmi2Builder.NumericTypedReferenceExp)stepSizeVar).lessThan((Fmi2Builder.NumericTypedReferenceExp)endTimeVar);
                DoubleVariableFmi2Api absTol = dynamicScope.store("absolute_tolerance", 1.0);
                DoubleVariableFmi2Api relTol = dynamicScope.store("relative_tolerance", 1.0);
                List<Fmi2Builder.StateVariable> fmuStates = fmuInstances.values().stream().map(x -> x.getState()).collect(Collectors.toList());
                fmuInstances.forEach((x, y) -> {
                    List variablesToLog = env.getVariablesToLog(x);
                    y.share(y.get((String[])variablesToLog.stream().map(var -> var.scalarVariable.getName()).toArray(String[]::new)));
                });
                IntVariableFmi2Api stabilisation_loop_max_iterations = dynamicScope.store("stabilisation_loop_max_iterations", 5);
                WhileMaBLScope scopeFmi2Api = dynamicScope.enterWhile((Fmi2Builder.LogicBuilder.Predicate)loopPredicate);
                WhileMaBLScope stabilisationScope = null;
                IntVariableFmi2Api stabilisation_loop = null;
                BooleanVariableFmi2Api convergenceReached = null;
                if (fixedstepConfig.stabilisation) {
                    stabilisation_loop = dynamicScope.store("stabilisation_loop", stabilisation_loop_max_iterations);
                    convergenceReached = dynamicScope.store("hasConverged", false);
                    stabilisationScope = dynamicScope.enterWhile((Fmi2Builder.LogicBuilder.Predicate)convergenceReached.toPredicate().not().and(stabilisation_loop.toMath().greaterThan((Fmi2Builder.NumericTypedReferenceExp)IntExpressionValue.of((int)0))));
                }
                fmuInstances.forEach((x, y) -> y.setLinked());
                fmuInstances.forEach((x, y) -> {
                    Map.Entry a = y.step((Fmi2Builder.DoubleVariable)currentCommunicationTime, (Fmi2Builder.DoubleVariable)stepSizeVar);
                });
                Map<ComponentVariableFmi2Api, Map> retrievedValues = fmuInstances.entrySet().stream().collect(Collectors.toMap(entry -> (ComponentVariableFmi2Api)entry.getValue(), entry -> {
                    List variablesToLog = env.getVariablesToLog((String)entry.getKey());
                    String[] variablesToGet = (String[])variablesToLog.stream().map(var -> var.scalarVariable.getName()).toArray(String[]::new);
                    return ((ComponentVariableFmi2Api)entry.getValue()).get(variablesToGet);
                }));
                if (fixedstepConfig.stabilisation) {
                    List convergenceVariables = retrievedValues.entrySet().stream().flatMap(comptoPortAndVariable -> {
                        Stream<BooleanVariableFmi2Api> converged = ((Map)comptoPortAndVariable.getValue()).entrySet().stream().filter(x -> ((PortFmi2Api)x.getKey()).scalarVariable.type.type == ModelDescription.Types.Real).map(portAndVariable -> {
                            VariableFmi2Api oldVariable = ((PortFmi2Api)portAndVariable.getKey()).getSharedAsVariable();
                            VariableFmi2Api newVariable = (VariableFmi2Api)portAndVariable.getValue();
                            return math.checkConvergence((Fmi2Builder.ProvidesTypedReferenceExp)oldVariable, (Fmi2Builder.ProvidesTypedReferenceExp)newVariable, (Fmi2Builder.DoubleVariable)absTol, (Fmi2Builder.DoubleVariable)relTol);
                        });
                        return converged;
                    }).collect(Collectors.toList());
                    convergenceReached.setValue((Fmi2Builder.Variable)booleanLogic.allTrue("convergence", convergenceVariables));
                    ScopeFmi2Api ifScope = dynamicScope.enterIf((Fmi2Builder.LogicBuilder.Predicate)convergenceReached.toPredicate().not()).enterThen();
                    fmuStates.forEach(x -> x.set());
                    if (stabilisation_loop == null) {
                        throw new RuntimeException("NO STABILISATION LOOP FOUND");
                    }
                    stabilisation_loop.decrement();
                    stabilisationScope.activate();
                    retrievedValues.forEach((k, v) -> k.share(v));
                }
                scopeFmi2Api.activate();
                if (!fixedstepConfig.stabilisation) {
                    retrievedValues.forEach((k, v) -> k.share(v));
                }
                currentCommunicationTime.setValue(currentCommunicationTime.toMath().addition((Fmi2Builder.NumericTypedReferenceExp)stepSizeVar));
                dataWriterInstance.log(currentCommunicationTime);
                ABlockStm algorithm = (ABlockStm)builder.buildRaw();
                algorithm.apply((IAnalysis)new ToParExp());
                System.out.println(PrettyPrinter.print((INode)algorithm));
                return algorithm.getBody();
            }
            catch (Exception e) {
                throw new ExpandException("Internal error: ", (Throwable)e);
            }
        }
        throw new ExpandException("Unknown function");
    }

    public boolean requireConfig() {
        return true;
    }

    public IPluginConfiguration parseConfig(InputStream is) throws IOException {
        return (IPluginConfiguration)new ObjectMapper().readValue(is, FixedstepConfig.class);
    }

    public AImportedModuleCompilationUnit getDeclaredImportUnit() {
        AImportedModuleCompilationUnit unit = new AImportedModuleCompilationUnit();
        unit.setImports(Stream.of("FMI2", "TypeConverter", "Math", "Logger", "DataWriter", "ArrayUtil").map(MableAstFactory::newAIdentifier).collect(Collectors.toList()));
        AModuleDeclaration module = new AModuleDeclaration();
        module.setName(MableAstFactory.newAIdentifier((String)this.getName()));
        module.setFunctions(new ArrayList<AFunctionDeclaration>(this.getDeclaredUnfoldFunctions()));
        unit.setModule(module);
        return unit;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public String getVersion() {
        return "0.0.1";
    }
}

