/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin.Initializer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.maestro.ast.AArrayInitializer;
import org.intocps.maestro.ast.ABlockStm;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.AIdentifierExp;
import org.intocps.maestro.ast.ALocalVariableStm;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.PExp;
import org.intocps.maestro.ast.PInitializer;
import org.intocps.maestro.ast.PStm;
import org.intocps.maestro.ast.PType;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.core.ISimulationEnvironment;
import org.intocps.maestro.framework.fmi2.ComponentInfo;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.plugin.ExpandException;
import org.intocps.maestro.plugin.IMaestroExpansionPlugin;
import org.intocps.maestro.plugin.IPluginConfiguration;
import org.intocps.maestro.plugin.Initializer.ConversionUtilities.LongUtils;
import org.intocps.maestro.plugin.Initializer.PhasePredicates;
import org.intocps.maestro.plugin.Initializer.RelationsPredicates;
import org.intocps.maestro.plugin.Initializer.Spec.StatementGeneratorContainer;
import org.intocps.maestro.plugin.Initializer.TopologicalPlugin;
import org.intocps.maestro.plugin.SimulationFramework;
import org.intocps.maestro.plugin.verificationsuite.PrologVerifier.InitializationPrologQuery;
import org.intocps.orchestration.coe.config.InvalidVariableStringException;
import org.intocps.orchestration.coe.config.ModelConnection;
import org.intocps.orchestration.coe.config.ModelParameter;
import org.intocps.orchestration.coe.modeldefinition.ModelDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SimulationFramework(framework=Framework.FMI2)
public class Initializer
implements IMaestroExpansionPlugin {
    static final Logger logger = LoggerFactory.getLogger(Initializer.class);
    final AFunctionDeclaration f1 = MableAstFactory.newAFunctionDeclaration((LexIdentifier)new LexIdentifier("initialize", null), Arrays.asList(MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newANameType((String)"FMI2Component")), (LexIdentifier)MableAstFactory.newAIdentifier((String)"component")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAIntNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"startTime")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAIntNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"endTime"))), (PType)MableAstFactory.newAVoidType());
    private final HashMap<ModelConnection.ModelInstance, HashSet<ModelDescription.ScalarVariable>> portsAlreadySet = new HashMap();
    private final TopologicalPlugin topologicalPlugin;
    private final InitializationPrologQuery initializationPrologQuery;
    Config config;
    List<ModelParameter> modelParameters;

    public Initializer() {
        this.initializationPrologQuery = new InitializationPrologQuery();
        this.topologicalPlugin = new TopologicalPlugin();
    }

    public Initializer(TopologicalPlugin topologicalPlugin, InitializationPrologQuery initializationPrologQuery) {
        this.topologicalPlugin = topologicalPlugin;
        this.initializationPrologQuery = initializationPrologQuery;
    }

    public String getName() {
        return Initializer.class.getSimpleName();
    }

    public String getVersion() {
        return "0.0.0";
    }

    public Set<AFunctionDeclaration> getDeclaredUnfoldFunctions() {
        return Stream.of(this.f1).collect(Collectors.toSet());
    }

    public List<PStm> expand(AFunctionDeclaration declaredFunction, List<PExp> formalArguments, IPluginConfiguration config, ISimulationEnvironment envIn, IErrorReporter errorReporter) throws ExpandException {
        logger.debug("Unfolding: {}", (Object)declaredFunction.toString());
        Fmi2SimulationEnvironment env = (Fmi2SimulationEnvironment)envIn;
        this.verifyArguments(formalArguments, (ISimulationEnvironment)env);
        List<LexIdentifier> knownComponentNames = this.extractComponentNames(formalArguments);
        StatementGeneratorContainer.reset();
        StatementGeneratorContainer sc = StatementGeneratorContainer.getInstance();
        this.setSCParameters(formalArguments, (Config)config, sc);
        Vector<Object> statements = new Vector<Object>();
        AVariableDeclaration status = MableAstFactory.newAVariableDeclaration((LexIdentifier)new LexIdentifier("status", null), (PType)MableAstFactory.newAIntNumericPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newAIntLiteralExp((Integer)0)));
        statements.add(MableAstFactory.newALocalVariableStm((AVariableDeclaration)status));
        logger.debug("Setup experiment for all components");
        knownComponentNames.forEach(comp -> statements.addAll(Arrays.asList(sc.createSetupExperimentStatement(comp.getText(), false, 0.0, true), StatementGeneratorContainer.statusCheck((PExp)MableAstFactory.newAIdentifierExp((String)"status"), StatementGeneratorContainer.FMIWARNINGANDFATALERRORCODES, "Setup Experiment Failed: ", true, true))));
        Set<Fmi2SimulationEnvironment.Relation> relations = env.getRelations(knownComponentNames).stream().filter(o -> o.getDirection() == Fmi2SimulationEnvironment.Relation.Direction.OutputToInput).collect(Collectors.toSet());
        List<Set<Fmi2SimulationEnvironment.Variable>> instantiationOrder = this.topologicalPlugin.findInstantiationOrderStrongComponents(relations);
        statements.addAll(this.setComponentsVariables(env, knownComponentNames, sc, PhasePredicates.iniPhase()));
        if (this.config.verifyAgainstProlog && !this.initializationPrologQuery.initializationOrderIsValid(instantiationOrder.stream().flatMap(Collection::stream).collect(Collectors.toList()), relations)) {
            throw new ExpandException("The found initialization order is not correct");
        }
        logger.debug("Enter initialization Mode");
        knownComponentNames.forEach(comp -> statements.add(sc.enterInitializationMode(comp.getText())));
        List<Fmi2SimulationEnvironment.Relation> inputToOutputRelations = env.getRelations(knownComponentNames).stream().filter(RelationsPredicates.inputToOutput()).collect(Collectors.toList());
        Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, AbstractMap.SimpleEntry<ModelConnection.ModelInstance, ModelDescription.ScalarVariable>>> inputOutMapping = this.createInputOutputMapping(inputToOutputRelations, (ISimulationEnvironment)env);
        sc.setInputOutputMapping(inputOutMapping);
        statements.addAll(this.initializeInterconnectedPorts(env, sc, instantiationOrder));
        knownComponentNames.forEach(comp -> statements.add(sc.exitInitializationMode(comp.getText())));
        statements.add(MableAstFactory.newBreak());
        return Arrays.asList(MableAstFactory.newWhile((PExp)MableAstFactory.newAIdentifierExp((String)"global_execution_continue"), (PStm)MableAstFactory.newABlockStm(statements)));
    }

    private void setSCParameters(List<PExp> formalArguments, Config config, StatementGeneratorContainer sc) {
        sc.startTime = formalArguments.get(1).clone();
        sc.endTime = formalArguments.get(2).clone();
        this.config = config;
        this.modelParameters = this.config.getModelParameters();
        sc.absoluteTolerance = this.config.absoluteTolerance;
        sc.relativeTolerance = this.config.relativeTolerance;
        sc.modelParameters = this.modelParameters;
    }

    private List<PStm> initializeInterconnectedPorts(Fmi2SimulationEnvironment env, StatementGeneratorContainer sc, List<Set<Fmi2SimulationEnvironment.Variable>> instantiationOrder) throws ExpandException {
        int sccNumber = 0;
        Vector<PStm> stms = new Vector<PStm>();
        if (this.config.Stabilisation && instantiationOrder.stream().noneMatch(v -> v.size() > 1)) {
            stms.addAll(this.initializeUsingFixedPoint(instantiationOrder.stream().flatMap(Collection::stream).collect(Collectors.toList()), sc, env, sccNumber));
        } else {
            for (Set<Fmi2SimulationEnvironment.Variable> variables : instantiationOrder) {
                if (this.config.Stabilisation) {
                    stms.addAll(this.initializeUsingFixedPoint(new ArrayList<Fmi2SimulationEnvironment.Variable>(variables), sc, env, sccNumber++));
                    stms.add((PStm)MableAstFactory.newIf((PExp)MableAstFactory.newAIdentifierExp((String)"global_execution_continue"), (PStm)MableAstFactory.newBreak(), null));
                    continue;
                }
                if (variables.size() == 1) {
                    try {
                        stms.addAll(this.initializePort(variables, sc, env));
                    }
                    catch (ExpandException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (variables.size() <= 1) continue;
                throw new ExpandException("The co-simulation scenario contains loops, but the initialization is not configured to handle these scenarios");
            }
        }
        return stms;
    }

    private List<PStm> initializeUsingFixedPoint(List<Fmi2SimulationEnvironment.Variable> variables, StatementGeneratorContainer sc, Fmi2SimulationEnvironment env, int sccNumber) throws ExpandException {
        List<Set<Fmi2SimulationEnvironment.Variable>> optimizedOrder = this.optimizeInstantiationOrder(variables);
        return sc.createFixedPointIteration(variables, this.config.maxIterations, sccNumber, env);
    }

    private List<ModelDescription.ScalarVariable> getScalarVariables(Set<Fmi2SimulationEnvironment.Variable> variables) {
        return variables.stream().map(o -> o.scalarVariable.getScalarVariable()).collect(Collectors.toList());
    }

    private List<Set<Fmi2SimulationEnvironment.Variable>> optimizeInstantiationOrder(List<Fmi2SimulationEnvironment.Variable> instantiationOrder) {
        Vector<Set<Fmi2SimulationEnvironment.Variable>> optimizedOrder = new Vector<Set<Fmi2SimulationEnvironment.Variable>>();
        Fmi2SimulationEnvironment.Variable previousVariable = instantiationOrder.get(0);
        HashSet<Object> currentSet = new HashSet<Fmi2SimulationEnvironment.Variable>(Collections.singletonList(previousVariable));
        for (int i = 1; i < instantiationOrder.size(); ++i) {
            Fmi2SimulationEnvironment.Variable currentVariable = instantiationOrder.get(i);
            if (!this.canBeOptimized(currentVariable, previousVariable)) {
                optimizedOrder.add(currentSet);
                currentSet = new HashSet();
            }
            previousVariable = currentVariable;
            currentSet.add(previousVariable);
        }
        if (!currentSet.isEmpty()) {
            optimizedOrder.add(currentSet);
        }
        return optimizedOrder;
    }

    private boolean canBeOptimized(Fmi2SimulationEnvironment.Variable variable1, Fmi2SimulationEnvironment.Variable variable2) {
        return variable1.scalarVariable.getInstance() == variable2.scalarVariable.getInstance() && variable2.scalarVariable.getScalarVariable().causality == variable1.scalarVariable.getScalarVariable().causality && variable2.scalarVariable.getScalarVariable().getType().type == variable1.scalarVariable.getScalarVariable().getType().type;
    }

    private Map<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, AbstractMap.SimpleEntry<ModelConnection.ModelInstance, ModelDescription.ScalarVariable>>> createInputOutputMapping(List<Fmi2SimulationEnvironment.Relation> relations, ISimulationEnvironment env) {
        HashMap<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, AbstractMap.SimpleEntry<ModelConnection.ModelInstance, ModelDescription.ScalarVariable>>> inputToOutputMapping = new HashMap<ModelConnection.ModelInstance, Map<ModelDescription.ScalarVariable, AbstractMap.SimpleEntry<ModelConnection.ModelInstance, ModelDescription.ScalarVariable>>>();
        Map<LexIdentifier, List<Fmi2SimulationEnvironment.Relation>> relationsPerInstance = relations.stream().collect(Collectors.groupingBy(o -> o.getSource().scalarVariable.getInstance()));
        relationsPerInstance.forEach((instance, rel) -> {
            ComponentInfo infoSource = (ComponentInfo)env.getUnitInfo(instance, Framework.FMI2);
            HashMap entryMap = new HashMap();
            rel.forEach(r -> r.getTargets().values().forEach(v -> {
                ComponentInfo infoTarget = (ComponentInfo)env.getUnitInfo(v.scalarVariable.getInstance(), Framework.FMI2);
                entryMap.put(r.getSource().scalarVariable.getScalarVariable(), new AbstractMap.SimpleEntry<ModelConnection.ModelInstance, ModelDescription.ScalarVariable>(new ModelConnection.ModelInstance(infoTarget.fmuIdentifier, v.scalarVariable.getInstance().getText()), v.scalarVariable.scalarVariable));
            }));
            inputToOutputMapping.put(new ModelConnection.ModelInstance(infoSource.fmuIdentifier, instance.getText()), entryMap);
        });
        return inputToOutputMapping;
    }

    private List<PStm> initializePort(Set<Fmi2SimulationEnvironment.Variable> ports, StatementGeneratorContainer sc, Fmi2SimulationEnvironment env) throws ExpandException {
        List<ModelDescription.ScalarVariable> scalarVariables = this.getScalarVariables(ports);
        ModelDescription.Types type = scalarVariables.iterator().next().getType().type;
        LexIdentifier instance = ((Fmi2SimulationEnvironment.Variable)ports.stream().findFirst().get()).scalarVariable.getInstance();
        ModelDescription.Causality causality = scalarVariables.iterator().next().causality;
        long[] scalarValueIndices = this.GetValueRefIndices(scalarVariables);
        Vector<PStm> stms = new Vector<PStm>();
        if (causality == ModelDescription.Causality.Output) {
            List<PStm> statements = sc.getValueStm(instance.getText(), null, scalarValueIndices, type);
            stms.addAll(statements);
        } else {
            stms.addAll(sc.setValueOnPortStm(instance, type, scalarVariables, scalarValueIndices, env));
        }
        return stms;
    }

    private List<PStm> setComponentsVariables(Fmi2SimulationEnvironment env, List<LexIdentifier> knownComponentNames, StatementGeneratorContainer sc, Predicate<ModelDescription.ScalarVariable> predicate) {
        Vector<PStm> stms = new Vector<PStm>();
        knownComponentNames.forEach(comp -> {
            ComponentInfo info = (ComponentInfo)env.getUnitInfo(comp, Framework.FMI2);
            try {
                Map<ModelDescription.Types, List<ModelDescription.ScalarVariable>> variablesToInitialize = info.modelDescription.getScalarVariables().stream().filter(predicate).collect(Collectors.groupingBy(o -> o.getType().type));
                if (!variablesToInitialize.isEmpty()) {
                    variablesToInitialize.forEach((type, variables) -> {
                        try {
                            stms.addAll(sc.setValueOnPortStm((LexIdentifier)comp, (ModelDescription.Types)type, (List<ModelDescription.ScalarVariable>)variables, this.GetValueRefIndices((List<ModelDescription.ScalarVariable>)variables), env));
                        }
                        catch (ExpandException e) {
                            e.printStackTrace();
                        }
                    });
                }
            }
            catch (IllegalAccessException | InvocationTargetException | XPathExpressionException e) {
                logger.error(e.getMessage());
            }
        });
        return stms;
    }

    private long[] GetValueRefIndices(List<ModelDescription.ScalarVariable> variables) {
        return variables.stream().map(o -> o.getValueReference()).map(Long.class::cast).collect(LongUtils.TO_LONG_ARRAY);
    }

    private List<LexIdentifier> extractComponentNames(List<PExp> formalArguments) throws ExpandException {
        List knownComponentNames = null;
        if (formalArguments.get(0) instanceof AIdentifierExp) {
            LexIdentifier name = ((AIdentifierExp)formalArguments.get(0)).getName();
            ABlockStm containingBlock = (ABlockStm)formalArguments.get(0).getAncestor(ABlockStm.class);
            Optional<AVariableDeclaration> compDecl = containingBlock.getBody().stream().filter(ALocalVariableStm.class::isInstance).map(ALocalVariableStm.class::cast).map(ALocalVariableStm::getDeclaration).filter(decl -> decl.getName().equals((Object)name) && decl.getIsArray() != false && decl.getInitializer() != null).findFirst();
            if (compDecl.isEmpty()) {
                throw new ExpandException("Could not find names for comps");
            }
            AArrayInitializer initializer = (AArrayInitializer)compDecl.get().getInitializer();
            knownComponentNames = initializer.getExp().stream().filter(AIdentifierExp.class::isInstance).map(AIdentifierExp.class::cast).map(AIdentifierExp::getName).collect(Collectors.toList());
        }
        if (knownComponentNames == null || knownComponentNames.isEmpty()) {
            throw new ExpandException("No components found cannot fixed step with 0 components");
        }
        return knownComponentNames;
    }

    private void verifyArguments(List<PExp> formalArguments, ISimulationEnvironment env) throws ExpandException {
        if (formalArguments == null || formalArguments.size() != this.f1.getFormals().size()) {
            throw new ExpandException("Invalid args");
        }
        if (env == null) {
            throw new ExpandException("Simulation environment must not be null");
        }
    }

    public boolean requireConfig() {
        return true;
    }

    public IPluginConfiguration parseConfig(InputStream is) throws IOException {
        JsonNode root = new ObjectMapper().readTree(is);
        if (root instanceof ArrayNode) {
            root = root.get(0);
        }
        JsonNode parameters = root.get("parameters");
        JsonNode verify = root.get("verifyAgainstProlog");
        JsonNode stabilisation = root.get("stabilisation");
        JsonNode fixedPointIteration = root.get("fixedPointIteration");
        JsonNode absoluteTolerance = root.get("absoluteTolerance");
        JsonNode relativeTolerance = root.get("relativeTolerance");
        Config conf = null;
        try {
            conf = new Config(parameters, verify, stabilisation, fixedPointIteration, absoluteTolerance, relativeTolerance);
        }
        catch (InvalidVariableStringException e) {
            e.printStackTrace();
        }
        return conf;
    }

    public static class Config
    implements IPluginConfiguration {
        public final boolean Stabilisation;
        private final List<ModelParameter> modelParameters;
        private final boolean verifyAgainstProlog;
        private final int maxIterations;
        private final double absoluteTolerance;
        private final double relativeTolerance;

        public Config(JsonNode parameters, JsonNode verify, JsonNode stabilisation, JsonNode fixedPointIteration, JsonNode absoluteTolerance, JsonNode relativeTolerance) throws InvalidVariableStringException {
            ObjectMapper mapper = new ObjectMapper();
            Map result = (Map)mapper.convertValue((Object)parameters, (TypeReference)new TypeReference<Map<String, Object>>(){});
            this.modelParameters = this.buildParameters(result);
            this.verifyAgainstProlog = verify == null ? false : verify.asBoolean(false);
            this.Stabilisation = stabilisation == null ? false : stabilisation.asBoolean(false);
            this.maxIterations = fixedPointIteration == null ? 5 : fixedPointIteration.asInt(5);
            this.absoluteTolerance = absoluteTolerance == null ? 0.2 : absoluteTolerance.asDouble(0.2);
            this.relativeTolerance = relativeTolerance == null ? 0.1 : relativeTolerance.asDouble(0.1);
        }

        public List<ModelParameter> getModelParameters() {
            return this.modelParameters;
        }

        private List<ModelParameter> buildParameters(Map<String, Object> parameters) throws InvalidVariableStringException {
            Vector<ModelParameter> list = new Vector<ModelParameter>();
            if (parameters != null) {
                for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                    list.add(new ModelParameter(ModelConnection.Variable.parse((String)entry.getKey()), entry.getValue()));
                }
            }
            return list;
        }
    }
}

