/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin.initializer.spec;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.intocps.maestro.ast.AEqualBinaryExp;
import org.intocps.maestro.ast.AVariableDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.LexToken;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.MableBuilder;
import org.intocps.maestro.ast.node.AArrayIndexExp;
import org.intocps.maestro.ast.node.AArrayInitializer;
import org.intocps.maestro.ast.node.AArrayType;
import org.intocps.maestro.ast.node.AAssigmentStm;
import org.intocps.maestro.ast.node.AErrorStm;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.AIntLiteralExp;
import org.intocps.maestro.ast.node.ALocalVariableStm;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PExpBase;
import org.intocps.maestro.ast.node.PInitializer;
import org.intocps.maestro.ast.node.PStateDesignator;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.ast.node.SPrimitiveTypeBase;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.framework.fmi2.ComponentInfo;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.ModelConnection;
import org.intocps.maestro.plugin.ExpandException;
import org.intocps.maestro.plugin.initializer.ModelParameter;
import org.intocps.maestro.plugin.initializer.conversionutilities.BooleanUtils;
import org.intocps.maestro.plugin.initializer.spec.VariableLocation;

public class StatementGeneratorContainer {
    public static final BiFunction<PExp, String, PStm> errorReporter = (status, message) -> MableAstFactory.newExpressionStm((PExp)MableBuilder.call((String)"logger", (String)"log", (PExp[])new PExp[]{MableAstFactory.newAIntLiteralExp((Integer)4), MableAstFactory.newAStringLiteralExp((String)(message + " %d")), status.clone()}));
    public static final Integer[] FMIWARNINGANDFATALERRORCODES = new Integer[]{3, 4};
    private static final Function<String, LexIdentifier> createLexIdentifier = s -> new LexIdentifier(s.replace("-", ""), null);
    private static StatementGeneratorContainer container = null;
    private final String statusVariable = "status";
    private final Map<Integer, LexIdentifier> realArrays = new HashMap<Integer, LexIdentifier>();
    private final Map<Integer, LexIdentifier> boolArrays = new HashMap<Integer, LexIdentifier>();
    private final Map<Integer, LexIdentifier> longArrays = new HashMap<Integer, LexIdentifier>();
    private final Map<Integer, LexIdentifier> intArrays = new HashMap<Integer, LexIdentifier>();
    private final Map<Integer, LexIdentifier> stringArrays = new HashMap<Integer, LexIdentifier>();
    private final Map<Fmi2SimulationEnvironment.Variable, LexIdentifier> convergenceRefArray = new HashMap<Fmi2SimulationEnvironment.Variable, LexIdentifier>();
    private final Map<Fmi2SimulationEnvironment.Variable, LexIdentifier> loopValueArray = new HashMap<Fmi2SimulationEnvironment.Variable, LexIdentifier>();
    private final EnumMap<Fmi2ModelDescription.Types, String> typesStringMap = new EnumMap<Fmi2ModelDescription.Types, String>(Fmi2ModelDescription.Types.class){
        {
            this.put(Fmi2ModelDescription.Types.Integer, "Integer");
            this.put(Fmi2ModelDescription.Types.String, "String");
            this.put(Fmi2ModelDescription.Types.Boolean, "Boolean");
            this.put(Fmi2ModelDescription.Types.Real, "Real");
        }
    };
    private final Map<String, Map<Long, VariableLocation>> instanceVariables = new HashMap<String, Map<Long, VariableLocation>>();
    private final Map<ModelConnection.ModelInstance, Map<Fmi2ModelDescription.ScalarVariable, AbstractMap.SimpleEntry<ModelConnection.ModelInstance, Fmi2ModelDescription.ScalarVariable>>> inputToOutputMapping = new HashMap<ModelConnection.ModelInstance, Map<Fmi2ModelDescription.ScalarVariable, AbstractMap.SimpleEntry<ModelConnection.ModelInstance, Fmi2ModelDescription.ScalarVariable>>>();
    private final IntFunction<String> booleanArrayVariableName = i -> "booleanValueSize" + i;
    private final IntFunction<String> realArrayVariableName = i -> "realValueSize" + i;
    private final IntFunction<String> intArrayVariableName = i -> "intValueSize" + i;
    private final IntFunction<String> stringArrayVariableName = i -> "stringValueSize" + i;
    public PExp startTime;
    public PExp endTime;
    public double absoluteTolerance;
    public double relativeTolerance;
    public List<ModelParameter> modelParameters;
    private boolean instancesLookupDependencies = false;

    private StatementGeneratorContainer() {
        AVariableDeclaration status = MableAstFactory.newAVariableDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)"status"), (PType)MableAstFactory.newAIntNumericPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newAIntLiteralExp((Integer)0)));
    }

    public static StatementGeneratorContainer getInstance() {
        if (container == null) {
            container = new StatementGeneratorContainer();
        }
        return container;
    }

    private static PExp statusErrorExpressions(PExp statusExpression, Integer[] errorCodes) {
        ArrayList<AEqualBinaryExp> orExpressions = new ArrayList<AEqualBinaryExp>();
        for (Integer i : errorCodes) {
            orExpressions.add(MableAstFactory.newEqual((PExp)statusExpression.clone(), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)));
        }
        PExp orExpression = MableBuilder.nestedOr(orExpressions);
        return orExpression;
    }

    private static PStm createGetSVsStatement(String instanceName, String functionName, long[] longs, LexIdentifier valueArray, LexIdentifier valRefArray, LexIdentifier statusVariable) {
        return MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)statusVariable), (PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)createLexIdentifier.apply(instanceName)), (LexIdentifier)((LexIdentifier)createLexIdentifier.apply(functionName).clone()), new ArrayList<PExpBase>(Arrays.asList(MableAstFactory.newAIdentifierExp((LexIdentifier)valRefArray), MableAstFactory.newAUIntLiteralExp((Long)Long.valueOf(longs.length)), MableAstFactory.newAIdentifierExp((LexIdentifier)valueArray)))));
    }

    public static void reset() {
        container = null;
    }

    public static PStm statusCheck(PExp status, Integer[] statusCodes, String message, boolean breakOut, boolean setGlobalExecution) {
        ArrayList<Object> thenStm = new ArrayList<Object>();
        thenStm.add(errorReporter.apply(status, message));
        if (setGlobalExecution) {
            thenStm.add(MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)"global_execution_continue")), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false)));
        }
        if (breakOut) {
            thenStm.add(MableAstFactory.newBreak());
        }
        return MableAstFactory.newIf((PExp)StatementGeneratorContainer.statusErrorExpressions(status.clone(), statusCodes), (PStm)MableAstFactory.newABlockStm(thenStm), null);
    }

    public SPrimitiveTypeBase fmiTypeToMablType(Fmi2ModelDescription.Types type) {
        switch (type) {
            case Boolean: {
                return MableAstFactory.newABoleanPrimitiveType();
            }
            case Real: {
                return MableAstFactory.newARealNumericPrimitiveType();
            }
            case Integer: {
                return MableAstFactory.newAIntNumericPrimitiveType();
            }
            case String: {
                return MableAstFactory.newAStringPrimitiveType();
            }
        }
        throw new UnsupportedOperationException("Converting fmi type: " + type + " to mabl type is not supported.");
    }

    public PStm createSetupExperimentStatement(String instanceName, boolean toleranceDefined, double tolerance, boolean stopTimeDefined) {
        return MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)"status")), (PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)createLexIdentifier.apply(instanceName)), (LexIdentifier)((LexIdentifier)createLexIdentifier.apply("setupExperiment").clone()), new ArrayList<PExp>(Arrays.asList(MableAstFactory.newABoolLiteralExp((Boolean)toleranceDefined), MableAstFactory.newARealLiteralExp((Double)tolerance), this.startTime.clone(), MableAstFactory.newABoolLiteralExp((Boolean)stopTimeDefined), this.endTime.clone()))));
    }

    public PStm exitInitializationMode(String instanceName) {
        return MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)"status")), (PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)createLexIdentifier.apply(instanceName)), (LexIdentifier)((LexIdentifier)createLexIdentifier.apply("exitInitializationMode").clone()), null));
    }

    public List<PStm> createFixedPointIteration(List<Fmi2SimulationEnvironment.Variable> loopVariables, int iterationMax, int sccNumber, Fmi2SimulationEnvironment env) throws ExpandException {
        LexIdentifier end = MableAstFactory.newAIdentifier((String)String.format("end%d", sccNumber));
        LexIdentifier start = MableAstFactory.newAIdentifier((String)String.format("start%d", sccNumber));
        Vector<PStm> statements = new Vector<PStm>();
        statements.add((PStm)MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)start, (PType)MableAstFactory.newARealNumericPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newAIntLiteralExp((Integer)0)))));
        statements.add((PStm)MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)end, (PType)MableAstFactory.newAIntNumericPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newAIntLiteralExp((Integer)iterationMax)))));
        List<Fmi2SimulationEnvironment.Variable> outputs = loopVariables.stream().filter(o -> o.scalarVariable.getScalarVariable().causality == Fmi2ModelDescription.Causality.Output && o.scalarVariable.scalarVariable.getType().type == Fmi2ModelDescription.Types.Real).collect(Collectors.toList());
        for (Fmi2SimulationEnvironment.Variable output : outputs) {
            LexIdentifier lexIdentifier = createLexIdentifier.apply("Ref" + output.scalarVariable.instance.getText() + output.scalarVariable.scalarVariable.getName() + "ValueRef" + output.scalarVariable.scalarVariable.getValueReference());
            statements.add(this.createReferenceArray(output, lexIdentifier));
            this.convergenceRefArray.put(output, lexIdentifier);
        }
        LexIdentifier doesConverge = new LexIdentifier("DoesConverge", null);
        statements.add((PStm)MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)doesConverge, (PType)MableAstFactory.newABoleanPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newABoolLiteralExp((Boolean)true)))));
        Vector<Object> loopStmts = new Vector<Object>();
        loopStmts.addAll(this.performLoopActions(loopVariables, env));
        loopStmts.addAll(this.checkLoopConvergence(outputs, doesConverge));
        loopStmts.add(MableAstFactory.newIf((PExp)MableAstFactory.newAnd((PExp)MableAstFactory.newNot((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)doesConverge)), (PExp)MableAstFactory.newEqual((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)start), (PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)end))), (PStm)MableAstFactory.newABlockStm(Arrays.asList(MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)"global_execution_continue")), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false)), MableAstFactory.newExpressionStm((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((String)"logger"), (LexIdentifier)MableAstFactory.newAIdentifier((String)"log"), Arrays.asList(MableAstFactory.newAIntLiteralExp((Integer)4), MableAstFactory.newAStringLiteralExp((String)"The initialization of the system was not possible since loop is not converging")))))), null));
        loopStmts.addAll(this.updateReferenceArray(outputs));
        loopStmts.add(MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)((LexIdentifier)start.clone())), (PExp)MableAstFactory.newPlusExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)((LexIdentifier)start.clone())), (PExp)MableAstFactory.newAIntLiteralExp((Integer)1))));
        statements.add((PStm)MableAstFactory.newWhile((PExp)MableAstFactory.newALessEqualBinaryExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)start), (PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)end)), (PStm)MableAstFactory.newABlockStm(loopStmts)));
        return statements;
    }

    private List<PStm> performLoopActions(List<Fmi2SimulationEnvironment.Variable> loopVariables, Fmi2SimulationEnvironment env) {
        Vector<PStm> LoopStatements = new Vector<PStm>();
        loopVariables.stream().forEach(variable -> {
            long[] scalarValueIndices = new long[]{variable.scalarVariable.scalarVariable.valueReference};
            if (variable.scalarVariable.scalarVariable.causality == Fmi2ModelDescription.Causality.Output) {
                LexIdentifier lexId = createLexIdentifier.apply(variable.scalarVariable.instance + variable.scalarVariable.getScalarVariable().name);
                LoopStatements.add((PStm)MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)lexId, (PType)MableAstFactory.newAArrayType((PType)this.fmiTypeToMablType(variable.scalarVariable.scalarVariable.getType().type)), (int)1, null)));
                this.loopValueArray.put((Fmi2SimulationEnvironment.Variable)variable, lexId);
                try {
                    LoopStatements.addAll(this.getValueStm(variable.scalarVariable.instance.getText(), lexId, scalarValueIndices, variable.scalarVariable.scalarVariable.getType().type));
                }
                catch (ExpandException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    LoopStatements.addAll(this.setValueOnPortStm(variable.scalarVariable.instance, variable.scalarVariable.scalarVariable.getType().type, Collections.singletonList(variable.scalarVariable.scalarVariable), scalarValueIndices, env));
                }
                catch (ExpandException e) {
                    e.printStackTrace();
                }
            }
        });
        return LoopStatements;
    }

    public List<PStm> setValueOnPortStm(LexIdentifier comp, Fmi2ModelDescription.Types type, List<Fmi2ModelDescription.ScalarVariable> variables, long[] scalarValueIndices, Fmi2SimulationEnvironment env) throws ExpandException {
        ComponentInfo componentInfo = (ComponentInfo)env.getUnitInfo(comp, Framework.FMI2);
        ModelConnection.ModelInstance modelInstances = new ModelConnection.ModelInstance(componentInfo.fmuIdentifier, comp.getText());
        if (type == Fmi2ModelDescription.Types.Boolean) {
            return this.setBooleansStm(comp.getText(), scalarValueIndices, Arrays.stream(this.getValues(variables, modelInstances)).map(Boolean.class::cast).collect(BooleanUtils.TO_BOOLEAN_ARRAY));
        }
        if (type == Fmi2ModelDescription.Types.Real) {
            return this.setRealsStm(comp.getText(), scalarValueIndices, Arrays.stream(this.getValues(variables, modelInstances)).mapToDouble(o -> Double.parseDouble(o.toString())).toArray());
        }
        if (type == Fmi2ModelDescription.Types.Integer) {
            return this.setIntegersStm(comp.getText(), scalarValueIndices, Arrays.stream(this.getValues(variables, modelInstances)).mapToInt(o -> Integer.parseInt(o.toString())).toArray());
        }
        if (type == Fmi2ModelDescription.Types.String) {
            return this.setStringsStm(comp.getText(), scalarValueIndices, (String[])Arrays.stream(this.getValues(variables, modelInstances)).map(o -> o.toString()).toArray(String[]::new));
        }
        throw new ExpandException("Unrecognised type: " + type.name());
    }

    private PStm createReferenceArray(Fmi2SimulationEnvironment.Variable variable, LexIdentifier lexID) throws ExpandException {
        ArrayList<PExp> args = new ArrayList<PExp>();
        args.add(this.getDefaultArrayValue(variable.scalarVariable.scalarVariable.getType().type));
        AArrayInitializer initializer = MableAstFactory.newAArrayInitializer(args);
        return MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)lexID, (PType)MableAstFactory.newAArrayType((PType)this.fmiTypeToMablType(variable.scalarVariable.scalarVariable.getType().type)), (int)1, (PInitializer)initializer));
    }

    private List<PStm> updateReferenceArray(List<Fmi2SimulationEnvironment.Variable> outputPorts) {
        Vector<PStm> updateStmts = new Vector<PStm>();
        outputPorts.forEach(o -> {
            LexIdentifier referenceValue = this.convergenceRefArray.get(o);
            LexIdentifier currentValue = this.loopValueArray.get(o);
        });
        return updateStmts;
    }

    private List<PStm> checkLoopConvergence(List<Fmi2SimulationEnvironment.Variable> outputPorts, LexIdentifier doesConverge) {
        LexIdentifier index = MableAstFactory.newAIdentifier((String)"index");
        Vector<PStm> result = new Vector<PStm>();
        result.add((PStm)MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)index, (PType)MableAstFactory.newAIntNumericPrimitiveType(), (PInitializer)MableAstFactory.newAExpInitializer((PExp)MableAstFactory.newAIntLiteralExp((Integer)0)))));
        outputPorts.forEach(o -> {
            Vector<Object> convergenceLoop = new Vector<Object>();
            LexIdentifier referenceValue = this.convergenceRefArray.get(o);
            LexIdentifier currentValue = this.loopValueArray.get(o);
            AIntLiteralExp arraySize = MableAstFactory.newAIntLiteralExp((Integer)0);
            convergenceLoop.add(MableAstFactory.newIf((PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)createLexIdentifier.apply("Math")), (LexIdentifier)((LexIdentifier)createLexIdentifier.apply("isClose").clone()), new ArrayList<PExpBase>(Arrays.asList(MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)currentValue), Collections.singletonList(MableAstFactory.newAIdentifierExp((LexIdentifier)index))), MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)referenceValue), Collections.singletonList(MableAstFactory.newAIdentifierExp((LexIdentifier)index))), MableAstFactory.newARealLiteralExp((Double)this.absoluteTolerance), MableAstFactory.newARealLiteralExp((Double)this.relativeTolerance)))), null, (PStm)MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)((LexIdentifier)doesConverge.clone())), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false))));
            convergenceLoop.add(MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)((LexIdentifier)index.clone())), (PExp)MableAstFactory.newPlusExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)((LexIdentifier)index.clone())), (PExp)MableAstFactory.newAIntLiteralExp((Integer)1))));
            result.add((PStm)MableAstFactory.newWhile((PExp)MableAstFactory.newAnd((PExp)MableAstFactory.newALessEqualBinaryExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)index), (PExp)arraySize), (PExp)MableAstFactory.newNot((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)doesConverge))), (PStm)MableAstFactory.newABlockStm(convergenceLoop)));
        });
        result.add((PStm)MableAstFactory.newIf((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)doesConverge), (PStm)MableAstFactory.newBreak(), null));
        return result;
    }

    public PStm enterInitializationMode(String instanceName) {
        return MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)"status")), (PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)createLexIdentifier.apply(instanceName)), (LexIdentifier)((LexIdentifier)createLexIdentifier.apply("enterInitializationMode").clone()), null));
    }

    private PStm generateAssignmentStm(String instanceName, long[] longs, LexIdentifier valueArray, LexIdentifier valRefs, String setCommand) {
        return MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)"status")), (PExp)MableAstFactory.newACallExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)createLexIdentifier.apply(instanceName)), (LexIdentifier)((LexIdentifier)createLexIdentifier.apply(setCommand).clone()), new ArrayList<PExpBase>(Arrays.asList(MableAstFactory.newAIdentifierExp((LexIdentifier)valRefs), MableAstFactory.newAUIntLiteralExp((Long)Long.valueOf(longs.length)), MableAstFactory.newAIdentifierExp((LexIdentifier)valueArray)))));
    }

    private Pair<LexIdentifier, List<PStm>> createArray(int valueLength, IntFunction<Pair<PExp, List<PStm>>> valueLocator, String arrayName, Fmi2ModelDescription.Types type, Map<Integer, LexIdentifier> array) {
        Vector<ALocalVariableStm> statements = new Vector<ALocalVariableStm>();
        ArrayList<PExp> args = new ArrayList<PExp>();
        for (int i = 0; i < valueLength; ++i) {
            Pair<PExp, List<PStm>> value = valueLocator.apply(i);
            args.add((PExp)value.getLeft());
            if (value.getRight() == null) continue;
            statements.addAll((Collection)value.getRight());
        }
        AArrayInitializer initializer = MableAstFactory.newAArrayInitializer(args);
        AArrayType arType = MableAstFactory.newAArrayType((PType)this.fmiTypeToMablType(type));
        LexIdentifier lexID = createLexIdentifier.apply(arrayName);
        ALocalVariableStm stm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)lexID, (PType)arType, (int)args.size(), (PInitializer)initializer));
        statements.add(stm);
        array.put(args.size(), lexID);
        return Pair.of((Object)lexID, statements);
    }

    private List<PStm> assignValueToArray(int valueLength, IntFunction<Pair<PExp, List<PStm>>> valueLocator, LexIdentifier valueArray) {
        Vector<PStm> statements = new Vector<PStm>();
        for (int i = 0; i < valueLength; ++i) {
            Pair<PExp, List<PStm>> value = valueLocator.apply(i);
            if (value.getRight() != null) {
                statements.addAll((Collection)value.getRight());
            }
            AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)valueArray), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExp)((PExp)value.getLeft()));
            statements.add((PStm)stm);
        }
        return statements;
    }

    public void setInputOutputMapping(Map<ModelConnection.ModelInstance, Map<Fmi2ModelDescription.ScalarVariable, AbstractMap.SimpleEntry<ModelConnection.ModelInstance, Fmi2ModelDescription.ScalarVariable>>> inputOutputMapping) {
        inputOutputMapping.forEach(this.inputToOutputMapping::put);
    }

    private Pair<LexIdentifier, List<PStm>> findOrCreateValueReferenceArrayAndAssign(long[] valRefs) {
        LexIdentifier arrayName = this.findArrayOfSize(this.longArrays, valRefs.length);
        Vector<Object> statement = new Vector<Object>();
        if (arrayName != null) {
            for (int i = 0; i < valRefs.length; ++i) {
                AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAArayStateDesignator((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)arrayName), (PExp)MableAstFactory.newAIntLiteralExp((Integer)i)), (PExp)MableAstFactory.newAUIntLiteralExp((Long)valRefs[i]));
                statement.add(stm);
            }
        } else {
            arrayName = createLexIdentifier.apply("valRefsSize" + valRefs.length);
            AArrayType arType = MableAstFactory.newAArrayType((PType)MableAstFactory.newAUIntNumericPrimitiveType());
            ALocalVariableStm stm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)arrayName, (PType)arType, (int)valRefs.length, (PInitializer)MableAstFactory.newAArrayInitializer(Arrays.stream(valRefs).mapToObj(valRef -> MableAstFactory.newAUIntLiteralExp((Long)valRef)).collect(Collectors.toList()))));
            this.longArrays.put(valRefs.length, arrayName);
            statement.add(stm);
        }
        return Pair.of((Object)arrayName, statement);
    }

    private LexIdentifier findArrayOfSize(Map<Integer, LexIdentifier> arrays, int i) {
        return arrays.getOrDefault(i, null);
    }

    private List<PStm> updateInstanceVariables(String instanceName, long[] longs, LexIdentifier valueArray, Fmi2ModelDescription.Types fmiType) {
        Map instanceVariables = this.instanceVariables.computeIfAbsent(instanceName, k -> new HashMap());
        Vector<PStm> result = new Vector<PStm>();
        for (int i = 0; i < longs.length; ++i) {
            VariableLocation svVar = (VariableLocation)instanceVariables.get(longs[i]);
            AArrayIndexExp assignmentExpression = MableAstFactory.newAArrayIndexExp((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)valueArray), Collections.singletonList(MableAstFactory.newAUIntLiteralExp((Long)Long.valueOf(i))));
            if (svVar == null) {
                String id = instanceName + "SvValRef" + longs[i];
                ALocalVariableStm stm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)createLexIdentifier.apply(id), (PType)this.fmiTypeToMablType(fmiType), (PInitializer)MableAstFactory.newAExpInitializer((PExp)assignmentExpression)));
                result.add((PStm)stm);
                VariableLocation varLoc = new VariableLocation(id, fmiType);
                instanceVariables.put(longs[i], varLoc);
                continue;
            }
            AAssigmentStm stm = MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)createLexIdentifier.apply(svVar.variableId)), (PExp)assignmentExpression);
            result.add((PStm)stm);
        }
        return result;
    }

    public IntFunction<Pair<PExp, List<PStm>>> generateInstanceVariablesValueLocator(String instanceName, long[] valRefs, IntFunction<PExp> literalExp, Fmi2ModelDescription.Types targetType) {
        IntFunction<Pair<PExp, List<PStm>>> valueLocator = null;
        if (this.instancesLookupDependencies) {
            Optional<ModelConnection.ModelInstance> key = this.inputToOutputMapping.keySet().stream().filter(x -> x.instanceName.equals(instanceName)).findFirst();
            if (key.isPresent()) {
                Map<Fmi2ModelDescription.ScalarVariable, AbstractMap.SimpleEntry<ModelConnection.ModelInstance, Fmi2ModelDescription.ScalarVariable>> svInputsToOutputs = this.inputToOutputMapping.get(key.get());
                valueLocator = i -> {
                    Optional<Fmi2ModelDescription.ScalarVariable> svInputVarToOutput = svInputsToOutputs.keySet().stream().filter(x -> x.valueReference == valRefs[i]).findFirst();
                    if (svInputVarToOutput.isPresent()) {
                        AbstractMap.SimpleEntry output = (AbstractMap.SimpleEntry)svInputsToOutputs.get(svInputVarToOutput.get());
                        VariableLocation variable = this.instanceVariables.get(((ModelConnection.ModelInstance)output.getKey()).instanceName).get(((Fmi2ModelDescription.ScalarVariable)output.getValue()).valueReference);
                        LexIdentifier variableLexId = createLexIdentifier.apply(variable.variableId);
                        ArrayList<Object> statements = null;
                        if (((Fmi2ModelDescription.ScalarVariable)output.getValue()).type.type != targetType) {
                            statements = new ArrayList<Object>();
                            Object name = null;
                            if (variable.typeMapping.containsKey(targetType)) {
                                name = variable.typeMapping.get(targetType);
                            } else {
                                name = instanceName + "SvValRef" + valRefs[i] + targetType;
                                variable.typeMapping.put(targetType, (String)name);
                                ALocalVariableStm stm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)new LexIdentifier((String)name, null), (PType)this.fmiTypeToMablType(targetType)));
                                statements.add(stm);
                            }
                            statements.add(MableAstFactory.newExpressionStm((PExp)MableAstFactory.newACallExp((LexToken)MableAstFactory.newExpandToken(), (PExp)MableAstFactory.newAIdentifierExp((String)"TypeConverter"), (LexIdentifier)MableAstFactory.newAIdentifier((String)("convert" + this.typesStringMap.get(((Fmi2ModelDescription.ScalarVariable)output.getValue()).type.type) + "2" + this.typesStringMap.get(targetType))), new ArrayList<AIdentifierExp>(List.of(MableAstFactory.newAIdentifierExp((String)variable.variableId), MableAstFactory.newAIdentifierExp((String)name))))));
                            variableLexId = createLexIdentifier.apply((String)name);
                        }
                        return Pair.of((Object)MableAstFactory.newAIdentifierExp((LexIdentifier)variableLexId), statements);
                    }
                    return Pair.of((Object)MableAstFactory.newAIdentifierExp((LexIdentifier)createLexIdentifier.apply("Failed to find the variable with valref " + valRefs[i] + " for instance: " + ((ModelConnection.ModelInstance)key.get()).instanceName)), null);
                };
            }
        } else {
            valueLocator = i -> Pair.of((Object)((PExp)literalExp.apply(i)), null);
        }
        return valueLocator;
    }

    public List<PStm> setRealsStm(String instanceName, long[] longs, double[] doubles) {
        IntFunction<Pair<PExp, List<PStm>>> valueLocator = this.generateInstanceVariablesValueLocator(instanceName, longs, i -> MableAstFactory.newARealLiteralExp((Double)doubles[i]), Fmi2ModelDescription.Types.Real);
        Vector<PStm> statements = new Vector<PStm>();
        LexIdentifier valueArray = this.findArrayOfSize(this.realArrays, longs.length);
        if (valueArray == null) {
            Pair<LexIdentifier, List<PStm>> value = this.createArray(doubles.length, valueLocator, this.realArrayVariableName.apply(longs.length), Fmi2ModelDescription.Types.Real, this.realArrays);
            valueArray = (LexIdentifier)value.getLeft();
            statements.addAll((Collection)value.getRight());
        } else {
            statements.addAll(this.assignValueToArray(doubles.length, valueLocator, valueArray));
        }
        Pair<LexIdentifier, List<PStm>> valRefs = this.findOrCreateValueReferenceArrayAndAssign(longs);
        statements.addAll((Collection)valRefs.getRight());
        statements.addAll(this.generateAssignmentStmForSet(instanceName, longs, valueArray, (LexIdentifier)valRefs.getLeft(), "setReal"));
        return statements;
    }

    public List<PStm> setBooleansStm(String instanceName, long[] longs, boolean[] booleans) {
        IntFunction<Pair<PExp, List<PStm>>> valueLocator = this.generateInstanceVariablesValueLocator(instanceName, longs, i -> MableAstFactory.newABoolLiteralExp((Boolean)booleans[i]), Fmi2ModelDescription.Types.Boolean);
        Vector<PStm> statements = new Vector<PStm>();
        LexIdentifier valueArray = this.findArrayOfSize(this.boolArrays, booleans.length);
        if (valueArray == null) {
            Pair<LexIdentifier, List<PStm>> value = this.createArray(booleans.length, valueLocator, this.booleanArrayVariableName.apply(longs.length), Fmi2ModelDescription.Types.Boolean, this.boolArrays);
            valueArray = (LexIdentifier)value.getLeft();
            statements.addAll((Collection)value.getRight());
        } else {
            statements.addAll(this.assignValueToArray(booleans.length, valueLocator, valueArray));
        }
        Pair<LexIdentifier, List<PStm>> valRefs = this.findOrCreateValueReferenceArrayAndAssign(longs);
        statements.addAll((Collection)valRefs.getRight());
        statements.addAll(this.generateAssignmentStmForSet(instanceName, longs, valueArray, (LexIdentifier)valRefs.getLeft(), "setBoolean"));
        return statements;
    }

    public List<PStm> setIntegersStm(String instanceName, long[] longs, int[] ints) {
        IntFunction<Pair<PExp, List<PStm>>> valueLocator = this.generateInstanceVariablesValueLocator(instanceName, longs, i -> MableAstFactory.newAIntLiteralExp((Integer)ints[i]), Fmi2ModelDescription.Types.Integer);
        Vector<PStm> statements = new Vector<PStm>();
        LexIdentifier valueArray = this.findArrayOfSize(this.intArrays, longs.length);
        if (valueArray == null) {
            Pair<LexIdentifier, List<PStm>> value = this.createArray(ints.length, valueLocator, this.intArrayVariableName.apply(longs.length), Fmi2ModelDescription.Types.Integer, this.intArrays);
            valueArray = (LexIdentifier)value.getLeft();
            statements.addAll((Collection)value.getRight());
        } else {
            statements.addAll(this.assignValueToArray(ints.length, valueLocator, valueArray));
        }
        Pair<LexIdentifier, List<PStm>> valRefs = this.findOrCreateValueReferenceArrayAndAssign(longs);
        statements.addAll((Collection)valRefs.getRight());
        statements.addAll(this.generateAssignmentStmForSet(instanceName, longs, valueArray, (LexIdentifier)valRefs.getLeft(), "setInteger"));
        return statements;
    }

    public List<PStm> setStringsStm(String instanceName, long[] longs, String[] strings) {
        IntFunction<Pair<PExp, List<PStm>>> valueLocator = this.generateInstanceVariablesValueLocator(instanceName, longs, i -> MableAstFactory.newAStringLiteralExp((String)strings[i]), Fmi2ModelDescription.Types.String);
        Vector<PStm> statements = new Vector<PStm>();
        LexIdentifier valueArray = this.findArrayOfSize(this.stringArrays, strings.length);
        if (valueArray == null) {
            Pair<LexIdentifier, List<PStm>> value = this.createArray(strings.length, valueLocator, this.stringArrayVariableName.apply(longs.length), Fmi2ModelDescription.Types.String, this.stringArrays);
            valueArray = (LexIdentifier)value.getLeft();
            statements.addAll((Collection)value.getRight());
        } else {
            statements.addAll(this.assignValueToArray(strings.length, valueLocator, valueArray));
        }
        Pair<LexIdentifier, List<PStm>> valRefs = this.findOrCreateValueReferenceArrayAndAssign(longs);
        statements.addAll((Collection)valRefs.getRight());
        statements.addAll(this.generateAssignmentStmForSet(instanceName, longs, valueArray, (LexIdentifier)valRefs.getLeft(), "setString"));
        return statements;
    }

    public List<PStm> generateAssignmentStmForSet(String instanceName, long[] longs, LexIdentifier valueArray, LexIdentifier valRefs, String setCommand) {
        ArrayList<PStm> pstms = new ArrayList<PStm>();
        pstms.add(this.generateAssignmentStm(instanceName, longs, valueArray, valRefs, setCommand));
        pstms.add(StatementGeneratorContainer.statusCheck((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)MableAstFactory.newAIdentifier((String)"status")), FMIWARNINGANDFATALERRORCODES, "set failed", true, true));
        return pstms;
    }

    public PStm generateIfConditionForSetGet() {
        PExp orExp = StatementGeneratorContainer.statusErrorExpressions((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)MableAstFactory.newAIdentifier((String)"status")), FMIWARNINGANDFATALERRORCODES);
        return MableAstFactory.newIf((PExp)orExp, (PStm)MableAstFactory.newABlockStm((PStm[])new PStm[]{MableAstFactory.newAAssignmentStm((PStateDesignator)MableAstFactory.newAIdentifierStateDesignator((LexIdentifier)MableAstFactory.newAIdentifier((String)"global_execution_continue")), (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false)), new AErrorStm()}), null);
    }

    public Object[] getValues(List<Fmi2ModelDescription.ScalarVariable> variables, ModelConnection.ModelInstance modelInstance) {
        Object[] values = new Object[variables.size()];
        int i = 0;
        for (Fmi2ModelDescription.ScalarVariable v : variables) {
            values[i++] = this.getNewValue(v, modelInstance);
        }
        return values;
    }

    private Object getNewValue(Fmi2ModelDescription.ScalarVariable sv, ModelConnection.ModelInstance comp) {
        Object newVal = null;
        if (sv.type.start != null) {
            newVal = sv.type.start;
        }
        for (ModelParameter par : this.modelParameters) {
            if (!par.variable.toString().equals(comp + "." + sv.name)) continue;
            newVal = par.value;
            par.isSet = true;
        }
        if (sv.type.type == Fmi2ModelDescription.Types.Real && newVal instanceof Integer) {
            newVal = (double)((Integer)newVal).intValue();
        }
        return newVal;
    }

    public List<PStm> getValueStm(String instanceName, LexIdentifier valueArray, long[] longs, Fmi2ModelDescription.Types type) throws ExpandException {
        if (!this.instancesLookupDependencies) {
            this.instancesLookupDependencies = true;
        }
        Vector<PStm> result = new Vector<PStm>();
        if (valueArray == null) {
            valueArray = this.findArrayOfSize(this.getArrayMapOfType(type), longs.length);
        }
        if (valueArray == null) {
            AArrayType arType = MableAstFactory.newAArrayType((PType)this.fmiTypeToMablType(type));
            valueArray = createLexIdentifier.apply(type.name() + "ValueSize" + longs.length);
            ALocalVariableStm stm = MableAstFactory.newALocalVariableStm((AVariableDeclaration)MableAstFactory.newAVariableDeclaration((LexIdentifier)valueArray, (PType)arType, (int)longs.length, null));
            result.add((PStm)stm);
            this.getArrayMapOfType(type).put(longs.length, valueArray);
        }
        Pair<LexIdentifier, List<PStm>> valRefs = this.findOrCreateValueReferenceArrayAndAssign(longs);
        result.addAll((Collection)valRefs.getRight());
        result.addAll(Arrays.asList(StatementGeneratorContainer.createGetSVsStatement(instanceName, "get" + type.name(), longs, valueArray, (LexIdentifier)valRefs.getLeft(), MableAstFactory.newAIdentifier((String)"status")), StatementGeneratorContainer.statusCheck((PExp)MableAstFactory.newAIdentifierExp((LexIdentifier)MableAstFactory.newAIdentifier((String)"status")), FMIWARNINGANDFATALERRORCODES, "get failed", true, true)));
        result.addAll(this.updateInstanceVariables(instanceName, longs, (LexIdentifier)valueArray.clone(), type));
        return result;
    }

    public Object test() {
        return null;
    }

    private PExp getDefaultArrayValue(Fmi2ModelDescription.Types type) throws ExpandException {
        if (type == Fmi2ModelDescription.Types.Boolean) {
            return MableAstFactory.newABoolLiteralExp((Boolean)false);
        }
        if (type == Fmi2ModelDescription.Types.Real) {
            return MableAstFactory.newARealLiteralExp((Double)0.0);
        }
        if (type == Fmi2ModelDescription.Types.Integer) {
            return MableAstFactory.newAIntLiteralExp((Integer)0);
        }
        throw new ExpandException("Unknown type");
    }

    private Map<Integer, LexIdentifier> getArrayMapOfType(Fmi2ModelDescription.Types type) throws ExpandException {
        if (type == Fmi2ModelDescription.Types.Boolean) {
            return this.boolArrays;
        }
        if (type == Fmi2ModelDescription.Types.Real) {
            return this.realArrays;
        }
        if (type == Fmi2ModelDescription.Types.Integer) {
            return this.intArrays;
        }
        if (type == Fmi2ModelDescription.Types.String) {
            return this.stringArrays;
        }
        throw new ExpandException("Unrecognised type: " + type.name());
    }
}

