/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin.initializer;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.RelationVariable;
import org.intocps.maestro.plugin.ExpandException;
import org.intocps.maestro.plugin.initializer.RelationsPredicates;
import org.intocps.topologicalsorting.TarjanGraph;
import org.intocps.topologicalsorting.data.AcyclicDependencyResult;
import org.intocps.topologicalsorting.data.CyclicDependencyResult;
import org.intocps.topologicalsorting.data.DependencyResult;
import org.intocps.topologicalsorting.data.Edge11;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.collection.Seq;

public class TopologicalPlugin {
    public List<RelationVariable> findInstantiationOrder(Set<Fmi2SimulationEnvironment.Relation> relations, Set<LexIdentifier> filterTargets) throws ExpandException {
        TarjanGraph graphSolver = this.getTarjanGraph(relations, filterTargets);
        DependencyResult topologicalOrderToInstantiate = graphSolver.topologicalSort();
        if (topologicalOrderToInstantiate instanceof CyclicDependencyResult) {
            CyclicDependencyResult cycles = (CyclicDependencyResult)topologicalOrderToInstantiate;
            throw new ExpandException("Cycles are present in the systems: " + cycles.cycle());
        }
        return (List)JavaConverters.seqAsJavaListConverter((Seq)((AcyclicDependencyResult)topologicalOrderToInstantiate).totalOrder()).asJava();
    }

    public List<Set<RelationVariable>> findInstantiationOrderStrongComponents(Set<Fmi2SimulationEnvironment.Relation> relations, Set<LexIdentifier> filterTargets) {
        TarjanGraph graphSolver = this.getTarjanGraph(relations, filterTargets);
        scala.collection.immutable.Map topologicalOrderToInstantiate = graphSolver.topologicalSCC();
        java.util.Map javaMap = (java.util.Map)JavaConverters.mapAsJavaMapConverter((Map)topologicalOrderToInstantiate).asJava();
        return this.groupSCC(javaMap);
    }

    private List<Set<RelationVariable>> groupSCC(java.util.Map<RelationVariable, Integer> javaMap) {
        Vector<Set<RelationVariable>> sccs = new Vector<Set<RelationVariable>>();
        java.util.Map<Integer, List<Map.Entry>> list = javaMap.entrySet().stream().collect(Collectors.groupingBy(o -> (Integer)o.getValue()));
        javaMap.values().stream().sorted().forEach(scc -> {
            HashSet variablesSet = new HashSet();
            ((List)list.get(scc)).forEach(v -> variablesSet.add((RelationVariable)v.getKey()));
            sccs.add(variablesSet);
        });
        return sccs;
    }

    private TarjanGraph getTarjanGraph(Set<Fmi2SimulationEnvironment.Relation> relations, Set<LexIdentifier> filterTargets) {
        List<Fmi2SimulationEnvironment.Relation> externalRelations = relations.stream().filter(RelationsPredicates.external()).collect(Collectors.toList());
        List<Fmi2SimulationEnvironment.Relation> internalRelations = relations.stream().filter(RelationsPredicates.internal()).collect(Collectors.toList());
        internalRelations = internalRelations.stream().filter(RelationsPredicates.inputSource().or(RelationsPredicates.outputSource().and(o -> externalRelations.stream().anyMatch(i -> o.getSource() == i.getSource())))).collect(Collectors.toList());
        Vector edges = new Vector();
        externalRelations.forEach(o -> o.getTargets().values().forEach(e -> {
            if (filterTargets != null && filterTargets.contains(e.getInstance())) {
                return;
            }
            edges.add(new Edge11((Object)o.getSource(), e, (Object)o.getOrigin()));
        }));
        internalRelations.forEach(o -> o.getTargets().values().forEach(e -> edges.add(new Edge11(e, (Object)o.getSource(), (Object)o.getOrigin()))));
        return new TarjanGraph((Iterable)JavaConverters.iterableAsScalaIterableConverter(edges).asScala());
    }
}

