/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.StringEscapeUtils;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.AModuleDeclaration;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.core.dto.StepAlgorithm;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.fmi.Fmi2ModelDescription;
import org.intocps.maestro.framework.core.ISimulationEnvironment;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.api.Fmi2Builder;
import org.intocps.maestro.framework.fmi2.api.mabl.BooleanBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.DataWriter;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.MathBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.RealTime;
import org.intocps.maestro.framework.fmi2.api.mabl.VariableStep;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IfMaBlScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.WhileMaBLScope;
import org.intocps.maestro.framework.fmi2.api.mabl.values.DoubleExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.values.IntExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ArrayVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.IntVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.StringVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.intocps.maestro.plugin.BasicMaestroExpansionPlugin;
import org.intocps.maestro.plugin.ExpandException;
import org.intocps.maestro.plugin.IMaestroExpansionPlugin;
import org.intocps.maestro.plugin.IPluginConfiguration;
import org.intocps.maestro.plugin.JacobianStepConfig;
import org.intocps.maestro.plugin.SimulationFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SimulationFramework(framework=Framework.FMI2)
public class JacobianStepBuilder
extends BasicMaestroExpansionPlugin {
    static final Logger logger = LoggerFactory.getLogger(JacobianStepBuilder.class);
    final AFunctionDeclaration fixedStepFunc = MableAstFactory.newAFunctionDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)"fixedStepSize"), Arrays.asList(MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newANameType((String)"FMI2Component")), (LexIdentifier)MableAstFactory.newAIdentifier((String)"component")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newARealNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"stepSize")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newARealNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"startTime")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newARealNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"endTime"))), (PType)MableAstFactory.newAVoidType());
    final AFunctionDeclaration variableStepFunc = MableAstFactory.newAFunctionDeclaration((LexIdentifier)MableAstFactory.newAIdentifier((String)"variableStepSize"), Arrays.asList(MableAstFactory.newAFormalParameter((PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newANameType((String)"FMI2Component")), (LexIdentifier)MableAstFactory.newAIdentifier((String)"component")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newARealNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"initSize")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newARealNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"startTime")), MableAstFactory.newAFormalParameter((PType)MableAstFactory.newARealNumericPrimitiveType(), (LexIdentifier)MableAstFactory.newAIdentifier((String)"endTime"))), (PType)MableAstFactory.newAVoidType());
    private final List<String> imports = Stream.of("FMI2", "TypeConverter", "Math", "Logger", "DataWriter", "ArrayUtil", "BooleanLogic").collect(Collectors.toList());
    private StepAlgorithm algorithm;

    public Set<AFunctionDeclaration> getDeclaredUnfoldFunctions() {
        return Stream.of(this.fixedStepFunc, this.variableStepFunc).collect(Collectors.toSet());
    }

    public <R> IMaestroExpansionPlugin.RuntimeConfigAddition<R> expandWithRuntimeAddition(AFunctionDeclaration declaredFunction, Fmi2Builder<PStm, ASimulationSpecificationCompilationUnit, PExp, ?> builder1, List<Fmi2Builder.Variable<PStm, ?>> formalArguments, IPluginConfiguration config, ISimulationEnvironment envIn, IErrorReporter errorReporter) throws ExpandException {
        AFunctionDeclaration selectedFun;
        JacobianStepConfig jacobianStepConfig;
        logger.info("Unfolding with jacobian step: {}", (Object)declaredFunction.toString());
        JacobianStepConfig jacobianStepConfig2 = jacobianStepConfig = config != null ? (JacobianStepConfig)config : new JacobianStepConfig();
        if (!this.getDeclaredUnfoldFunctions().contains(declaredFunction)) {
            throw new ExpandException("Unknown function declaration");
        }
        if (envIn == null) {
            throw new ExpandException("Simulation environment must not be null");
        }
        if (declaredFunction.getName().toString().equals("variableStepSize")) {
            this.algorithm = StepAlgorithm.VARIABLESTEP;
            selectedFun = this.variableStepFunc;
            this.imports.add("VariableStep");
        } else {
            this.algorithm = StepAlgorithm.FIXEDSTEP;
            selectedFun = this.fixedStepFunc;
        }
        if (formalArguments == null || formalArguments.size() != selectedFun.getFormals().size()) {
            throw new ExpandException("Invalid args");
        }
        if (jacobianStepConfig.simulationProgramDelay) {
            this.imports.add("RealTime");
        }
        Fmi2SimulationEnvironment env = (Fmi2SimulationEnvironment)envIn;
        boolean setGetDerivativesRestore = false;
        MablApiBuilder.MablSettings settings = null;
        try {
            if (builder1.getSettings() instanceof MablApiBuilder.MablSettings) {
                settings = (MablApiBuilder.MablSettings)builder1.getSettings();
                setGetDerivativesRestore = settings.setGetDerivatives;
                settings.setGetDerivatives = jacobianStepConfig.setGetDerivatives;
            }
            if (!(builder1 instanceof MablApiBuilder)) {
                throw new ExpandException("Not supporting the given builder type. Expecting " + MablApiBuilder.class.getSimpleName() + " got " + builder1.getClass().getSimpleName());
            }
            MablApiBuilder builder = (MablApiBuilder)builder1;
            DynamicActiveBuilderScope dynamicScope = builder.getDynamicScope();
            MathBuilderFmi2Api math = builder.getMablToMablAPI().getMathBuilder();
            BooleanBuilderFmi2Api booleanLogic = builder.getBooleanBuilder();
            RealTime realTimeModule = null;
            if (jacobianStepConfig.simulationProgramDelay) {
                realTimeModule = builder.getRealTimeModule();
            }
            DoubleVariableFmi2Api externalStepSize = (DoubleVariableFmi2Api)formalArguments.get(1);
            DoubleVariableFmi2Api currentStepSize = dynamicScope.store("jac_current_step_size", 0.0);
            currentStepSize.setValue((Fmi2Builder.Variable)externalStepSize);
            DoubleVariableFmi2Api stepSize = dynamicScope.store("jac_step_size", 0.0);
            stepSize.setValue((Fmi2Builder.Variable)externalStepSize);
            DoubleVariableFmi2Api externalStartTime = (DoubleVariableFmi2Api)formalArguments.get(2);
            DoubleVariableFmi2Api currentCommunicationTime = dynamicScope.store("jac_current_communication_point", 0.0);
            currentCommunicationTime.setValue((Fmi2Builder.Variable)externalStartTime);
            DoubleVariableFmi2Api externalEndTime = (DoubleVariableFmi2Api)formalArguments.get(3);
            DoubleVariableFmi2Api endTime = dynamicScope.store("jac_end_time", 0.0);
            endTime.setValue((Fmi2Builder.Variable)externalEndTime);
            Map fmuInstances = ((Fmi2Builder.ArrayVariable)formalArguments.get(0)).items().stream().collect(Collectors.toMap(v -> v.getName(), Function.identity(), (u, v) -> u, LinkedHashMap::new));
            DataWriter dataWriter = builder.getDataWriter();
            DataWriter.DataWriterInstance dataWriterInstance = dataWriter.createDataWriterInstance();
            dataWriterInstance.initialize(fmuInstances.values().stream().flatMap(x -> x.getVariablesToLog().stream()).collect(Collectors.toList()));
            PredicateFmi2Api loopPredicate = currentCommunicationTime.toMath().addition((Fmi2Builder.NumericTypedReferenceExp)currentStepSize).lessThan((Fmi2Builder.NumericTypedReferenceExp)endTime);
            HashMap portsToGet = new HashMap();
            fmuInstances.forEach((x, y) -> {
                List variablesToLog = env.getVariablesToLog(x);
                Set scalarVariablesToShare = y.getPorts().stream().filter(p -> jacobianStepConfig.getVariablesOfInterest().stream().anyMatch(p1 -> p1.equals(p.getMultiModelScalarVariableName()))).map(PortFmi2Api::getName).collect(Collectors.toSet());
                scalarVariablesToShare.addAll(variablesToLog.stream().map(var -> var.scalarVariable.getName()).collect(Collectors.toSet()));
                Map portsToShare = y.get((String[])scalarVariablesToShare.toArray(String[]::new));
                List portsOfInterest = portsToShare.keySet().stream().filter(objectVariableFmi2Api -> objectVariableFmi2Api.scalarVariable.causality == Fmi2ModelDescription.Causality.Output || objectVariableFmi2Api.scalarVariable.causality == Fmi2ModelDescription.Causality.Input).map(PortFmi2Api::getName).collect(Collectors.toList());
                portsToGet.put(y, portsOfInterest);
                y.share(portsToShare);
            });
            LinkedHashMap<StringVariableFmi2Api, ComponentVariableFmi2Api> fmuNamesToInstances = new LinkedHashMap<StringVariableFmi2Api, ComponentVariableFmi2Api>();
            LinkedHashMap<ComponentVariableFmi2Api, VariableFmi2Api> fmuInstancesToVariablesInArray = new LinkedHashMap<ComponentVariableFmi2Api, VariableFmi2Api>();
            ArrayVariableFmi2Api fmuCommunicationPoints = dynamicScope.store("fmu_communicationpoints", (Object[])new Double[fmuInstances.entrySet().size()]);
            ArrayList<String> fmusThatSupportsGetState = new ArrayList<String>();
            boolean everyFMUSupportsGetState = true;
            int indexer = 0;
            for (Map.Entry entry2 : fmuInstances.entrySet()) {
                StringVariableFmi2Api fullyQualifiedFMUInstanceName = new StringVariableFmi2Api(null, null, null, null, (PExp)MableAstFactory.newAStringLiteralExp((String)(env.getInstanceByLexName(((ComponentVariableFmi2Api)entry2.getValue()).getEnvironmentName()).getFmuIdentifier() + "." + ((ComponentVariableFmi2Api)entry2.getValue()).getName())));
                fmuNamesToInstances.put(fullyQualifiedFMUInstanceName, (ComponentVariableFmi2Api)entry2.getValue());
                fmuInstancesToVariablesInArray.put((ComponentVariableFmi2Api)entry2.getValue(), (VariableFmi2Api)fmuCommunicationPoints.items().get(indexer));
                boolean supportsGetState = ((ComponentVariableFmi2Api)entry2.getValue()).getModelDescription().getCanGetAndSetFmustate();
                if (supportsGetState) {
                    fmusThatSupportsGetState.add((String)entry2.getKey());
                }
                everyFMUSupportsGetState = supportsGetState && everyFMUSupportsGetState;
                ++indexer;
            }
            if (!everyFMUSupportsGetState && jacobianStepConfig.stabilisation) {
                throw new RuntimeException("Cannot use stabilisation as not every FMU supports rollback");
            }
            BooleanVariableFmi2Api allFMUsSupportGetState = dynamicScope.store("all_fmus_support_get_state", everyFMUSupportsGetState);
            VariableStep.VariableStepInstance variableStepInstance = null;
            if (this.algorithm == StepAlgorithm.VARIABLESTEP) {
                List ports = fmuInstances.values().stream().map(ComponentVariableFmi2Api::getPorts).flatMap(Collection::stream).filter(p -> jacobianStepConfig.getVariablesOfInterest().stream().anyMatch(p1 -> p1.equals(p.getMultiModelScalarVariableName()))).collect(Collectors.toList());
                VariableStep variableStep = builder.getVariableStep(dynamicScope.store("variable_step_config", StringEscapeUtils.escapeJava((String)new ObjectMapper().writeValueAsString((Object)jacobianStepConfig.stepAlgorithm))));
                variableStepInstance = variableStep.createVariableStepInstanceInstance();
                variableStepInstance.initialize(fmuNamesToInstances, ports, endTime);
            }
            ArrayList<Fmi2Builder.StateVariable> fmuStates = new ArrayList<Fmi2Builder.StateVariable>();
            BooleanVariableFmi2Api anyDiscards = dynamicScope.store("any_discards", false);
            dataWriterInstance.log(currentCommunicationTime);
            WhileMaBLScope stabilisationScope = null;
            IntVariableFmi2Api stabilisation_loop = null;
            BooleanVariableFmi2Api convergenceReached = null;
            DoubleVariableFmi2Api absTol = null;
            DoubleVariableFmi2Api relTol = null;
            IntVariableFmi2Api stabilisation_loop_max_iterations = null;
            if (jacobianStepConfig.stabilisation) {
                absTol = dynamicScope.store("absolute_tolerance", jacobianStepConfig.absoluteTolerance);
                relTol = dynamicScope.store("relative_tolerance", jacobianStepConfig.relativeTolerance);
                stabilisation_loop_max_iterations = dynamicScope.store("stabilisation_loop_max_iterations", jacobianStepConfig.stabilisationLoopMaxIterations);
                stabilisation_loop = dynamicScope.store("stabilisation_loop", stabilisation_loop_max_iterations);
                convergenceReached = dynamicScope.store("has_converged", false);
            }
            DoubleVariableFmi2Api realStartTime = null;
            if (jacobianStepConfig.simulationProgramDelay) {
                realStartTime = dynamicScope.store("real_start_time", 0.0);
                realStartTime.setValue((Fmi2Builder.Variable)Objects.requireNonNull(realTimeModule).getRealTime());
            }
            WhileMaBLScope scopeFmi2Api = dynamicScope.enterWhile((Fmi2Builder.Predicate)loopPredicate);
            if (everyFMUSupportsGetState) {
                for (Map.Entry entry3 : fmuInstances.entrySet()) {
                    fmuStates.add(((ComponentVariableFmi2Api)entry3.getValue()).getState());
                }
            }
            if (jacobianStepConfig.stabilisation) {
                stabilisation_loop.setValue(stabilisation_loop_max_iterations);
                convergenceReached.setValue((Fmi2Builder.Variable)new BooleanVariableFmi2Api(null, null, (Fmi2Builder.DynamicActiveScope)dynamicScope, null, (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false)));
                stabilisationScope = dynamicScope.enterWhile((Fmi2Builder.Predicate)convergenceReached.toPredicate().not().and(stabilisation_loop.toMath().greaterThan((Fmi2Builder.NumericTypedReferenceExp)IntExpressionValue.of((int)0))));
            }
            fmuInstances.forEach((x, y) -> {
                if (y.getPorts().stream().anyMatch(p -> p.getSourcePort() != null)) {
                    y.setLinked();
                }
            });
            if (this.algorithm == StepAlgorithm.VARIABLESTEP) {
                DoubleVariableFmi2Api variableStepSize = dynamicScope.store("variable_step_size", 0.0);
                dynamicScope.enterIf((Fmi2Builder.Predicate)anyDiscards.toPredicate().not());
                variableStepSize.setValue((Fmi2Builder.Variable)variableStepInstance.getStepSize(currentCommunicationTime));
                currentStepSize.setValue((Fmi2Builder.Variable)variableStepSize);
                stepSize.setValue((Fmi2Builder.Variable)variableStepSize);
                dynamicScope.leave();
            }
            anyDiscards.setValue((Fmi2Builder.Variable)new BooleanVariableFmi2Api(null, null, (Fmi2Builder.DynamicActiveScope)dynamicScope, null, (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false)));
            fmuInstancesToVariablesInArray.forEach((k, v) -> {
                Map.Entry discard = k.step((Fmi2Builder.DoubleVariable)currentCommunicationTime, (Fmi2Builder.DoubleVariable)currentStepSize);
                v.setValue((Fmi2Builder.ExpressionValue)new DoubleExpressionValue(((Fmi2Builder.DoubleVariable)discard.getValue()).getExp()));
                PredicateFmi2Api didDiscard = new PredicateFmi2Api(((Fmi2Builder.BoolVariable)discard.getKey()).getExp()).not();
                dynamicScope.enterIf((Fmi2Builder.Predicate)didDiscard);
                builder.getLogger().debug("## FMU: '%s' DISCARDED step at sim-time: %f for step-size: %f and proposed sim-time: %.15f", new Object[]{k.getName(), currentCommunicationTime, currentStepSize, new VariableFmi2Api(null, ((Fmi2Builder.DoubleVariable)discard.getValue()).getType(), (IMablScope)dynamicScope, (Fmi2Builder.DynamicActiveScope)dynamicScope, null, ((Fmi2Builder.DoubleVariable)discard.getValue()).getExp())});
                anyDiscards.setValue((Fmi2Builder.Variable)new BooleanVariableFmi2Api(null, null, (Fmi2Builder.DynamicActiveScope)dynamicScope, null, anyDiscards.toPredicate().or(didDiscard).getExp()));
                dynamicScope.leave();
            });
            Map<ComponentVariableFmi2Api, Map> portsToShare = portsToGet.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ComponentVariableFmi2Api)entry.getKey()).get((String[])((List)entry.getValue()).toArray(String[]::new))));
            if (jacobianStepConfig.stabilisation) {
                ArrayList convergenceVariables = new ArrayList();
                for (Map.Entry<ComponentVariableFmi2Api, Map> compToPortAndVariable : portsToShare.entrySet()) {
                    ArrayList<BooleanVariableFmi2Api> converged = new ArrayList<BooleanVariableFmi2Api>();
                    List entries = compToPortAndVariable.getValue().entrySet().stream().filter(x -> ((PortFmi2Api)x.getKey()).scalarVariable.type.type == Fmi2ModelDescription.Types.Real).collect(Collectors.toList());
                    for (Map.Entry entry4 : entries) {
                        VariableFmi2Api oldVariable = ((PortFmi2Api)entry4.getKey()).getSharedAsVariable();
                        VariableFmi2Api newVariable = (VariableFmi2Api)entry4.getValue();
                        BooleanVariableFmi2Api isClose = dynamicScope.store("isClose", false);
                        isClose.setValue((Fmi2Builder.Variable)math.checkConvergence((Fmi2Builder.ProvidesTypedReferenceExp)oldVariable, (Fmi2Builder.ProvidesTypedReferenceExp)newVariable, (Fmi2Builder.DoubleVariable)absTol, (Fmi2Builder.DoubleVariable)relTol));
                        dynamicScope.enterIf((Fmi2Builder.Predicate)isClose.toPredicate().not());
                        builder.getLogger().debug("Unstable signal %s = %.15E at time: %.15E", new Object[]{((PortFmi2Api)entry4.getKey()).getMultiModelScalarVariableName(), entry4.getValue(), currentCommunicationTime});
                        dynamicScope.leave();
                        converged.add(isClose);
                    }
                    convergenceVariables.addAll(converged);
                }
                if (convergenceReached == null) {
                    throw new RuntimeException("NO STABILISATION LOOP FOUND");
                }
                convergenceReached.setValue((Fmi2Builder.Variable)booleanLogic.allTrue("convergence", convergenceVariables));
                dynamicScope.enterIf((Fmi2Builder.Predicate)convergenceReached.toPredicate().not()).enterThen();
                fmuStates.forEach(Fmi2Builder.StateVariable::set);
                stabilisation_loop.decrement();
                dynamicScope.leave();
                portsToShare.forEach(ComponentVariableFmi2Api::share);
                stabilisationScope.leave();
            }
            if (!jacobianStepConfig.stabilisation) {
                portsToShare.forEach(ComponentVariableFmi2Api::share);
            }
            if (everyFMUSupportsGetState) {
                IfMaBlScope discardScope = dynamicScope.enterIf((Fmi2Builder.Predicate)anyDiscards.toPredicate());
                fmuStates.forEach(Fmi2Builder.StateVariable::set);
                currentStepSize.setValue((Fmi2Builder.DoubleExpressionValue)math.minRealFromArray(fmuCommunicationPoints).toMath().subtraction((Fmi2Builder.NumericTypedReferenceExp)currentCommunicationTime));
                builder.getLogger().debug("## Discard occurred! FMUs are rolled back and step-size reduced to: %f", new Object[]{currentStepSize});
                dynamicScope.leave();
                discardScope.enterElse();
            }
            BooleanVariableFmi2Api hasReducedStepSize = null;
            if (this.algorithm == StepAlgorithm.VARIABLESTEP) {
                PredicateFmi2Api notValidStepPred = Objects.requireNonNull(variableStepInstance).validateStepSize(new DoubleVariableFmi2Api(null, null, (Fmi2Builder.DynamicActiveScope)dynamicScope, null, currentCommunicationTime.toMath().addition((Fmi2Builder.NumericTypedReferenceExp)currentStepSize).getExp()), allFMUsSupportGetState).toPredicate().not();
                hasReducedStepSize = new BooleanVariableFmi2Api(null, null, (Fmi2Builder.DynamicActiveScope)dynamicScope, null, Objects.requireNonNull(variableStepInstance).hasReducedStepsize().getReferenceExp());
                dynamicScope.enterIf((Fmi2Builder.Predicate)notValidStepPred);
                IfMaBlScope reducedStepSizeScope = dynamicScope.enterIf((Fmi2Builder.Predicate)hasReducedStepSize.toPredicate());
                fmuStates.forEach(Fmi2Builder.StateVariable::set);
                currentStepSize.setValue((Fmi2Builder.Variable)Objects.requireNonNull(variableStepInstance).getReducedStepSize());
                builder.getLogger().debug("## Invalid variable step-size! FMUs are rolled back and step-size reduced to: %f", new Object[]{currentStepSize});
                anyDiscards.setValue((Fmi2Builder.Variable)new BooleanVariableFmi2Api(null, null, (Fmi2Builder.DynamicActiveScope)dynamicScope, null, anyDiscards.toPredicate().not().getExp()));
                dynamicScope.leave();
                reducedStepSizeScope.enterElse();
                builder.getLogger().debug("## The step could not be validated by the constraint at time %f. Continue nevertheless with next simulation step!", new Object[]{currentCommunicationTime});
                dynamicScope.leave();
                dynamicScope.leave();
            }
            if (jacobianStepConfig.simulationProgramDelay) {
                DoubleVariableFmi2Api realStepTime = dynamicScope.store("real_step_time", 0.0);
                realStepTime.setValue((Fmi2Builder.DoubleExpressionValue)new DoubleExpressionValue(realTimeModule.getRealTime().toMath().subtraction((Fmi2Builder.NumericTypedReferenceExp)realStartTime.toMath()).getExp()));
                dynamicScope.enterIf((Fmi2Builder.Predicate)realStepTime.toMath().lessThan((Fmi2Builder.NumericTypedReferenceExp)currentCommunicationTime.toMath().multiply(1000)));
                DoubleVariableFmi2Api sleepTime = dynamicScope.store("sleep_time", 0.0);
                sleepTime.setValue((Fmi2Builder.DoubleExpressionValue)currentCommunicationTime.toMath().multiply(1000).subtraction((Fmi2Builder.NumericTypedReferenceExp)realStepTime));
                builder.getLogger().debug("## Simulation is ahead of real time. Sleeping for: %f MS", new Object[]{sleepTime});
                realTimeModule.sleep(sleepTime);
                dynamicScope.leave();
            }
            if (everyFMUSupportsGetState) {
                dynamicScope.leave();
            }
            dynamicScope.enterIf((Fmi2Builder.Predicate)anyDiscards.toPredicate().not());
            currentCommunicationTime.setValue((Fmi2Builder.DoubleExpressionValue)currentCommunicationTime.toMath().addition((Fmi2Builder.NumericTypedReferenceExp)currentStepSize));
            dataWriterInstance.log(currentCommunicationTime);
            currentStepSize.setValue((Fmi2Builder.Variable)stepSize);
            scopeFmi2Api.leave();
            dataWriterInstance.close();
            if (settings != null) {
                settings.setGetDerivatives = setGetDerivativesRestore;
            }
        }
        catch (Exception e) {
            throw new ExpandException("Internal error: ", (Throwable)e);
        }
        return new IMaestroExpansionPlugin.EmptyRuntimeConfig();
    }

    public IMaestroExpansionPlugin.ConfigOption getConfigRequirement() {
        return IMaestroExpansionPlugin.ConfigOption.Optional;
    }

    public IPluginConfiguration parseConfig(InputStream is) throws IOException {
        return (IPluginConfiguration)new ObjectMapper().readValue(is, JacobianStepConfig.class);
    }

    public AImportedModuleCompilationUnit getDeclaredImportUnit() {
        AImportedModuleCompilationUnit unit = new AImportedModuleCompilationUnit();
        unit.setImports(this.imports.stream().map(MableAstFactory::newAIdentifier).collect(Collectors.toList()));
        AModuleDeclaration module = new AModuleDeclaration();
        module.setName(MableAstFactory.newAIdentifier((String)this.getName()));
        module.setFunctions(new ArrayList<AFunctionDeclaration>(this.getDeclaredUnfoldFunctions()));
        unit.setModule(module);
        return unit;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getVersion() {
        return "0.1.1";
    }
}

