/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import java.util.HashMap;
import java.util.Map;
import org.intocps.maestro.ast.LexIdentifier;
import org.intocps.maestro.ast.analysis.AnalysisException;
import org.intocps.maestro.ast.analysis.DepthFirstAnalysisAdaptor;
import org.intocps.maestro.ast.analysis.intf.IAnalysis;
import org.intocps.maestro.ast.node.AFieldExp;
import org.intocps.maestro.ast.node.AIdentifierExp;
import org.intocps.maestro.ast.node.INode;
import org.intocps.maestro.ast.node.PExp;

class IdentifierReplacer {
    IdentifierReplacer() {
    }

    public static PExp replaceIdentifier(PExp tree, final String oldIdentifier, final String newIdentifier) {
        return IdentifierReplacer.replaceIdentifier(tree, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put(oldIdentifier, newIdentifier);
            }
        });
    }

    public static PExp replaceIdentifier(PExp tree, Map<String, String> old2New) {
        try {
            tree.apply((IAnalysis)new IdentifierReplace(old2New));
        }
        catch (AnalysisException e) {
            throw new RuntimeException(e);
        }
        return tree;
    }

    public static PExp replaceFields(PExp tree, Map<String, PExp> old2New) {
        try {
            tree.apply((IAnalysis)new FieldExpReplace(old2New));
        }
        catch (AnalysisException e) {
            throw new RuntimeException(e);
        }
        return tree;
    }

    static class FieldExpReplace
    extends DepthFirstAnalysisAdaptor {
        final Map<String, PExp> old2New;

        public FieldExpReplace(Map<String, PExp> old2New) {
            this.old2New = old2New;
        }

        public void caseAFieldExp(AFieldExp node) throws AnalysisException {
            for (Map.Entry<String, PExp> replacing : this.old2New.entrySet()) {
                String[] parts = replacing.getKey().split("\\.");
                if (!(node.getRoot() instanceof AIdentifierExp) || !((AIdentifierExp)node.getRoot()).getName().getText().equals(parts[0]) || !node.getField().getText().equals(parts[1])) continue;
                node.parent().replaceChild((INode)node, (INode)replacing.getValue().clone());
            }
        }
    }

    static class IdentifierReplace
    extends DepthFirstAnalysisAdaptor {
        final Map<String, String> old2New;

        public IdentifierReplace(Map<String, String> old2New) {
            this.old2New = old2New;
        }

        public void caseAIdentifierExp(AIdentifierExp node) throws AnalysisException {
            for (Map.Entry<String, String> replacing : this.old2New.entrySet()) {
                if (!node.getName().getText().equals(replacing.getKey())) continue;
                node.parent().replaceChild((INode)node, (INode)new AIdentifierExp(new LexIdentifier(replacing.getValue(), null)));
            }
        }
    }
}

