/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.AModuleDeclaration;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.AErrorStm;
import org.intocps.maestro.ast.node.AImportedModuleCompilationUnit;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.core.dto.StepAlgorithm;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.core.FrameworkUnitInfo;
import org.intocps.maestro.framework.core.ISimulationEnvironment;
import org.intocps.maestro.framework.core.RelationVariable;
import org.intocps.maestro.framework.fmi2.ComponentInfo;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.BooleanBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.DataWriter;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.MathBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.SimulationControl;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IfMaBlScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.ScopeFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.WhileMaBLScope;
import org.intocps.maestro.framework.fmi2.api.mabl.values.DoubleExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ArrayVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.StringVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.intocps.maestro.plugin.BasicMaestroExpansionPlugin;
import org.intocps.maestro.plugin.ExpandException;
import org.intocps.maestro.plugin.IMaestroExpansionPlugin;
import org.intocps.maestro.plugin.IPluginConfiguration;
import org.intocps.maestro.plugin.IndexedFunctionDeclarationContainer;
import org.intocps.maestro.plugin.JacobianInternalBuilder;
import org.intocps.maestro.plugin.JacobianStepConfig;
import org.intocps.maestro.plugin.JacobianVariableStepBuilder;
import org.intocps.maestro.plugin.ModelSwapBuilder;
import org.intocps.maestro.plugin.RealTimeSlowDownBuilder;
import org.intocps.maestro.plugin.SimulationFramework;
import org.intocps.maestro.plugin.StabilisationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SimulationFramework(framework=Framework.FMI2)
public class JacobianStepBuilder
extends BasicMaestroExpansionPlugin {
    protected static final Logger logger = LoggerFactory.getLogger(JacobianStepBuilder.class);
    protected final IndexedFunctionDeclarationContainer<ARG_INDEX> fixedStepFunc = IndexedFunctionDeclarationContainer.newBuilder((String)"fixedStepSize", ARG_INDEX.class).addArg((Object)ARG_INDEX.FMI2_INSTANCES, "component", (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newANameType((String)"FMI2Component"))).addArg((Object)ARG_INDEX.STEP_SIZE, "stepSize", (PType)MableAstFactory.newARealNumericPrimitiveType()).addArg((Object)ARG_INDEX.START_TIME, "startTime", (PType)MableAstFactory.newARealNumericPrimitiveType()).addArg((Object)ARG_INDEX.END_TIME, "endTime", (PType)MableAstFactory.newARealNumericPrimitiveType()).addArg((Object)ARG_INDEX.END_TIME_DEFINED, "endTimeDefined", (PType)MableAstFactory.newBoleanType()).build();
    protected final IndexedFunctionDeclarationContainer<ARG_INDEX> fixedStepTransferFunc = IndexedFunctionDeclarationContainer.newBuilder((String)"fixedStepSizeTransfer", ARG_INDEX.class).addArg((Object)ARG_INDEX.FMI2_INSTANCES, "component", (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newANameType((String)"FMI2Component"))).addArg((Object)ARG_INDEX.STEP_SIZE, "stepSize", (PType)MableAstFactory.newARealNumericPrimitiveType()).addArg((Object)ARG_INDEX.START_TIME, "startTime", (PType)MableAstFactory.newARealNumericPrimitiveType()).addArg((Object)ARG_INDEX.END_TIME, "endTime", (PType)MableAstFactory.newARealNumericPrimitiveType()).addArg((Object)ARG_INDEX.END_TIME_DEFINED, "endTimeDefined", (PType)MableAstFactory.newBoleanType()).build();
    protected final IndexedFunctionDeclarationContainer<ARG_INDEX> variableStepFunc = IndexedFunctionDeclarationContainer.newBuilder((String)"variableStepSize", ARG_INDEX.class).addArg((Object)ARG_INDEX.FMI2_INSTANCES, "component", (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newANameType((String)"FMI2Component"))).addArg((Object)ARG_INDEX.STEP_SIZE, "initSize", (PType)MableAstFactory.newARealNumericPrimitiveType()).addArg((Object)ARG_INDEX.START_TIME, "startTime", (PType)MableAstFactory.newARealNumericPrimitiveType()).addArg((Object)ARG_INDEX.END_TIME, "endTime", (PType)MableAstFactory.newARealNumericPrimitiveType()).addArg((Object)ARG_INDEX.END_TIME_DEFINED, "endTimeDefined", (PType)MableAstFactory.newBoleanType()).build();
    protected final List<String> imports = Stream.of("FMI2", "TypeConverter", "Math", "Logger", "DataWriter", "ArrayUtil", "BooleanLogic", "SimulationControl").collect(Collectors.toList());
    static BiConsumer<PortFmi2Api, PortFmi2Api> relinkPorts = (source, target) -> {
        try {
            switch (source.scalarVariable.causality) {
                case Input: {
                    source.breakLink();
                    target.linkTo(new FmiBuilder.Port[]{source});
                    break;
                }
                case Output: {
                    target.breakLink();
                    source.linkTo(new FmiBuilder.Port[]{target});
                    break;
                }
            }
        }
        catch (FmiBuilder.Port.PortLinkException e) {
            e.printStackTrace();
        }
    };

    protected List<IndexedFunctionDeclarationContainer<ARG_INDEX>> getFunctions() {
        return Arrays.asList(this.fixedStepFunc, this.fixedStepTransferFunc, this.variableStepFunc);
    }

    public Set<AFunctionDeclaration> getDeclaredUnfoldFunctions() {
        return this.getFunctions().stream().map(IndexedFunctionDeclarationContainer::getDecl).collect(Collectors.toSet());
    }

    public <R> IMaestroExpansionPlugin.RuntimeConfigAddition<R> expandWithRuntimeAddition(AFunctionDeclaration declaredFunction, FmiBuilder<PStm, ASimulationSpecificationCompilationUnit, PExp, ?> parentBuilder, List<FmiBuilder.Variable<PStm, ?>> formalArguments, IPluginConfiguration config, ISimulationEnvironment envIn, IErrorReporter errorReporter) throws ExpandException {
        JacobianStepConfig jacobianStepConfig;
        logger.info("Unfolding with jacobian step: {}", (Object)declaredFunction.toString());
        JacobianStepConfig jacobianStepConfig2 = jacobianStepConfig = config != null ? (JacobianStepConfig)config : new JacobianStepConfig();
        if (!this.getDeclaredUnfoldFunctions().contains(declaredFunction)) {
            throw new ExpandException("Unknown function declaration");
        }
        if (envIn == null) {
            throw new ExpandException("Simulation environment must not be null");
        }
        StepAlgorithm algorithm = StepAlgorithm.FIXEDSTEP;
        IndexedFunctionDeclarationContainer selectedFun = this.getFunctions().stream().filter(f -> f.getDecl().getName().getText().equals(declaredFunction.getName().getText())).findFirst().orElse(null);
        if (selectedFun == this.variableStepFunc) {
            algorithm = StepAlgorithm.VARIABLESTEP;
            this.imports.add("VariableStep");
        } else if (selectedFun == this.fixedStepTransferFunc) {
            algorithm = StepAlgorithm.FIXEDSTEP;
            logger.debug("Activated mode transfer");
        }
        if (formalArguments == null || formalArguments.size() != selectedFun.getDecl().getFormals().size()) {
            throw new ExpandException("Invalid args");
        }
        Fmi2SimulationEnvironment env = (Fmi2SimulationEnvironment)envIn;
        boolean setGetDerivativesRestore = false;
        MablApiBuilder.MablSettings settings = null;
        try {
            if (parentBuilder.getSettings() instanceof MablApiBuilder.MablSettings) {
                settings = (MablApiBuilder.MablSettings)parentBuilder.getSettings();
                setGetDerivativesRestore = settings.setGetDerivatives;
                settings.setGetDerivatives = jacobianStepConfig.setGetDerivatives;
            }
            if (!(parentBuilder instanceof MablApiBuilder)) {
                throw new ExpandException("Not supporting the given builder type. Expecting " + MablApiBuilder.class.getSimpleName() + " got " + parentBuilder.getClass().getSimpleName());
            }
            MablApiBuilder builder = (MablApiBuilder)parentBuilder;
            DynamicActiveBuilderScope dynamicScope = builder.getDynamicScope();
            MathBuilderFmi2Api math = builder.getMablToMablAPI().getMathBuilder();
            BooleanBuilderFmi2Api booleanLogic = builder.getBooleanBuilder();
            RealTimeSlowDownBuilder.RealTimeSlowDownContext ctsCtxt = null;
            if (jacobianStepConfig.simulationProgramDelay) {
                ctsCtxt = RealTimeSlowDownBuilder.init(builder, this.imports);
            }
            JacobianInternalBuilder.BaseJacobianContext ctxt = JacobianInternalBuilder.buildBaseCtxt((IndexedFunctionDeclarationContainer<ARG_INDEX>)selectedFun, formalArguments, dynamicScope);
            Map<String, ComponentVariableFmi2Api> fmuInstances = ctxt.fmuInstances;
            DataWriter dataWriter = builder.getDataWriter();
            DataWriter.DataWriterInstance dataWriterInstance = dataWriter.createDataWriterInstance();
            dataWriterInstance.initialize(fmuInstances.values().stream().flatMap(x -> x.getVariablesToLog().stream().map(xsv -> new DataWriter.DataWriterInstance.LogEntry(xsv.getMultiModelScalarVariableName(), () -> xsv.getSharedAsVariable().getReferenceExp().clone()))).collect(Collectors.toList()));
            SimulationControl simulationControl = builder.getSimulationControl();
            PredicateFmi2Api loopPredicate = ctxt.externalEndTimeDefined.toPredicate().not().or(ctxt.currentCommunicationTime.toMath().addition((FmiBuilder.NumericTypedReferenceExp)ctxt.currentStepSize).lessThan((FmiBuilder.NumericTypedReferenceExp)ctxt.endTime));
            HashMap<ComponentVariableFmi2Api, Map<PortFmi2Api, VariableFmi2Api<Object>>> componentsToPortsWithValues = new HashMap<ComponentVariableFmi2Api, Map<PortFmi2Api, VariableFmi2Api<Object>>>();
            fmuInstances.forEach((identifier, instance) -> {
                Set scalarVariablesToGet = instance.getPorts().stream().filter(p -> jacobianStepConfig.getVariablesOfInterest().stream().anyMatch(p1 -> p1.equals(p.getMultiModelScalarVariableName()))).map(PortFmi2Api::getName).collect(Collectors.toSet());
                scalarVariablesToGet.addAll(env.getVariablesToLog(instance.getEnvironmentName()).stream().map(RelationVariable::getName).collect(Collectors.toSet()));
                componentsToPortsWithValues.put((ComponentVariableFmi2Api)instance, instance.get((String[])scalarVariablesToGet.toArray(String[]::new)));
            });
            componentsToPortsWithValues.forEach(ComponentVariableFmi2Api::share);
            LinkedHashMap<StringVariableFmi2Api, ComponentVariableFmi2Api> fmuNamesToFmuInstances = new LinkedHashMap<StringVariableFmi2Api, ComponentVariableFmi2Api>();
            LinkedHashMap<ComponentVariableFmi2Api, VariableFmi2Api> fmuInstanceToCommunicationPoint = new LinkedHashMap<ComponentVariableFmi2Api, VariableFmi2Api>();
            ArrayVariableFmi2Api fmuCommunicationPoints = dynamicScope.store("fmu_communicationpoints", (Object[])new Double[fmuInstances.entrySet().size()]);
            boolean everyFMUSupportsGetState = true;
            int indexer = 0;
            for (ComponentVariableFmi2Api instance2 : fmuInstances.values()) {
                FrameworkUnitInfo v = env.getInstanceByLexName(instance2.getEnvironmentName());
                if (!(v instanceof ComponentInfo)) {
                    throw new RuntimeException("instance is not fmi2");
                }
                StringVariableFmi2Api fullyQualifiedFMUInstanceName = new StringVariableFmi2Api(null, null, null, null, (PExp)MableAstFactory.newAStringLiteralExp((String)(((ComponentInfo)v).getFmuIdentifier() + "." + instance2.getName())));
                fmuNamesToFmuInstances.put(fullyQualifiedFMUInstanceName, instance2);
                fmuInstanceToCommunicationPoint.put(instance2, (VariableFmi2Api)fmuCommunicationPoints.items().get(indexer));
                everyFMUSupportsGetState = instance2.getModelDescription().getCanGetAndSetFmustate() && everyFMUSupportsGetState;
                ++indexer;
            }
            if (!everyFMUSupportsGetState && jacobianStepConfig.stabilisation) {
                throw new RuntimeException("Cannot use stabilisation as not every FMU supports rollback");
            }
            BooleanVariableFmi2Api allFMUsSupportGetState = dynamicScope.store("all_fmus_support_get_state", everyFMUSupportsGetState);
            JacobianVariableStepBuilder.JacobianVariableStepContext varStep = null;
            if (algorithm == StepAlgorithm.VARIABLESTEP) {
                varStep = JacobianVariableStepBuilder.init(ctxt, jacobianStepConfig, dynamicScope, builder, fmuNamesToFmuInstances);
            }
            dataWriterInstance.log(ctxt.currentCommunicationTime);
            StabilisationBuilder.StabilisationContext stabilisationCtxt = null;
            if (jacobianStepConfig.stabilisation) {
                stabilisationCtxt = StabilisationBuilder.init(dynamicScope, jacobianStepConfig);
            }
            if (jacobianStepConfig.simulationProgramDelay) {
                RealTimeSlowDownBuilder.setStartTime(ctsCtxt, dynamicScope);
            }
            ArrayList<FmiBuilder.StateVariable<PStm>> fmuStates = new ArrayList<FmiBuilder.StateVariable<PStm>>();
            BooleanVariableFmi2Api anyDiscards = dynamicScope.store("any_discards", false);
            ModelSwapBuilder.ModelSwapContext modelSwapContext = ModelSwapBuilder.buildContext(env, dynamicScope);
            WhileMaBLScope scopeFmi2Api = dynamicScope.enterWhile((FmiBuilder.Predicate)loopPredicate);
            ScopeFmi2Api stoppingThenScope = scopeFmi2Api.enterIf((FmiBuilder.Predicate)simulationControl.stopRequested().toPredicate()).enterThen();
            stoppingThenScope.add(new PStm[]{new AErrorStm((PExp)MableAstFactory.newAStringLiteralExp((String)"Simulation stopped by user"))});
            stoppingThenScope.leave();
            dynamicScope.markTransferPoint(new String[0]);
            ModelSwapBuilder.updateSwapConditionVariables(modelSwapContext, dynamicScope, componentsToPortsWithValues);
            if (everyFMUSupportsGetState) {
                for (ComponentVariableFmi2Api componentVariableFmi2Api : fmuInstances.values()) {
                    fmuStates.add(componentVariableFmi2Api.getState());
                }
            }
            if (jacobianStepConfig.stabilisation) {
                StabilisationBuilder.step(stabilisationCtxt, dynamicScope);
            }
            ModelSwapBuilder.setWithModelSwapLinking(fmuInstances, env, dynamicScope, modelSwapContext);
            if (algorithm == StepAlgorithm.VARIABLESTEP) {
                JacobianVariableStepBuilder.updateCurrentStepTiming(ctxt, varStep, dynamicScope, anyDiscards);
            }
            anyDiscards.setValue((FmiBuilder.Variable)new BooleanVariableFmi2Api(null, null, (FmiBuilder.DynamicActiveScope)dynamicScope, null, (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false)));
            fmuInstanceToCommunicationPoint.forEach((instance, communicationPoint) -> {
                DoubleVariableFmi2Api communicationTime = ctxt.currentCommunicationTime;
                Map.Entry<DoubleVariableFmi2Api, Optional<PredicateFmi2Api>> swapStep = ModelSwapBuilder.updateStep(modelSwapContext, env, instance, communicationTime);
                Optional<PredicateFmi2Api> stepPredicate = swapStep.getValue();
                communicationTime = swapStep.getKey();
                stepPredicate.ifPresent(arg_0 -> ((DynamicActiveBuilderScope)dynamicScope).enterIf(arg_0));
                Map.Entry discard = instance.step((FmiBuilder.DoubleVariable)communicationTime, (FmiBuilder.DoubleVariable)ctxt.currentStepSize);
                communicationPoint.setValue((FmiBuilder.ExpressionValue)new DoubleExpressionValue(((FmiBuilder.DoubleVariable)discard.getValue()).getExp()));
                PredicateFmi2Api didDiscard = new PredicateFmi2Api(((FmiBuilder.BoolVariable)discard.getKey()).getExp()).not();
                dynamicScope.enterIf((FmiBuilder.Predicate)didDiscard);
                builder.getLogger().debug("## FMU: '%s' DISCARDED step at sim-time: %f for step-size: %f and proposed sim-time: %.15f", new Object[]{instance.getName(), communicationTime, ctxt.currentStepSize, new VariableFmi2Api(null, ((FmiBuilder.DoubleVariable)discard.getValue()).getType(), (IMablScope)dynamicScope, (FmiBuilder.DynamicActiveScope)dynamicScope, null, ((FmiBuilder.DoubleVariable)discard.getValue()).getExp())});
                anyDiscards.setValue((FmiBuilder.Variable)new BooleanVariableFmi2Api(null, null, (FmiBuilder.DynamicActiveScope)dynamicScope, null, anyDiscards.toPredicate().or(didDiscard).getExp()));
                dynamicScope.leave();
                if (stepPredicate.isPresent()) {
                    dynamicScope.leave();
                }
            });
            for (Map.Entry entry : componentsToPortsWithValues.entrySet()) {
                Map portsToValues = (Map)entry.getValue();
                portsToValues = ((ComponentVariableFmi2Api)entry.getKey()).get((FmiBuilder.Port[])portsToValues.keySet().toArray(PortFmi2Api[]::new));
            }
            if (jacobianStepConfig.stabilisation) {
                StabilisationBuilder.convergence(dynamicScope, componentsToPortsWithValues, stabilisationCtxt, ctxt, builder, math, booleanLogic, fmuStates);
            }
            if (!jacobianStepConfig.stabilisation) {
                componentsToPortsWithValues.forEach(ComponentVariableFmi2Api::share);
            }
            if (everyFMUSupportsGetState) {
                IfMaBlScope discardScope = dynamicScope.enterIf((FmiBuilder.Predicate)anyDiscards.toPredicate());
                fmuStates.forEach(FmiBuilder.StateVariable::set);
                ctxt.currentStepSize.setValue((FmiBuilder.DoubleExpressionValue)math.minRealFromArray(fmuCommunicationPoints).toMath().subtraction((FmiBuilder.NumericTypedReferenceExp)ctxt.currentCommunicationTime));
                builder.getLogger().debug("## Discard occurred! FMUs are rolled back and step-size reduced to: %f", new Object[]{ctxt.currentStepSize});
                dynamicScope.leave();
                discardScope.enterElse();
            }
            if (algorithm == StepAlgorithm.VARIABLESTEP) {
                JacobianVariableStepBuilder.step(ctxt, varStep, dynamicScope, builder, allFMUsSupportGetState, fmuStates, anyDiscards);
            }
            if (jacobianStepConfig.simulationProgramDelay) {
                RealTimeSlowDownBuilder.slowDown(ctsCtxt, dynamicScope, ctxt, builder);
            }
            if (everyFMUSupportsGetState) {
                dynamicScope.leave();
            }
            dynamicScope.enterIf((FmiBuilder.Predicate)anyDiscards.toPredicate().not());
            ctxt.currentCommunicationTime.setValue((FmiBuilder.DoubleExpressionValue)ctxt.currentCommunicationTime.toMath().addition((FmiBuilder.NumericTypedReferenceExp)ctxt.currentStepSize));
            ModelSwapBuilder.updateDiscardStepTime(modelSwapContext, dynamicScope, ctxt.currentStepSize);
            dataWriterInstance.log(ctxt.currentCommunicationTime);
            ctxt.currentStepSize.setValue((FmiBuilder.Variable)ctxt.stepSize);
            scopeFmi2Api.leave();
            dataWriterInstance.close();
            if (settings != null) {
                settings.setGetDerivatives = setGetDerivativesRestore;
            }
        }
        catch (Exception e) {
            errorReporter.report(0, e.toString(), null);
            throw new ExpandException("Internal error: ", (Throwable)e);
        }
        return new IMaestroExpansionPlugin.EmptyRuntimeConfig();
    }

    public IMaestroExpansionPlugin.ConfigOption getConfigRequirement() {
        return IMaestroExpansionPlugin.ConfigOption.Optional;
    }

    public IPluginConfiguration parseConfig(InputStream is) throws IOException {
        return (IPluginConfiguration)new ObjectMapper().readValue(is, JacobianStepConfig.class);
    }

    public AImportedModuleCompilationUnit getDeclaredImportUnit() {
        AImportedModuleCompilationUnit unit = new AImportedModuleCompilationUnit();
        unit.setImports(this.imports.stream().map(MableAstFactory::newAIdentifier).collect(Collectors.toList()));
        AModuleDeclaration module = new AModuleDeclaration();
        module.setName(MableAstFactory.newAIdentifier((String)this.getName()));
        module.setFunctions(new ArrayList<AFunctionDeclaration>(this.getDeclaredUnfoldFunctions()));
        unit.setModule(module);
        return unit;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getVersion() {
        return "1.1.0";
    }

    protected static enum ARG_INDEX {
        FMI2_INSTANCES,
        FMI3_INSTANCES,
        START_TIME,
        STEP_SIZE,
        END_TIME,
        END_TIME_DEFINED;

    }
}

