/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.framework.core.RelationVariable;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi3Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.VariableStep;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IfMaBlScope;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.InstanceVariableFmi3Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.StringVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.intocps.maestro.plugin.JacobianInternalBuilder;
import org.intocps.maestro.plugin.JacobianStepConfig;

public class JacobianVariableStepBuilder {
    public static JacobianVariableStepContext init(JacobianInternalBuilder.BaseJacobianContext ctxt, JacobianStepConfig jacobianStepConfig, DynamicActiveBuilderScope dynamicScope, MablApiBuilder builder, Map<StringVariableFmi2Api, ComponentVariableFmi2Api> fmuNamesToFmuInstances) throws JsonProcessingException {
        JacobianVariableStepContext varCtxt = new JacobianVariableStepContext();
        List ports = ctxt.fmuInstances.values().stream().map(ComponentVariableFmi2Api::getPorts).flatMap(Collection::stream).filter(p -> jacobianStepConfig.getVariablesOfInterest().stream().anyMatch(p1 -> p1.equals(p.getMultiModelScalarVariableName()))).collect(Collectors.toList());
        varCtxt.variableStep = builder.getVariableStep(dynamicScope.store("variable_step_config", StringEscapeUtils.escapeJava((String)new ObjectMapper().writeValueAsString((Object)jacobianStepConfig.stepAlgorithm))));
        varCtxt.variableStepInstance = varCtxt.variableStep.createVariableStepInstanceInstance();
        varCtxt.variableStepInstance.initialize(fmuNamesToFmuInstances, ports, ctxt.endTime);
        return varCtxt;
    }

    public static void updateCurrentStepTiming(JacobianInternalBuilder.BaseJacobianContext ctxt, JacobianVariableStepContext varStep, DynamicActiveBuilderScope dynamicScope, BooleanVariableFmi2Api anyDiscards) {
        DoubleVariableFmi2Api variableStepSize = dynamicScope.store("variable_step_size", 0.0);
        dynamicScope.enterIf((FmiBuilder.Predicate)anyDiscards.toPredicate().not());
        variableStepSize.setValue((FmiBuilder.Variable)varStep.variableStepInstance.getStepSize(ctxt.currentCommunicationTime));
        ctxt.currentStepSize.setValue((FmiBuilder.Variable)variableStepSize);
        ctxt.stepSize.setValue((FmiBuilder.Variable)variableStepSize);
        dynamicScope.leave();
    }

    public static void step(JacobianInternalBuilder.BaseJacobianContext ctxt, JacobianVariableStepContext varStep, DynamicActiveBuilderScope dynamicScope, MablApiBuilder builder, BooleanVariableFmi2Api allFMUsSupportGetState, List<FmiBuilder.StateVariable<PStm>> fmuStates, BooleanVariableFmi2Api anyDiscards) {
        PredicateFmi2Api notValidStepPred = Objects.requireNonNull(varStep.variableStepInstance).validateStepSize(new DoubleVariableFmi2Api(null, null, (FmiBuilder.DynamicActiveScope)dynamicScope, null, ctxt.currentCommunicationTime.toMath().addition((FmiBuilder.NumericTypedReferenceExp)ctxt.currentStepSize).getExp()), allFMUsSupportGetState).toPredicate().not();
        BooleanVariableFmi2Api hasReducedStepSize = new BooleanVariableFmi2Api(null, null, (FmiBuilder.DynamicActiveScope)dynamicScope, null, Objects.requireNonNull(varStep.variableStepInstance).hasReducedStepsize().getReferenceExp());
        dynamicScope.enterIf((FmiBuilder.Predicate)notValidStepPred);
        IfMaBlScope reducedStepSizeScope = dynamicScope.enterIf((FmiBuilder.Predicate)hasReducedStepSize.toPredicate());
        fmuStates.forEach(FmiBuilder.StateVariable::set);
        ctxt.currentStepSize.setValue((FmiBuilder.Variable)Objects.requireNonNull(varStep.variableStepInstance).getReducedStepSize());
        builder.getLogger().debug("## Invalid variable step-size! FMUs are rolled back and step-size reduced to: %f", new Object[]{ctxt.currentStepSize});
        anyDiscards.setValue((FmiBuilder.Variable)new BooleanVariableFmi2Api(null, null, (FmiBuilder.DynamicActiveScope)dynamicScope, null, anyDiscards.toPredicate().not().getExp()));
        dynamicScope.leave();
        reducedStepSizeScope.enterElse();
        builder.getLogger().debug("## The step could not be validated by the constraint at time %f. Continue nevertheless with next simulation step!", new Object[]{ctxt.currentCommunicationTime});
        dynamicScope.leave();
        dynamicScope.leave();
    }

    static Map<InstanceVariableFmi3Api, Map<PortFmi3Api, VariableFmi2Api<Object>>> getAllInstancePortsWithOutputOrLog(Map<String, InstanceVariableFmi3Api> fmuInstances3, JacobianStepConfig jacobianStepConfig, Fmi2SimulationEnvironment env) {
        HashMap<InstanceVariableFmi3Api, Map<PortFmi3Api, VariableFmi2Api<Object>>> instancesToPortsWithValues = new HashMap<InstanceVariableFmi3Api, Map<PortFmi3Api, VariableFmi2Api<Object>>>();
        fmuInstances3.forEach((identifier, instance) -> {
            Set scalarVariablesToGet = instance.getPorts().stream().filter(p -> jacobianStepConfig.getVariablesOfInterest().stream().anyMatch(p1 -> p1.equals(p.getMultiModelScalarVariableName()))).map(PortFmi3Api::getName).collect(Collectors.toSet());
            scalarVariablesToGet.addAll(env.getVariablesToLog(instance.getEnvironmentName()).stream().map(RelationVariable::getName).collect(Collectors.toSet()));
            instancesToPortsWithValues.put((InstanceVariableFmi3Api)instance, instance.get((String[])scalarVariablesToGet.toArray(String[]::new)));
        });
        return instancesToPortsWithValues;
    }

    static Map<ComponentVariableFmi2Api, Map<PortFmi2Api, VariableFmi2Api<Object>>> getAllComponentPortsWithOutputOrLog(Map<String, ComponentVariableFmi2Api> fmuInstances, JacobianStepConfig jacobianStepConfig, Fmi2SimulationEnvironment env) {
        HashMap<ComponentVariableFmi2Api, Map<PortFmi2Api, VariableFmi2Api<Object>>> componentsToPortsWithValues = new HashMap<ComponentVariableFmi2Api, Map<PortFmi2Api, VariableFmi2Api<Object>>>();
        fmuInstances.forEach((identifier, instance) -> {
            Set scalarVariablesToGet = instance.getPorts().stream().filter(p -> jacobianStepConfig.getVariablesOfInterest().stream().anyMatch(p1 -> p1.equals(p.getMultiModelScalarVariableName()))).map(PortFmi2Api::getName).collect(Collectors.toSet());
            scalarVariablesToGet.addAll(env.getVariablesToLog(instance.getEnvironmentName()).stream().map(RelationVariable::getName).collect(Collectors.toSet()));
            componentsToPortsWithValues.put((ComponentVariableFmi2Api)instance, instance.get((String[])scalarVariablesToGet.toArray(String[]::new)));
        });
        return componentsToPortsWithValues;
    }

    public static class JacobianVariableStepContext {
        VariableStep variableStep;
        VariableStep.VariableStepInstance variableStepInstance = null;
    }
}

