/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.xpath.XPathExpressionException;
import org.intocps.maestro.ast.AFunctionDeclaration;
import org.intocps.maestro.ast.MableAstFactory;
import org.intocps.maestro.ast.node.ABoolLiteralExp;
import org.intocps.maestro.ast.node.AErrorStm;
import org.intocps.maestro.ast.node.ASimulationSpecificationCompilationUnit;
import org.intocps.maestro.ast.node.PExp;
import org.intocps.maestro.ast.node.PStm;
import org.intocps.maestro.ast.node.PType;
import org.intocps.maestro.core.Framework;
import org.intocps.maestro.core.dto.StepAlgorithm;
import org.intocps.maestro.core.messages.IErrorReporter;
import org.intocps.maestro.framework.core.FrameworkUnitInfo;
import org.intocps.maestro.framework.core.ISimulationEnvironment;
import org.intocps.maestro.framework.fmi2.ComponentInfo;
import org.intocps.maestro.framework.fmi2.Fmi2SimulationEnvironment;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.BooleanBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.DataWriter;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.MathBuilderFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PortFmi3Api;
import org.intocps.maestro.framework.fmi2.api.mabl.PredicateFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.SimulationControl;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IMablScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.IfMaBlScope;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.ScopeFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.WhileMaBLScope;
import org.intocps.maestro.framework.fmi2.api.mabl.values.DoubleExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ArrayVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.BooleanVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.ComponentVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.InstanceVariableFmi3Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.StringVariableFmi2Api;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.VariableFmi2Api;
import org.intocps.maestro.plugin.ExpandException;
import org.intocps.maestro.plugin.IMaestroExpansionPlugin;
import org.intocps.maestro.plugin.IPluginConfiguration;
import org.intocps.maestro.plugin.IndexedFunctionDeclarationContainer;
import org.intocps.maestro.plugin.JacobianInternalBuilder;
import org.intocps.maestro.plugin.JacobianStepBuilder;
import org.intocps.maestro.plugin.JacobianStepConfig;
import org.intocps.maestro.plugin.JacobianVariableStepBuilder;
import org.intocps.maestro.plugin.ModelSwapBuilder;
import org.intocps.maestro.plugin.RealTimeSlowDownBuilder;
import org.intocps.maestro.plugin.SimulationFramework;
import org.intocps.maestro.plugin.StabilisationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SimulationFramework(framework=Framework.FMI2)
public class JacobianStepBuilder3
extends JacobianStepBuilder {
    static final Logger logger = LoggerFactory.getLogger(JacobianStepBuilder3.class);
    final IndexedFunctionDeclarationContainer<JacobianStepBuilder.ARG_INDEX> fixedStep3Func = IndexedFunctionDeclarationContainer.newBuilder((String)"fixedStep3Size", JacobianStepBuilder.ARG_INDEX.class).addArg((Object)JacobianStepBuilder.ARG_INDEX.FMI2_INSTANCES, "component", (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newANameType((String)"FMI2Component"))).addArg((Object)JacobianStepBuilder.ARG_INDEX.FMI3_INSTANCES, "component", (PType)MableAstFactory.newAArrayType((PType)MableAstFactory.newANameType((String)"FMI3Instance"))).addArg((Object)JacobianStepBuilder.ARG_INDEX.STEP_SIZE, "stepSize", (PType)MableAstFactory.newARealNumericPrimitiveType()).addArg((Object)JacobianStepBuilder.ARG_INDEX.START_TIME, "startTime", (PType)MableAstFactory.newARealNumericPrimitiveType()).addArg((Object)JacobianStepBuilder.ARG_INDEX.END_TIME, "endTime", (PType)MableAstFactory.newARealNumericPrimitiveType()).addArg((Object)JacobianStepBuilder.ARG_INDEX.END_TIME_DEFINED, "endTimeDefined", (PType)MableAstFactory.newBoleanType()).build();

    public JacobianStepBuilder3() {
        this.imports.add("FMI3");
    }

    @Override
    protected List<IndexedFunctionDeclarationContainer<JacobianStepBuilder.ARG_INDEX>> getFunctions() {
        return Collections.singletonList(this.fixedStep3Func);
    }

    @Override
    public <R> IMaestroExpansionPlugin.RuntimeConfigAddition<R> expandWithRuntimeAddition(AFunctionDeclaration declaredFunction, FmiBuilder<PStm, ASimulationSpecificationCompilationUnit, PExp, ?> parentBuilder, List<FmiBuilder.Variable<PStm, ?>> formalArguments, IPluginConfiguration config, ISimulationEnvironment envIn, IErrorReporter errorReporter) throws ExpandException {
        JacobianStepConfig jacobianStepConfig;
        logger.info("Unfolding with jacobian step: {}", (Object)declaredFunction.toString());
        JacobianStepConfig jacobianStepConfig2 = jacobianStepConfig = config != null ? (JacobianStepConfig)config : new JacobianStepConfig();
        if (!this.getDeclaredUnfoldFunctions().contains(declaredFunction)) {
            throw new ExpandException("Unknown function declaration");
        }
        if (envIn == null) {
            throw new ExpandException("Simulation environment must not be null");
        }
        IndexedFunctionDeclarationContainer selectedFun = this.getFunctions().stream().filter(f -> f.getDecl().getName().getText().equals(declaredFunction.getName().getText())).findFirst().orElse(null);
        StepAlgorithm algorithm = StepAlgorithm.FIXEDSTEP;
        if (selectedFun == this.variableStepFunc) {
            algorithm = StepAlgorithm.VARIABLESTEP;
            this.imports.add("VariableStep");
        } else if (selectedFun == this.fixedStepTransferFunc) {
            algorithm = StepAlgorithm.FIXEDSTEP;
            logger.debug("Activated mode transfer");
        }
        if (formalArguments == null || formalArguments.size() != selectedFun.getDecl().getFormals().size()) {
            throw new ExpandException("Invalid args");
        }
        Fmi2SimulationEnvironment env = (Fmi2SimulationEnvironment)envIn;
        boolean setGetDerivativesRestore = false;
        MablApiBuilder.MablSettings settings = null;
        try {
            Map portsToValues;
            boolean everyFMUSupportsGetState;
            if (parentBuilder.getSettings() instanceof MablApiBuilder.MablSettings) {
                settings = (MablApiBuilder.MablSettings)parentBuilder.getSettings();
                setGetDerivativesRestore = settings.setGetDerivatives;
                settings.setGetDerivatives = jacobianStepConfig.setGetDerivatives;
            }
            if (!(parentBuilder instanceof MablApiBuilder)) {
                throw new ExpandException("Not supporting the given builder type. Expecting " + MablApiBuilder.class.getSimpleName() + " got " + parentBuilder.getClass().getSimpleName());
            }
            MablApiBuilder builder = (MablApiBuilder)parentBuilder;
            DynamicActiveBuilderScope dynamicScope = builder.getDynamicScope();
            MathBuilderFmi2Api math = builder.getMablToMablAPI().getMathBuilder();
            BooleanBuilderFmi2Api booleanLogic = builder.getBooleanBuilder();
            RealTimeSlowDownBuilder.RealTimeSlowDownContext ctsCtxt = null;
            if (jacobianStepConfig.simulationProgramDelay) {
                ctsCtxt = RealTimeSlowDownBuilder.init(builder, this.imports);
            }
            JacobianInternalBuilder.BaseJacobianContext ctxt = JacobianInternalBuilder.buildBaseCtxt((IndexedFunctionDeclarationContainer<JacobianStepBuilder.ARG_INDEX>)selectedFun, formalArguments, dynamicScope);
            Map<String, ComponentVariableFmi2Api> fmuInstances = ctxt.fmuInstances;
            Map fmuInstances3 = ((FmiBuilder.ArrayVariable)selectedFun.getArgumentValue(formalArguments, (Object)JacobianStepBuilder.ARG_INDEX.FMI3_INSTANCES)).items().stream().collect(Collectors.toMap(InstanceVariableFmi3Api::getName, Function.identity(), (u, v) -> u, LinkedHashMap::new));
            DataWriter dataWriter = builder.getDataWriter();
            DataWriter.DataWriterInstance dataWriterInstance = dataWriter.createDataWriterInstance();
            dataWriterInstance.initialize(Stream.concat(fmuInstances.values().stream().flatMap(x -> x.getVariablesToLog().stream().map(xsv -> new DataWriter.DataWriterInstance.LogEntry(xsv.getMultiModelScalarVariableName(), () -> xsv.getSharedAsVariable().getReferenceExp().clone()))), fmuInstances3.values().stream().flatMap(x -> x.getVariablesToLog().stream().map(xsv -> new DataWriter.DataWriterInstance.LogEntry(xsv.getMultiModelScalarVariableName(), () -> xsv.getSharedAsVariable().getReferenceExp().clone())))).collect(Collectors.toList()));
            SimulationControl simulationControl = builder.getSimulationControl();
            PredicateFmi2Api loopPredicate = ctxt.externalEndTimeDefined.toPredicate().not().or(ctxt.currentCommunicationTime.toMath().addition((FmiBuilder.NumericTypedReferenceExp)ctxt.currentStepSize).lessThan((FmiBuilder.NumericTypedReferenceExp)ctxt.endTime));
            Map<ComponentVariableFmi2Api, Map<PortFmi2Api, VariableFmi2Api<Object>>> componentsToPortsWithValues = JacobianVariableStepBuilder.getAllComponentPortsWithOutputOrLog(fmuInstances, jacobianStepConfig, env);
            Map<InstanceVariableFmi3Api, Map<PortFmi3Api, VariableFmi2Api<Object>>> instancesToPortsWithValues = JacobianVariableStepBuilder.getAllInstancePortsWithOutputOrLog(fmuInstances3, jacobianStepConfig, env);
            componentsToPortsWithValues.forEach(ComponentVariableFmi2Api::share);
            instancesToPortsWithValues.forEach(InstanceVariableFmi3Api::share);
            LinkedHashMap<StringVariableFmi2Api, ComponentVariableFmi2Api> fmuNamesToFmuInstances = new LinkedHashMap<StringVariableFmi2Api, ComponentVariableFmi2Api>();
            ArrayVariableFmi2Api fmuCommunicationPoints = dynamicScope.store("fmu_communicationpoints", (Object[])new Double[fmuInstances.entrySet().size() + fmuInstances3.entrySet().size()]);
            for (ComponentVariableFmi2Api instance2 : fmuInstances.values()) {
                FrameworkUnitInfo v2 = env.getInstanceByLexName(instance2.getEnvironmentName());
                if (v2 instanceof ComponentInfo) {
                    StringVariableFmi2Api fullyQualifiedFMUInstanceName = new StringVariableFmi2Api(null, null, null, null, (PExp)MableAstFactory.newAStringLiteralExp((String)(((ComponentInfo)v2).getFmuIdentifier() + "." + instance2.getName())));
                    fmuNamesToFmuInstances.put(fullyQualifiedFMUInstanceName, instance2);
                    continue;
                }
                throw new RuntimeException("instance is not fmi2");
            }
            AtomicInteger indexer = new AtomicInteger();
            Map<ComponentVariableFmi2Api, VariableFmi2Api> fmuInstanceToCommunicationPoint = fmuInstances.values().stream().collect(Collectors.toMap(inst -> inst, instance -> (VariableFmi2Api)fmuCommunicationPoints.items().get(indexer.getAndIncrement())));
            Map<InstanceVariableFmi3Api, VariableFmi2Api> fmuInstance3ToCommunicationPoint = fmuInstances3.values().stream().collect(Collectors.toMap(inst -> inst, instance -> (VariableFmi2Api)fmuCommunicationPoints.items().get(indexer.getAndIncrement())));
            boolean bl = everyFMUSupportsGetState = fmuInstances.values().stream().allMatch(inst -> {
                try {
                    return inst.getModelDescription().getCanGetAndSetFmustate();
                }
                catch (XPathExpressionException e) {
                    throw new RuntimeException(e);
                }
            }) && fmuInstances3.values().stream().allMatch(inst -> {
                try {
                    return inst.getModelDescription().getCanGetAndSetFmustate();
                }
                catch (XPathExpressionException e) {
                    throw new RuntimeException(e);
                }
            });
            if (!everyFMUSupportsGetState && jacobianStepConfig.stabilisation) {
                throw new RuntimeException("Cannot use stabilisation as not every FMU supports rollback");
            }
            BooleanVariableFmi2Api allFMUsSupportGetState = dynamicScope.store("all_fmus_support_get_state", everyFMUSupportsGetState);
            JacobianVariableStepBuilder.JacobianVariableStepContext varStep = null;
            if (algorithm == StepAlgorithm.VARIABLESTEP) {
                varStep = JacobianVariableStepBuilder.init(ctxt, jacobianStepConfig, dynamicScope, builder, fmuNamesToFmuInstances);
            }
            dataWriterInstance.log(ctxt.currentCommunicationTime);
            StabilisationBuilder.StabilisationContext stabilisationCtxt = null;
            if (jacobianStepConfig.stabilisation) {
                stabilisationCtxt = StabilisationBuilder.init(dynamicScope, jacobianStepConfig);
            }
            if (jacobianStepConfig.simulationProgramDelay) {
                RealTimeSlowDownBuilder.setStartTime(ctsCtxt, dynamicScope);
            }
            ArrayList<FmiBuilder.StateVariable<PStm>> fmuStates = new ArrayList<FmiBuilder.StateVariable<PStm>>();
            BooleanVariableFmi2Api anyDiscards = dynamicScope.store("any_discards", false);
            ModelSwapBuilder.ModelSwapContext modelSwapContext = ModelSwapBuilder.buildContext(env, dynamicScope);
            WhileMaBLScope scopeFmi2Api = dynamicScope.enterWhile((FmiBuilder.Predicate)loopPredicate);
            ScopeFmi2Api stoppingThenScope = scopeFmi2Api.enterIf((FmiBuilder.Predicate)simulationControl.stopRequested().toPredicate()).enterThen();
            stoppingThenScope.add(new PStm[]{new AErrorStm((PExp)MableAstFactory.newAStringLiteralExp((String)"Simulation stopped by user"))});
            stoppingThenScope.leave();
            dynamicScope.markTransferPoint(new String[0]);
            ModelSwapBuilder.updateSwapConditionVariables(modelSwapContext, dynamicScope, componentsToPortsWithValues);
            if (everyFMUSupportsGetState) {
                for (ComponentVariableFmi2Api componentVariableFmi2Api : fmuInstances.values()) {
                    fmuStates.add(componentVariableFmi2Api.getState());
                }
                for (InstanceVariableFmi3Api instanceVariableFmi3Api : fmuInstances3.values()) {
                    fmuStates.add(instanceVariableFmi3Api.getState());
                }
            }
            if (jacobianStepConfig.stabilisation) {
                StabilisationBuilder.step(stabilisationCtxt, dynamicScope);
            }
            ModelSwapBuilder.setWithModelSwapLinking(fmuInstances, env, dynamicScope, modelSwapContext);
            fmuInstances3.values().forEach(instance -> instance.setLinked());
            if (algorithm == StepAlgorithm.VARIABLESTEP) {
                JacobianVariableStepBuilder.updateCurrentStepTiming(ctxt, varStep, dynamicScope, anyDiscards);
            }
            anyDiscards.setValue((FmiBuilder.Variable)new BooleanVariableFmi2Api(null, null, (FmiBuilder.DynamicActiveScope)dynamicScope, null, (PExp)MableAstFactory.newABoolLiteralExp((Boolean)false)));
            fmuInstanceToCommunicationPoint.forEach((instance, communicationPoint) -> {
                DoubleVariableFmi2Api communicationTime = ctxt.currentCommunicationTime;
                Map.Entry<DoubleVariableFmi2Api, Optional<PredicateFmi2Api>> swapStep = ModelSwapBuilder.updateStep(modelSwapContext, env, instance, communicationTime);
                Optional<PredicateFmi2Api> stepPredicate = swapStep.getValue();
                communicationTime = swapStep.getKey();
                stepPredicate.ifPresent(arg_0 -> ((DynamicActiveBuilderScope)dynamicScope).enterIf(arg_0));
                Map.Entry discard = instance.step((FmiBuilder.DoubleVariable)communicationTime, (FmiBuilder.DoubleVariable)ctxt.currentStepSize);
                communicationPoint.setValue((FmiBuilder.ExpressionValue)new DoubleExpressionValue(((FmiBuilder.DoubleVariable)discard.getValue()).getExp()));
                PredicateFmi2Api didDiscard = new PredicateFmi2Api(((FmiBuilder.BoolVariable)discard.getKey()).getExp()).not();
                dynamicScope.enterIf((FmiBuilder.Predicate)didDiscard);
                builder.getLogger().debug("## FMU: '%s' DISCARDED step at sim-time: %f for step-size: %f and proposed sim-time: %.15f", new Object[]{instance.getName(), communicationTime, ctxt.currentStepSize, new VariableFmi2Api(null, ((FmiBuilder.DoubleVariable)discard.getValue()).getType(), (IMablScope)dynamicScope, (FmiBuilder.DynamicActiveScope)dynamicScope, null, ((FmiBuilder.DoubleVariable)discard.getValue()).getExp())});
                anyDiscards.setValue((FmiBuilder.Variable)new BooleanVariableFmi2Api(null, null, (FmiBuilder.DynamicActiveScope)dynamicScope, null, anyDiscards.toPredicate().or(didDiscard).getExp()));
                dynamicScope.leave();
                if (stepPredicate.isPresent()) {
                    dynamicScope.leave();
                }
            });
            fmuInstance3ToCommunicationPoint.forEach((instance, communicationPoint) -> {
                DoubleVariableFmi2Api communicationTime = ctxt.currentCommunicationTime;
                Map.Entry discard = instance.step((FmiBuilder.Scope)builder.getDynamicScope(), (FmiBuilder.DoubleVariable)communicationTime, (FmiBuilder.DoubleVariable)ctxt.currentStepSize, (PExp)new ABoolLiteralExp(Boolean.valueOf(false)));
                communicationPoint.setValue((FmiBuilder.ExpressionValue)new DoubleExpressionValue(((InstanceVariableFmi3Api.StepResult)discard.getValue()).getLastSuccessfulTime().getExp()));
                PredicateFmi2Api didDiscard = new PredicateFmi2Api(((FmiBuilder.BoolVariable)discard.getKey()).getExp()).not();
                dynamicScope.enterIf((FmiBuilder.Predicate)didDiscard);
                builder.getLogger().debug("## FMU: '%s' DISCARDED step at sim-time: %f for step-size: %f and proposed sim-time: %.15f", new Object[]{instance.getName(), communicationTime, ctxt.currentStepSize, new VariableFmi2Api(null, ((InstanceVariableFmi3Api.StepResult)discard.getValue()).getLastSuccessfulTime().getType(), (IMablScope)dynamicScope, (FmiBuilder.DynamicActiveScope)dynamicScope, null, ((InstanceVariableFmi3Api.StepResult)discard.getValue()).getLastSuccessfulTime().getExp())});
                anyDiscards.setValue((FmiBuilder.Variable)new BooleanVariableFmi2Api(null, null, (FmiBuilder.DynamicActiveScope)dynamicScope, null, anyDiscards.toPredicate().or(didDiscard).getExp()));
                dynamicScope.leave();
            });
            for (Map.Entry entry : componentsToPortsWithValues.entrySet()) {
                portsToValues = (Map)entry.getValue();
                portsToValues = ((ComponentVariableFmi2Api)entry.getKey()).get((FmiBuilder.Port[])portsToValues.keySet().toArray(PortFmi2Api[]::new));
            }
            for (Map.Entry entry : instancesToPortsWithValues.entrySet()) {
                portsToValues = (Map)entry.getValue();
                InstanceVariableFmi3Api instance4 = (InstanceVariableFmi3Api)entry.getKey();
                for (PortFmi3Api p : (PortFmi3Api[])portsToValues.keySet().toArray(PortFmi3Api[]::new)) {
                    Map val = instance4.get(new FmiBuilder.Port[]{p});
                    instance4.share(val);
                }
            }
            if (jacobianStepConfig.stabilisation) {
                StabilisationBuilder.convergence(dynamicScope, componentsToPortsWithValues, stabilisationCtxt, ctxt, builder, math, booleanLogic, fmuStates);
            } else {
                componentsToPortsWithValues.forEach(ComponentVariableFmi2Api::share);
            }
            if (everyFMUSupportsGetState) {
                IfMaBlScope discardScope = dynamicScope.enterIf((FmiBuilder.Predicate)anyDiscards.toPredicate());
                fmuStates.forEach(FmiBuilder.StateVariable::set);
                ctxt.currentStepSize.setValue((FmiBuilder.DoubleExpressionValue)math.minRealFromArray(fmuCommunicationPoints).toMath().subtraction((FmiBuilder.NumericTypedReferenceExp)ctxt.currentCommunicationTime));
                builder.getLogger().debug("## Discard occurred! FMUs are rolled back and step-size reduced to: %f", new Object[]{ctxt.currentStepSize});
                dynamicScope.leave();
                discardScope.enterElse();
            }
            if (algorithm == StepAlgorithm.VARIABLESTEP) {
                JacobianVariableStepBuilder.step(ctxt, varStep, dynamicScope, builder, allFMUsSupportGetState, fmuStates, anyDiscards);
            }
            if (jacobianStepConfig.simulationProgramDelay) {
                RealTimeSlowDownBuilder.slowDown(ctsCtxt, dynamicScope, ctxt, builder);
            }
            if (everyFMUSupportsGetState) {
                dynamicScope.leave();
            }
            dynamicScope.enterIf((FmiBuilder.Predicate)anyDiscards.toPredicate().not());
            ctxt.currentCommunicationTime.setValue((FmiBuilder.DoubleExpressionValue)ctxt.currentCommunicationTime.toMath().addition((FmiBuilder.NumericTypedReferenceExp)ctxt.currentStepSize));
            ModelSwapBuilder.updateDiscardStepTime(modelSwapContext, dynamicScope, ctxt.currentStepSize);
            dataWriterInstance.log(ctxt.currentCommunicationTime);
            ctxt.currentStepSize.setValue((FmiBuilder.Variable)ctxt.stepSize);
            scopeFmi2Api.leave();
            dataWriterInstance.close();
            if (settings != null) {
                settings.setGetDerivatives = setGetDerivativesRestore;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            errorReporter.report(0, e.toString(), null);
            throw new ExpandException("Internal error: ", (Throwable)e);
        }
        return new IMaestroExpansionPlugin.EmptyRuntimeConfig();
    }
}

