/*
 * Decompiled with CFR 0.152.
 */
package org.intocps.maestro.plugin;

import java.util.List;
import java.util.Objects;
import org.intocps.maestro.framework.fmi2.api.FmiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.MablApiBuilder;
import org.intocps.maestro.framework.fmi2.api.mabl.RealTime;
import org.intocps.maestro.framework.fmi2.api.mabl.scoping.DynamicActiveBuilderScope;
import org.intocps.maestro.framework.fmi2.api.mabl.values.DoubleExpressionValue;
import org.intocps.maestro.framework.fmi2.api.mabl.variables.DoubleVariableFmi2Api;
import org.intocps.maestro.plugin.JacobianInternalBuilder;

public class RealTimeSlowDownBuilder {
    public static RealTimeSlowDownContext init(MablApiBuilder builder, List<String> imports) {
        RealTimeSlowDownContext ctsCtxt = new RealTimeSlowDownContext();
        ctsCtxt.realTimeModule = builder.getRealTimeModule();
        imports.add("RealTime");
        return ctsCtxt;
    }

    public static void setStartTime(RealTimeSlowDownContext ctsCtxt, DynamicActiveBuilderScope dynamicScope) {
        ctsCtxt.realStartTime = dynamicScope.store("real_start_time", 0.0);
        ctsCtxt.realStartTime.setValue((FmiBuilder.Variable)Objects.requireNonNull(ctsCtxt.realTimeModule).getRealTime());
    }

    public static void slowDown(RealTimeSlowDownContext ctsCtxt, DynamicActiveBuilderScope dynamicScope, JacobianInternalBuilder.BaseJacobianContext ctxt, MablApiBuilder builder) {
        DoubleVariableFmi2Api realStepTime = dynamicScope.store("real_step_time", 0.0);
        realStepTime.setValue((FmiBuilder.DoubleExpressionValue)new DoubleExpressionValue(ctsCtxt.realTimeModule.getRealTime().toMath().subtraction((FmiBuilder.NumericTypedReferenceExp)ctsCtxt.realStartTime.toMath()).getExp()));
        dynamicScope.enterIf((FmiBuilder.Predicate)realStepTime.toMath().lessThan((FmiBuilder.NumericTypedReferenceExp)ctxt.currentCommunicationTime.toMath().multiply(1000)));
        DoubleVariableFmi2Api sleepTime = dynamicScope.store("sleep_time", 0.0);
        sleepTime.setValue((FmiBuilder.DoubleExpressionValue)ctxt.currentCommunicationTime.toMath().multiply(1000).subtraction((FmiBuilder.NumericTypedReferenceExp)realStepTime));
        builder.getLogger().debug("## Simulation is ahead of real time. Sleeping for: %f MS", new Object[]{sleepTime});
        ctsCtxt.realTimeModule.sleep(sleepTime);
        dynamicScope.leave();
    }

    public static class RealTimeSlowDownContext {
        RealTime realTimeModule = null;
        DoubleVariableFmi2Api realStartTime = null;
    }
}

